/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.memberInfo;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfoSupport;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\f\u0010\t\u001a\u00020\u0005*\u00020\nH\u0002R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "Lcom/intellij/refactoring/classMembers/MemberInfoBase;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "member", "isSuperClass", "", "isCompanionMember", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;ZZ)V", "()Z", "isInterfaceClass", "Lcom/intellij/psi/PsiNamedElement;", "kotlin.refactorings.common"})
public final class KotlinMemberInfo
extends MemberInfoBase<KtNamedDeclaration> {
    private final boolean isSuperClass;
    private final boolean isCompanionMember;

    @JvmOverloads
    public KotlinMemberInfo(@NotNull KtNamedDeclaration member, boolean isSuperClass, boolean isCompanionMember) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        super((PsiElement)member);
        this.isSuperClass = isSuperClass;
        this.isCompanionMember = isCompanionMember;
        this.isStatic = member.getParent() instanceof KtFile;
        if ((member instanceof KtClass || member instanceof KtPsiClassWrapper) && this.isSuperClass) {
            if (this.isInterfaceClass((PsiNamedElement)member)) {
                Object[] objectArray = new Object[]{member.getName()};
                this.displayName = RefactoringBundle.message((String)"member.info.implements.0", (Object[])objectArray);
                this.overrides = false;
            } else {
                Object[] objectArray = new Object[]{member.getName()};
                this.displayName = RefactoringBundle.message((String)"member.info.extends.0", (Object[])objectArray);
                this.overrides = true;
            }
        } else {
            this.displayName = KotlinMemberInfoSupport.Companion.getInstance().renderMemberInfo(member);
            if (this.isCompanionMember) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)this.displayName, (String)"displayName");
                this.displayName = KotlinBundle.message((String)"member.info.companion.0", (Object[])objectArray);
            }
            this.overrides = KotlinMemberInfoSupport.Companion.getInstance().getOverrides(member);
        }
    }

    public /* synthetic */ KotlinMemberInfo(KtNamedDeclaration ktNamedDeclaration, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(ktNamedDeclaration, bl, bl2);
    }

    public final boolean isSuperClass() {
        return this.isSuperClass;
    }

    public final boolean isCompanionMember() {
        return this.isCompanionMember;
    }

    private final boolean isInterfaceClass(PsiNamedElement $this$isInterfaceClass) {
        PsiNamedElement psiNamedElement = $this$isInterfaceClass;
        return psiNamedElement instanceof KtClass ? ((KtClass)$this$isInterfaceClass).isInterface() : (psiNamedElement instanceof PsiClass ? ((PsiClass)$this$isInterfaceClass).isInterface() : (psiNamedElement instanceof KtPsiClassWrapper ? ((KtPsiClassWrapper)$this$isInterfaceClass).getPsiClass().isInterface() : false));
    }

    @JvmOverloads
    public KotlinMemberInfo(@NotNull KtNamedDeclaration member, boolean isSuperClass) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        this(member, isSuperClass, false, 4, null);
    }

    @JvmOverloads
    public KotlinMemberInfo(@NotNull KtNamedDeclaration member) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        this(member, false, false, 6, null);
    }
}

