/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFileOptions;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchFileOptionsFile;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010(\u001a\u00020\u001b2\u001a\u0010)\u001a\u0016\u0012\u0004\u0012\u00020+\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u001b0*J\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/J\f\u00100\u001a\b\u0012\u0004\u0012\u00020-01J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020-012\u0006\u00102\u001a\u00020+H&J\b\u00103\u001a\u0004\u0018\u00010+J\b\u00104\u001a\u000205H'J\u001f\u00106\u001a\u00020\u001b2\u0017\u00107\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d08\u00a2\u0006\u0002\b9J\u0010\u0010:\u001a\u00020\u001b2\b\u0010;\u001a\u0004\u0018\u00010\u0014R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "compilingScratchExecutor", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "getCompilingScratchExecutor", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "setCompilingScratchExecutor", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "ktScratchFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getKtScratchFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "<set-?>", "Lcom/intellij/openapi/module/Module;", "module", "getModule", "()Lcom/intellij/openapi/module/Module;", "moduleListeners", "", "Lkotlin/Function0;", "", "options", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFileOptions;", "getOptions", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchFileOptions;", "getProject", "()Lcom/intellij/openapi/project/Project;", "replScratchExecutor", "Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "getReplScratchExecutor", "()Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "setReplScratchExecutor", "(Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;)V", "addModuleListener", "f", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiFile;", "getExpressionAtLine", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "line", "", "getExpressions", "", "psiFile", "getPsiFile", "hasErrors", "", "saveOptions", "update", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "setModule", "value", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nScratchFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFile.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFile\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n118#2:94\n1855#3,2:95\n1#4:97\n*S KotlinDebug\n*F\n+ 1 ScratchFile.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFile\n*L\n35#1:94\n39#1:95,2\n*E\n"})
public abstract class ScratchFile {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @Nullable
    private SequentialScratchExecutor replScratchExecutor;
    @Nullable
    private ScratchExecutor compilingScratchExecutor;
    @NotNull
    private final List<Function0<Unit>> moduleListeners;
    @Nullable
    private Module module;

    public ScratchFile(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.project = project2;
        this.file = file2;
        this.moduleListeners = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public final SequentialScratchExecutor getReplScratchExecutor() {
        return this.replScratchExecutor;
    }

    public final void setReplScratchExecutor(@Nullable SequentialScratchExecutor sequentialScratchExecutor) {
        this.replScratchExecutor = sequentialScratchExecutor;
    }

    @Nullable
    public final ScratchExecutor getCompilingScratchExecutor() {
        return this.compilingScratchExecutor;
    }

    public final void setCompilingScratchExecutor(@Nullable ScratchExecutor scratchExecutor) {
        this.compilingScratchExecutor = scratchExecutor;
    }

    @Nullable
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public final List<ScratchExpression> getExpressions() {
        return (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends ScratchExpression>>(this){
            final /* synthetic */ ScratchFile this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<ScratchExpression> invoke() {
                Object object;
                block3: {
                    block2: {
                        object = this.this$0.getPsiFile();
                        if (object == null) break block2;
                        PsiFile psiFile2 = object;
                        ScratchFile scratchFile2 = this.this$0;
                        PsiFile it = psiFile2;
                        boolean bl = false;
                        List<ScratchExpression> list2 = scratchFile2.getExpressions(it);
                        object = list2;
                        if (list2 != null) break block3;
                    }
                    object = CollectionsKt.emptyList();
                }
                return object;
            }
        }));
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return (PsiFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(this){
            final /* synthetic */ ScratchFile this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final PsiFile invoke() {
                return PhysicalFileSystemUtilsKt.toPsiFile(this.this$0.getFile(), this.this$0.getProject());
            }
        }));
    }

    @Nullable
    public final KtFile getKtScratchFile() {
        PsiFile $this$safeAs$iv = this.getPsiFile();
        boolean $i$f$safeAs = false;
        PsiFile psiFile2 = $this$safeAs$iv;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        return (KtFile)psiFile2;
    }

    public final void setModule(@Nullable Module value2) {
        this.module = value2;
        Iterable $this$forEach$iv = this.moduleListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final void addModuleListener(@NotNull Function2<? super PsiFile, ? super Module, Unit> f2) {
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        this.moduleListeners.add(new Function0<Unit>(this, f2){
            final /* synthetic */ ScratchFile this$0;
            final /* synthetic */ Function2<PsiFile, Module, Unit> $f;
            {
                this.this$0 = $receiver;
                this.$f = $f;
                super(0);
            }

            public final void invoke() {
                Module selectedModule = this.this$0.getModule();
                PsiFile psiFile2 = this.this$0.getPsiFile();
                if (psiFile2 != null) {
                    this.$f.invoke((Object)psiFile2, (Object)selectedModule);
                }
            }
        });
    }

    @NotNull
    public final ScratchFileOptions getOptions() {
        Object object;
        block3: {
            block2: {
                object = this.getPsiFile();
                if (object == null || (object = object.getVirtualFile()) == null) break block2;
                Object it = object;
                boolean bl = false;
                ScratchFileOptions scratchFileOptions = ScratchFileOptionsFile.Companion.get(this.project, (VirtualFile)it);
                object = scratchFileOptions;
                if (scratchFileOptions != null) break block3;
            }
            object = new ScratchFileOptions(false, false, false, 7, null);
        }
        return object;
    }

    public final void saveOptions(@NotNull Function1<? super ScratchFileOptions, ScratchFileOptions> update2) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        PsiFile psiFile2 = this.getPsiFile();
        Object object = psiFile2 != null ? psiFile2.getVirtualFile() : null;
        if (object == null) {
            return;
        }
        VirtualFile $this$saveOptions_u24lambda_u242 = virtualFile2 = object;
        boolean bl = false;
        ScratchFileOptions scratchFileOptions = ScratchFileOptionsFile.Companion.get(this.project, $this$saveOptions_u24lambda_u242);
        if (scratchFileOptions == null) {
            scratchFileOptions = new ScratchFileOptions(false, false, false, 7, null);
        }
        ScratchFileOptions configToUpdate = scratchFileOptions;
        ScratchFileOptionsFile.Companion.set(this.project, $this$saveOptions_u24lambda_u242, (ScratchFileOptions)update2.invoke((Object)configToUpdate));
    }

    @Nullable
    public final ScratchExpression getExpressionAtLine(int line) {
        Object v1;
        block1: {
            Iterable iterable = this.getExpressions();
            for (Object t : iterable) {
                ScratchExpression it = (ScratchExpression)t;
                boolean bl = false;
                int n = it.getLineStart();
                boolean bl2 = line <= it.getLineEnd() ? n <= line : false;
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public abstract List<ScratchExpression> getExpressions(@NotNull PsiFile var1);

    @RequiresBackgroundThread
    public abstract boolean hasErrors();
}

