/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structuralsearch.predicates;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.structuralsearch.KotlinStructuralSearchUtilKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/structuralsearch/predicates/KotlinExprTypePredicate;", "Lcom/intellij/structuralsearch/impl/matcher/predicates/MatchPredicate;", "search", "", "withinHierarchy", "", "ignoreCase", "target", "baseName", "regex", "(Ljava/lang/String;ZZZLjava/lang/String;Z)V", "match", "matchedNode", "Lcom/intellij/psi/PsiElement;", "start", "", "end", "context", "Lcom/intellij/structuralsearch/impl/matcher/MatchContext;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.code-insight.structural-search.k1"})
@SourceDebugExtension(value={"SMAP\nKotlinExprTypePredicate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExprTypePredicate.kt\norg/jetbrains/kotlin/idea/structuralsearch/predicates/KotlinExprTypePredicate\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n14#2:62\n1747#3,3:63\n1747#3,2:66\n1747#3,3:68\n1749#3:71\n*S KotlinDebug\n*F\n+ 1 KotlinExprTypePredicate.kt\norg/jetbrains/kotlin/idea/structuralsearch/predicates/KotlinExprTypePredicate\n*L\n32#1:62\n47#1:63,3\n53#1:66,2\n54#1:68,3\n53#1:71\n*E\n"})
public final class KotlinExprTypePredicate
extends MatchPredicate {
    @NotNull
    private final String search;
    private final boolean withinHierarchy;
    private final boolean ignoreCase;
    private final boolean target;
    @NotNull
    private final String baseName;
    private final boolean regex;

    public KotlinExprTypePredicate(@NotNull String search2, boolean withinHierarchy, boolean ignoreCase, boolean target2, @NotNull String baseName, boolean regex) {
        Intrinsics.checkNotNullParameter((Object)search2, (String)"search");
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        this.search = search2;
        this.withinHierarchy = withinHierarchy;
        this.ignoreCase = ignoreCase;
        this.target = target2;
        this.baseName = baseName;
        this.regex = regex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean match(@NotNull PsiElement matchedNode, int start2, int end, @NotNull MatchContext context2) {
        List list2;
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement node2 = StructuralSearchUtil.getParentIfIdentifier((PsiElement)matchedNode);
        if (node2 instanceof KtDeclaration) {
            kotlinType = KotlinStructuralSearchUtilKt.resolveDeclType((KtDeclaration)node2);
        } else if (node2 instanceof KtExpression) {
            kotlinType = KotlinStructuralSearchUtilKt.resolveExprType((KtExpression)node2);
            if (kotlinType == null) {
                PsiElement psiElement3 = ((KtExpression)node2).getParent();
                psiElement3 = psiElement3;
                if (psiElement2 == null) return false;
                PsiElement $this$asSafely$iv = psiElement3;
                boolean $i$f$asSafely = false;
                PsiElement psiElement4 = $this$asSafely$iv;
                if (!(psiElement4 instanceof KtDotQualifiedExpression)) {
                    psiElement4 = null;
                }
                KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement4;
                psiElement3 = ktDotQualifiedExpression;
                if (ktDotQualifiedExpression == null) return false;
                kotlinType = KotlinStructuralSearchUtilKt.resolveExprType((KtExpression)psiElement3);
            }
        } else {
            if (node2 instanceof KtStringTemplateEntry && !(node2 instanceof KtSimpleNameStringTemplateEntry)) {
                return false;
            }
            if (!(node2 instanceof KtSimpleNameStringTemplateEntry)) return false;
            KtExpression ktExpression = ((KtSimpleNameStringTemplateEntry)node2).getExpression();
            if (ktExpression == null) return false;
            kotlinType = UtilsKt.resolveType$default(ktExpression, null, 1, null);
        }
        if (kotlinType == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        if (this.regex) {
            list2 = CollectionsKt.emptyList();
        } else {
            char[] cArray = new char[]{'|'};
            list2 = StringsKt.split$default((CharSequence)this.search, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        List searchedTypeNames = list2;
        if (!(matchedNode instanceof KtExpression)) return this.match(type2);
        if (!PsiUtilsKt.isNull((KtExpression)((KtExpression)matchedNode))) return this.match(type2);
        if (!searchedTypeNames.contains("null")) return this.match(type2);
        return true;
    }

    public final boolean match(@NotNull KotlinType type2) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Object[] objectArray = new KotlinType[]{type2};
            List typesToTest = CollectionsKt.mutableListOf((Object[])objectArray);
            if (this.withinHierarchy) {
                typesToTest.addAll(TypeUtilsKt.supertypes((KotlinType)type2));
            }
            if (this.regex) {
                boolean bl2;
                block11: {
                    RegExpPredicate delegate = new RegExpPredicate(this.search, !this.ignoreCase, this.baseName, false, this.target);
                    Iterable $this$any$iv = typesToTest;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object t : $this$any$iv) {
                            KotlinType it = (KotlinType)t;
                            boolean bl3 = false;
                            boolean bl4 = delegate.match(DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(it)) || delegate.match(DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(it));
                            if (!bl4) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                }
                return bl2;
            }
            Object $this$any$iv = new char[]{'|'};
            List searchedTypeNames = StringsKt.split$default((CharSequence)this.search, (char[])$this$any$iv, (boolean)false, (int)0, (int)6, null);
            $this$any$iv = searchedTypeNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object t : $this$any$iv) {
                    boolean bl5;
                    block12: {
                        String templateTypeName = (String)t;
                        boolean bl6 = false;
                        Iterable $this$any$iv2 = typesToTest;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                KotlinType typeToTest = (KotlinType)element$iv2;
                                boolean bl7 = false;
                                boolean bl8 = Intrinsics.areEqual((Object)templateTypeName, (Object)DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(typeToTest)) || Intrinsics.areEqual((Object)templateTypeName, (Object)DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(typeToTest));
                                if (!bl8) continue;
                                bl5 = true;
                                break block12;
                            }
                            bl5 = false;
                        }
                    }
                    if (!bl5) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        return bl;
    }
}

