/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.suggestions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.suggestions.KotlinNotebookSuggestionProviderKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/suggestions/KotlinNotebookPluginSuggestion;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "isCommunity", "", "(Lcom/intellij/openapi/project/Project;Z)V", "pluginIds", "", "", "getPluginIds", "()Ljava/util/List;", "apply", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "dismissPluginSuggestion", "", "setupCommercialIdeSuggestion", "panel", "setupPluginSuggestion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/KotlinNotebookPluginSuggestion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1549#2:130\n1620#2,3:131\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/KotlinNotebookPluginSuggestion\n*L\n123#1:130\n123#1:131,3\n*E\n"})
public final class KotlinNotebookPluginSuggestion
implements PluginSuggestion {
    @NotNull
    private final Project project;
    private final boolean isCommunity;
    @NotNull
    private final List<String> pluginIds;

    public KotlinNotebookPluginSuggestion(@NotNull Project project2, boolean isCommunity) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.isCommunity = isCommunity;
        this.pluginIds = KotlinNotebookSuggestionProviderKt.access$getKOTLIN_NOTEBOOKS_ALL_PLUGIN_IDS$p();
    }

    @NotNull
    public List<String> getPluginIds() {
        return this.pluginIds;
    }

    @Nullable
    public EditorNotificationPanel apply(@NotNull FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        EditorNotificationPanel.Status status = this.isCommunity ? EditorNotificationPanel.Status.Promo : EditorNotificationPanel.Status.Info;
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, status);
        if (this.isCommunity) {
            this.setupCommercialIdeSuggestion(panel2);
        } else {
            this.setupPluginSuggestion(panel2);
        }
        panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> KotlinNotebookPluginSuggestion.apply$lambda$0(this));
        return panel2;
    }

    private final void dismissPluginSuggestion() {
        PropertiesComponent.getInstance().setValue(KotlinNotebookSuggestionProviderKt.access$getKOTLIN_NOTEBOOKS_PLUGIN_SUGGESTION_DISMISSED_KEY$p(), true);
    }

    private final void setupCommercialIdeSuggestion(EditorNotificationPanel panel2) {
        SuggestedIde suggestedIde = PluginAdvertiserService.Companion.getIde("IU");
        if (suggestedIde == null) {
            throw new IllegalStateException("Could not find IntelliJ Ultimate reference".toString());
        }
        SuggestedIde ultimateIde = suggestedIde;
        Object[] objectArray = new Object[]{KotlinNotebookSuggestionProviderKt.access$getKOTLIN_NOTEBOOKS_PLUGIN_FILES$p(), ultimateIde.getName()};
        panel2.setText(IdeBundle.message((String)"plugins.advertiser.extensions.supported.in.ultimate", (Object[])objectArray));
        PluginAdvertiserServiceKt.createTryUltimateActionLabel$default((EditorNotificationPanel)panel2, (SuggestedIde)ultimateIde, (Project)this.project, (PluginId)PluginId.getId((String)KotlinNotebookSuggestionProviderKt.access$getKOTLIN_NOTEBOOKS_PRIMARY_PLUGIN_ID$p()), null, (int)8, null);
    }

    private final void setupPluginSuggestion(EditorNotificationPanel panel2) {
        Object[] objectArray = new Object[]{KotlinNotebookSuggestionProviderKt.access$getKOTLIN_NOTEBOOKS_PLUGIN_FILES$p()};
        panel2.setText(IdeBundle.message((String)"plugins.advertiser.plugins.found", (Object[])objectArray));
        objectArray = new Object[]{KotlinNotebookSuggestionProviderKt.access$getKOTLIN_NOTEBOOKS_PLUGIN_NAME$p()};
        panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.install.plugin.name", (Object[])objectArray), () -> KotlinNotebookPluginSuggestion.setupPluginSuggestion$lambda$2(this));
    }

    private static final void apply$lambda$0(KotlinNotebookPluginSuggestion this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FUSEventSource.EDITOR.logIgnoreExtension(this$0.project);
        this$0.dismissPluginSuggestion();
        EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
    }

    private static final void setupPluginSuggestion$lambda$2$lambda$1(KotlinNotebookPluginSuggestion this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
    }

    /*
     * WARNING - void declaration
     */
    private static final void setupPluginSuggestion$lambda$2(KotlinNotebookPluginSuggestion this$0) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        List pluginIds = KotlinNotebookSuggestionProviderKt.access$getKOTLIN_NOTEBOOKS_ALL_PLUGIN_IDS$p();
        FUSEventSource.EDITOR.logInstallPlugins(pluginIds, this$0.project);
        Iterable iterable = pluginIds;
        Project project2 = this$0.project;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PluginId.getId((String)p0));
        }
        PluginsAdvertiser.installAndEnable$default((Project)project2, (Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (boolean)true, (boolean)false, null, () -> KotlinNotebookPluginSuggestion.setupPluginSuggestion$lambda$2$lambda$1(this$0), (int)24, null);
    }
}

