/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.util.ElementKind;
import org.jetbrains.kotlin.idea.util.FindElementUtils;
import org.jetbrains.kotlin.idea.util.FindElementUtils$findExpression$;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001aA\u0010\t\u001a\u0004\u0018\u0001H\n\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0002\u00a2\u0006\u0002\u0010\r\u001a1\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0011\u001aO\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\"\u0010\u0014\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f0\u000f\"\n\u0012\u0006\b\u0001\u0012\u00020\u00010\fH\u0007\u00a2\u0006\u0002\u0010\u0015\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\bH\u0002\u001a\u0014\u0010\u001f\u001a\u00020\u001e*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a8\u0006 "}, d2={"findElement", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "startOffset", "", "endOffset", "elementKind", "Lorg/jetbrains/kotlin/idea/util/ElementKind;", "findElementOfClassAtRange", "T", "aClass", "Ljava/lang/Class;", "(Lcom/intellij/psi/PsiFile;IILjava/lang/Class;)Lcom/intellij/psi/PsiElement;", "findElements", "", "kind", "(Lcom/intellij/psi/PsiFile;IILorg/jetbrains/kotlin/idea/util/ElementKind;)[Lcom/intellij/psi/PsiElement;", "findElementsOfClassInRange", "", "classes", "(Lcom/intellij/psi/PsiFile;II[Ljava/lang/Class;)Ljava/util/List;", "findExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getParentLabelOrElement", "getTopmostParentInside", "parent", "matchesKind", "", "matchesKindOrCanBeSkipped", "kotlin.base.code-insight"})
@JvmName(name="FindElementUtils")
@SourceDebugExtension(value={"SMAP\nfindElementUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 findElementUtils.kt\norg/jetbrains/kotlin/idea/util/FindElementUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,197:1\n1#2:198\n1726#3,3:199\n223#4,2:202\n473#5:204\n*S KotlinDebug\n*F\n+ 1 findElementUtils.kt\norg/jetbrains/kotlin/idea/util/FindElementUtils\n*L\n100#1:199,3\n166#1:202,2\n166#1:204\n*E\n"})
public final class FindElementUtils {
    @Nullable
    public static final PsiElement findElement(@NotNull PsiFile file2, int startOffset, int endOffset2, @NotNull ElementKind elementKind) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)elementKind), (String)"elementKind");
        KtElement ktElement = FindElementUtils.findElementOfClassAtRange(file2, startOffset, endOffset2, elementKind.getElementClass());
        if (ktElement == null) {
            return null;
        }
        KtElement element3 = ktElement;
        return switch (WhenMappings.$EnumSwitchMapping$0[elementKind.ordinal()]) {
            case 1 -> (PsiElement)element3;
            case 2 -> {
                KtElement var5_5 = element3;
                PsiElement p0 = (PsiElement)var5_5;
                boolean $i$a$-takeIf-FindElementUtils$findElement$1 = false;
                yield (PsiElement)(KtPsiUtilKt.isTypeConstructorReference((PsiElement)p0) ? var5_5 : null);
            }
            case 3 -> (PsiElement)FindElementUtils.findExpression(element3);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final <T extends PsiElement> T findElementOfClassAtRange(PsiFile file2, int startOffset, int endOffset2, Class<T> aClass) {
        PsiElement psiElement2 = FindElementUtils.getParentLabelOrElement(KotlinPsiUtils.getElementAtOffsetIgnoreWhitespaceBefore(file2, startOffset));
        if (psiElement2 == null) {
            return null;
        }
        PsiElement element12 = psiElement2;
        PsiElement psiElement3 = FindElementUtils.getParentLabelOrElement(KotlinPsiUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, endOffset2));
        if (psiElement3 == null) {
            return null;
        }
        PsiElement element22 = psiElement3;
        int newStartOffset = PsiUtilsKt.getStartOffset((PsiElement)element12);
        int newEndOffset = PsiUtilsKt.getEndOffset((PsiElement)element22);
        PsiElement psiElement4 = PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)newStartOffset, (int)newEndOffset, aClass);
        if (psiElement4 == null) {
            return null;
        }
        PsiElement newElement2 = psiElement4;
        if (PsiUtilsKt.getStartOffset((PsiElement)newElement2) != newStartOffset || PsiUtilsKt.getEndOffset((PsiElement)newElement2) != newEndOffset) {
            return null;
        }
        return (T)newElement2;
    }

    private static final PsiElement getParentLabelOrElement(PsiElement element3) {
        return element3 != null && element3.getParent() instanceof KtLabelReferenceExpression ? element3.getParent() : element3;
    }

    @NotNull
    public static final PsiElement[] findElements(@NotNull PsiFile file2, int startOffset, int endOffset2, @NotNull ElementKind kind2) {
        boolean bl;
        List result2;
        block12: {
            int newEndOffset;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
            PsiElement psiElement2 = KotlinPsiUtils.getElementAtOffsetIgnoreWhitespaceBefore(file2, startOffset);
            if (psiElement2 == null) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }
            PsiElement element12 = psiElement2;
            PsiElement psiElement3 = KotlinPsiUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, endOffset2);
            if (psiElement3 == null) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }
            PsiElement element22 = psiElement3;
            int newStartOffset = PsiUtilsKt.getStartOffset((PsiElement)element12);
            if (newStartOffset >= (newEndOffset = PsiUtilsKt.getEndOffset((PsiElement)element22))) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }
            PsiElement psiElement4 = PsiTreeUtil.findCommonParent((PsiElement)element12, (PsiElement)element22);
            if (psiElement4 == null) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }
            PsiElement parent2 = psiElement4;
            while (!(parent2 instanceof KtBlockExpression)) {
                if (parent2 == null || parent2 instanceof KtFile) {
                    Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    return PsiElement.EMPTY_ARRAY;
                }
                parent2 = parent2.getParent();
            }
            if (newStartOffset != PsiUtilsKt.getStartOffset((PsiElement)(element12 = FindElementUtils.getTopmostParentInside(element12, parent2)))) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }
            if (newEndOffset != PsiUtilsKt.getEndOffset((PsiElement)(element22 = FindElementUtils.getTopmostParentInside(element22, parent2)))) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }
            PsiElement stopElement = element22.getNextSibling();
            result2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)element12, (boolean)false, (boolean)false, (int)3, null), (Function1)((Function1)new Function1<PsiElement, Boolean>(stopElement){
                final /* synthetic */ PsiElement $stopElement;
                {
                    this.$stopElement = $stopElement;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it != this.$stopElement;
                }
            })), (Function1)findElements.result.2.INSTANCE));
            Iterable $this$all$iv = result2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (FindElementUtils.matchesKindOrCanBeSkipped(it, kind2)) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)result2);
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"toPsiElementArray(...)");
            return psiElementArray;
        }
        Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return PsiElement.EMPTY_ARRAY;
    }

    @SafeVarargs
    @NotNull
    public static final List<PsiElement> findElementsOfClassInRange(@NotNull PsiFile file2, int startOffset, int endOffset2, Class<? extends PsiElement> ... classes2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(classes2, (String)"classes");
        PsiElement element12 = KotlinPsiUtils.getElementAtOffsetIgnoreWhitespaceBefore(file2, startOffset);
        PsiElement element22 = KotlinPsiUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, endOffset2);
        if (element12 == null || element22 == null) {
            return CollectionsKt.emptyList();
        }
        int newStartOffset = PsiUtilsKt.getStartOffset((PsiElement)element12);
        int newEndOffset = PsiUtilsKt.getEndOffset((PsiElement)element22);
        PsiElement psiElement2 = PsiTreeUtil.findCommonParent((PsiElement)element12, (PsiElement)element22);
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement parent2 = psiElement2;
        if (newStartOffset != PsiUtilsKt.getStartOffset((PsiElement)(element12 = FindElementUtils.getTopmostParentInside(element12, parent2)))) {
            return CollectionsKt.emptyList();
        }
        if (newEndOffset != PsiUtilsKt.getEndOffset((PsiElement)(element22 = FindElementUtils.getTopmostParentInside(element22, parent2)))) {
            return CollectionsKt.emptyList();
        }
        PsiElement stopElement = element22.getNextSibling();
        List result2 = new ArrayList();
        for (PsiElement currentElement = element12; currentElement != stopElement && currentElement != null; currentElement = currentElement.getNextSibling()) {
            for (Class<? extends PsiElement> aClass : classes2) {
                if (aClass.isInstance(currentElement)) {
                    result2.add(currentElement);
                }
                Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)currentElement, aClass);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
                result2.addAll(collection);
            }
        }
        if (!Intrinsics.areEqual((Object)parent2, (Object)element12) && PsiUtilsKt.getStartOffset((PsiElement)parent2) == newStartOffset) {
            for (Class<? extends PsiElement> aClass : classes2) {
                if (!aClass.isInstance(parent2)) continue;
                result2.add(parent2);
            }
        }
        return result2;
    }

    private static final boolean matchesKindOrCanBeSkipped(PsiElement $this$matchesKindOrCanBeSkipped, ElementKind kind2) {
        return FindElementUtils.matchesKind($this$matchesKindOrCanBeSkipped, kind2) || $this$matchesKindOrCanBeSkipped.getNode().getElementType() == KtTokens.SEMICOLON || $this$matchesKindOrCanBeSkipped instanceof PsiWhiteSpace || $this$matchesKindOrCanBeSkipped instanceof PsiComment;
    }

    private static final boolean matchesKind(PsiElement $this$matchesKind, ElementKind kind2) {
        return kind2 == ElementKind.EXPRESSION && $this$matchesKind instanceof KtExpression || kind2 == ElementKind.TYPE_ELEMENT && $this$matchesKind instanceof KtTypeElement || kind2 == ElementKind.TYPE_CONSTRUCTOR && KtPsiUtilKt.isTypeConstructorReference((PsiElement)$this$matchesKind);
    }

    private static final PsiElement getTopmostParentInside(PsiElement element3, PsiElement parent2) {
        PsiElement node2 = element3;
        if (!Intrinsics.areEqual((Object)parent2, (Object)node2)) {
            while (!Intrinsics.areEqual((Object)parent2, (Object)node2.getParent())) {
                Intrinsics.checkNotNullExpressionValue((Object)node2.getParent(), (String)"getParent(...)");
            }
        }
        return node2;
    }

    private static final KtExpression findExpression(KtElement element3) {
        KtElement ktElement;
        KtElement expression2 = element3;
        if (expression2 instanceof KtScript) {
            PsiElement $this$descendantsOfType_u24default$iv = (PsiElement)expression2;
            boolean childrenFirst$iv = false;
            boolean $i$f$descendantsOfType = false;
            Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)findExpression$$inlined$descendantsOfType$default$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            KtScriptInitializer ktScriptInitializer = (KtScriptInitializer)SequencesKt.singleOrNull((Sequence)sequence2);
            if (ktScriptInitializer == null) {
                return null;
            }
            expression2 = (KtElement)ktScriptInitializer;
        }
        if (expression2 instanceof KtScriptInitializer) {
            KtExpression ktExpression = ((KtScriptInitializer)expression2).getBody();
            if (ktExpression == null) {
                return null;
            }
            expression2 = (KtElement)ktExpression;
        }
        if (expression2 instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)expression2).getReferencedNameElementType() != KtTokens.IDENTIFIER && expression2.getParent() instanceof KtBinaryExpression) {
            return null;
        }
        if (KtPsiUtil.isLabelIdentifierExpression((PsiElement)((PsiElement)expression2))) {
            KtExpression ktExpression = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), KtExpression.class);
            if (ktExpression == null) {
                return null;
            }
            expression2 = (KtElement)ktExpression;
        }
        if (expression2 instanceof KtBlockExpression) {
            KtExpression statement2;
            List list2 = ((KtBlockExpression)expression2).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            List statements2 = list2;
            if (statements2.size() == 1 && Intrinsics.areEqual((Object)(statement2 = (KtExpression)statements2.get(0)).getText(), (Object)((KtBlockExpression)expression2).getText())) {
                return statement2;
            }
        }
        return (ktElement = expression2) instanceof KtExpression ? (KtExpression)ktElement : null;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ElementKind.values().length];
            try {
                nArray[ElementKind.TYPE_ELEMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementKind.TYPE_CONSTRUCTOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementKind.EXPRESSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

