/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding.k2.satisfaction.survey;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialogWithEmail;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.onboarding.FeedbackBundle;
import org.jetbrains.kotlin.onboarding.FeedbackNotificationWithKotlinLogo;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2FeedbackDialog;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2UserTracker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\bH\u0016J \u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2FeedbackSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "()V", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "suitableIdeVersion", "", "Lorg/jetbrains/annotations/NotNull;", "surveyId", "getSurveyId", "()Ljava/lang/String;", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "checkIdeIsSuitable", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialogWithEmail;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "forTest", "createNotification", "Lorg/jetbrains/kotlin/onboarding/FeedbackNotificationWithKotlinLogo;", "updateStateAfterDialogClosedOk", "", "updateStateAfterNotificationShowed", "kotlin.onboarding"})
public final class K2FeedbackSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2024, 11, 1);
    private final boolean requireIdeEAP;
    @NotNull
    private final String suitableIdeVersion;

    public K2FeedbackSurveyConfig() {
        this.surveyId = "k2_feedback";
        String string = Registry.stringValue((String)"k2.feedback.survey.ide.version.number");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
        this.suitableIdeVersion = string;
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isIdeaUltimate() || PlatformUtils.isIdeaCommunity();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return Intrinsics.areEqual((Object)this.suitableIdeVersion, (Object)ApplicationInfo.getInstance().getShortVersion()) && K2UserTracker.Companion.getInstance().shouldShowK2FeedbackDialog$kotlin_onboarding(project2);
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        K2UserTracker.Companion.getInstance().getState().setUserSawSurvey(true);
    }

    @NotNull
    public BlockBasedFeedbackDialogWithEmail<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project2, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new K2FeedbackDialog(project2, forTest);
    }

    @NotNull
    public FeedbackNotificationWithKotlinLogo createNotification(@NotNull Project project2, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new FeedbackNotificationWithKotlinLogo("Feedback In IDE", FeedbackBundle.INSTANCE.message("notification.k2.satisfaction.request.title", new Object[0]), FeedbackBundle.INSTANCE.message("notification.k2.satisfaction.request.content", new Object[0]));
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
    }
}

