/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.CommonBundle;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.history.integration.ui.views.RevisionProcessingProgressAdapter;
import com.intellij.history.integration.ui.views.RevisionsList;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.CreatePatchConfigurationPanel;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import com.intellij.project.ProjectKt;
import com.intellij.ui.ExcludingTraversalPolicy;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HistoryDialog<T extends HistoryDialogModel>
extends FrameWrapper {
    private static final int UPDATE_DIFFS = 1;
    private static final int UPDATE_REVS = 2;
    @NotNull
    protected final Project myProject;
    protected final IdeaGateway myGateway;
    protected final VirtualFile myFile;
    private Splitter mySplitter;
    protected RevisionsList myRevisionsList;
    private JBLoadingPanel myDiffView;
    private ActionToolbar myToolBar;
    protected boolean myForceUpdateDiff;
    protected T myModel;
    private MergingUpdateQueue myUpdateQueue;
    private boolean isUpdating;

    protected HistoryDialog(@NotNull Project project, IdeaGateway gw, VirtualFile f, boolean doInit) {
        if (project == null) {
            HistoryDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProject = project;
        this.myGateway = gw;
        this.myFile = f;
        this.setImages((List)DiffUtil.DIFF_FRAME_ICONS.getValue());
        this.closeOnEsc();
        if (doInit) {
            this.init();
        }
    }

    @Nullable
    protected String getDimensionKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void init() {
        LocalHistoryFacade facade = LocalHistoryImpl.getInstanceImpl().getFacade();
        this.myModel = this.createModel(facade);
        this.setTitle(((HistoryDialogModel)this.myModel).getTitle());
        JComponent root = this.createComponent();
        this.setComponent(root);
        this.setPreferredFocusedComponent(this.showRevisionsList() ? this.myRevisionsList.getComponent() : this.myDiffView);
        this.myUpdateQueue = new MergingUpdateQueue(((Object)((Object)this)).getClass() + ".revisionsUpdate", 500, true, root, (Disposable)this, null, false);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        facade.addListener(new LocalHistoryFacade.Listener(){

            @Override
            public void changeSetFinished(@NotNull ChangeSet changeSet) {
                if (changeSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                HistoryDialog.this.scheduleRevisionsUpdate(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeSet", "com/intellij/history/integration/ui/views/HistoryDialog$1", "changeSetFinished"));
            }
        }, (Disposable)this);
        this.scheduleRevisionsUpdate(null);
    }

    protected void scheduleRevisionsUpdate(@Nullable Consumer<? super T> configRunnable) {
        this.doScheduleUpdate(2, (Computable<Runnable>)((Computable)() -> {
            T t = this.myModel;
            synchronized (t) {
                if (configRunnable != null) {
                    configRunnable.consume(this.myModel);
                }
                ((HistoryDialogModel)this.myModel).clearRevisions();
                LocalHistoryCounter.INSTANCE.logLoadItems(this.myProject, ((HistoryDialogModel)this.myModel).getKind(), () -> ((HistoryDialogModel)this.myModel).getRevisions());
            }
            return () -> this.myRevisionsList.updateData((HistoryDialogModel)this.myModel);
        }));
    }

    protected List<RevisionItem> getRevisions() {
        return this.myModel == null ? Collections.emptyList() : ((HistoryDialogModel)this.myModel).getRevisions();
    }

    protected abstract T createModel(LocalHistoryFacade var1);

    protected JComponent createComponent() {
        JPanel root = new JPanel(new BorderLayout());
        ExcludingTraversalPolicy traversalPolicy = new ExcludingTraversalPolicy(new Component[0]);
        root.setFocusTraversalPolicy((FocusTraversalPolicy)traversalPolicy);
        root.setFocusTraversalPolicyProvider(true);
        Pair<JComponent, Dimension> diffAndToolbarSize = this.createDiffPanel(root, traversalPolicy);
        this.myDiffView = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 200);
        this.myDiffView.add((Component)diffAndToolbarSize.first, (Object)"Center");
        JComponent revisionsSide = this.createRevisionsSide((Dimension)diffAndToolbarSize.second);
        if (this.showRevisionsList()) {
            this.mySplitter = new Splitter(false, 0.3f);
            this.mySplitter.setFirstComponent(revisionsSide);
            this.mySplitter.setSecondComponent((JComponent)this.myDiffView);
            this.restoreSplitterProportion();
            root.add((Component)this.mySplitter);
            this.setDiffBorder(IdeBorderFactory.createBorder((int)3));
        } else {
            this.setDiffBorder(IdeBorderFactory.createBorder((int)10));
            root.add((Component)this.myDiffView);
        }
        return root;
    }

    protected boolean showRevisionsList() {
        return true;
    }

    protected abstract void setDiffBorder(Border var1);

    public void dispose() {
        this.saveSplitterProportion();
        super.dispose();
    }

    protected abstract Pair<JComponent, Dimension> createDiffPanel(JPanel var1, ExcludingTraversalPolicy var2);

    @NotNull
    private JComponent createRevisionsSide(Dimension prefToolBarSize) {
        ActionGroup actions = this.createRevisionsActions();
        this.myToolBar = HistoryDialog.createRevisionsToolbar(actions);
        this.myRevisionsList = new RevisionsList(new RevisionsList.SelectionListener(){

            @Override
            public void revisionsSelected(int first, int last) {
                HistoryDialog.this.scheduleDiffUpdate((Couple<Integer>)Couple.of((Object)first, (Object)last));
            }
        });
        this.myToolBar.setTargetComponent(this.myRevisionsList.getComponent());
        PopupHandler.installPopupMenu((JComponent)this.myRevisionsList.getComponent(), (ActionGroup)actions, (String)"LvcsRevisionsListPopup");
        JPanel result2 = new JPanel(new BorderLayout());
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        toolBarPanel.add((Component)this.myToolBar.getComponent(), "West");
        this.addExtraToolbar(toolBarPanel);
        if (prefToolBarSize != null) {
            toolBarPanel.setPreferredSize(new Dimension(1, prefToolBarSize.height));
        }
        result2.add((Component)toolBarPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myRevisionsList.getComponent());
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)6));
        result2.add((Component)scrollPane, "Center");
        JPanel jPanel = result2;
        if (jPanel == null) {
            HistoryDialog.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    protected void addExtraToolbar(JPanel toolBarPanel) {
    }

    @NotNull
    private static ActionToolbar createRevisionsToolbar(ActionGroup actions) {
        ActionManager am = ActionManager.getInstance();
        ActionToolbar actionToolbar = am.createActionToolbar("HistoryDialogRevisions", actions, true);
        if (actionToolbar == null) {
            HistoryDialog.$$$reportNull$$$0(2);
        }
        return actionToolbar;
    }

    @NotNull
    private ActionGroup createRevisionsActions() {
        DefaultActionGroup result2 = new DefaultActionGroup();
        result2.add((AnAction)new RevertAction());
        result2.add((AnAction)new CreatePatchAction());
        result2.add((AnAction)Separator.getInstance());
        result2.add((AnAction)new ContextHelpAction(this.getHelpId()));
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            HistoryDialog.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    private void scheduleDiffUpdate(@Nullable Couple<Integer> toSelect) {
        this.doScheduleUpdate(1, (Computable<Runnable>)((Computable)() -> {
            T t = this.myModel;
            synchronized (t) {
                boolean changed = toSelect == null ? ((HistoryDialogModel)this.myModel).resetSelection() : ((HistoryDialogModel)this.myModel).selectRevisions((Integer)toSelect.first, (Integer)toSelect.second);
                this.myForceUpdateDiff = false;
                if (changed |= this.myForceUpdateDiff) {
                    return (Runnable)LocalHistoryCounter.INSTANCE.logLoadDiff(this.myProject, ((HistoryDialogModel)this.myModel).getKind(), () -> this.doUpdateDiffs(this.myModel));
                }
                return EmptyRunnable.getInstance();
            }
        }));
    }

    private void doScheduleUpdate(int id, final Computable<? extends Runnable> update) {
        this.myUpdateQueue.queue(new Update((Object)this, id){

            public boolean canEat(@NotNull Update update1) {
                if (update1 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return this.getPriority() >= update1.getPriority();
            }

            public void run() {
                if (this.isDisposed() || HistoryDialog.this.myProject.isDisposed()) {
                    return;
                }
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (this.isDisposed() || HistoryDialog.this.myProject.isDisposed()) {
                        return;
                    }
                    HistoryDialog.this.isUpdating = true;
                    HistoryDialog.this.updateActions();
                    HistoryDialog.this.myDiffView.startLoading();
                });
                Runnable apply = null;
                try {
                    apply = (Runnable)update.compute();
                }
                catch (Exception e) {
                    LocalHistoryLog.LOG.error((Throwable)e);
                }
                Runnable finalApply = apply;
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (this.isDisposed() || HistoryDialog.this.myProject.isDisposed()) {
                        return;
                    }
                    HistoryDialog.this.isUpdating = false;
                    if (finalApply != null) {
                        try {
                            finalApply.run();
                        }
                        catch (Exception e) {
                            LocalHistoryLog.LOG.error((Throwable)e);
                        }
                    }
                    HistoryDialog.this.updateActions();
                    HistoryDialog.this.myDiffView.stopLoading();
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update1", "com/intellij/history/integration/ui/views/HistoryDialog$3", "canEat"));
            }
        });
    }

    protected void updateActions() {
        if (this.showRevisionsList()) {
            this.myToolBar.updateActionsImmediately();
        }
    }

    protected abstract Runnable doUpdateDiffs(T var1);

    protected ContentDiffRequest createDifference(final FileDifferenceModel m) {
        return (ContentDiffRequest)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<ContentDiffRequest, RuntimeException>(this.myProject, LocalHistoryBundle.message("message.processing.revisions", new Object[0]), false){

            protected ContentDiffRequest compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                RevisionProcessingProgressAdapter p = new RevisionProcessingProgressAdapter(indicator);
                return FileDifferenceModel.createRequest(m, p);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/history/integration/ui/views/HistoryDialog$4", "compute"));
            }
        });
    }

    private void saveSplitterProportion() {
        SplitterProportionsDataImpl d = new SplitterProportionsDataImpl();
        d.saveSplitterProportions((Component)this.mySplitter);
        d.externalizeToDimensionService(this.getDimensionKey());
    }

    private void restoreSplitterProportion() {
        SplitterProportionsDataImpl d = new SplitterProportionsDataImpl();
        d.externalizeFromDimensionService(this.getDimensionKey());
        d.restoreSplitterProportions((Component)this.mySplitter);
    }

    protected abstract String getHelpId();

    protected void revert() {
        this.revert(((HistoryDialogModel)this.myModel).createReverter());
    }

    private boolean isRevertEnabled() {
        return ((HistoryDialogModel)this.myModel).isRevertEnabled();
    }

    protected void revert(Reverter r) {
        try {
            List<String> errors = r.checkCanRevert();
            if (!errors.isEmpty()) {
                this.showError(LocalHistoryBundle.message("message.cannot.revert.because", HistoryDialog.formatErrors(errors)));
                return;
            }
            r.revert();
            this.showNotification(r.getCommandName());
        }
        catch (Exception e) {
            this.showError(LocalHistoryBundle.message("message.error.during.revert", e));
        }
    }

    private void showNotification(@NlsContexts.PopupContent String title) {
        SwingUtilities.invokeLater(() -> {
            Balloon b = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(title, null, MessageType.INFO.getPopupBackground(), null).setFadeoutTime(3000L).setShowCallout(false).createBalloon();
            Dimension size = this.myDiffView.getSize();
            RelativePoint point = new RelativePoint((Component)this.myDiffView, new Point(size.width / 2, size.height / 2));
            b.show(point, Balloon.Position.above);
        });
    }

    private static String formatErrors(@NotNull List<String> errors) {
        if (errors == null) {
            HistoryDialog.$$$reportNull$$$0(4);
        }
        if (errors.size() == 1) {
            return errors.get(0);
        }
        StringBuilder result2 = new StringBuilder();
        for (String e : errors) {
            result2.append("\n    -").append(e);
        }
        return result2.toString();
    }

    private boolean isCreatePatchEnabled() {
        return ((HistoryDialogModel)this.myModel).isCreatePatchEnabled();
    }

    private void createPatch() {
        try {
            if (!((HistoryDialogModel)this.myModel).canPerformCreatePatch()) {
                this.showError(LocalHistoryBundle.message("message.cannot.create.patch.because.of.unavailable.content", new Object[0]));
                return;
            }
            CreatePatchConfigurationPanel p = new CreatePatchConfigurationPanel(this.myProject);
            p.setFileName(this.getDefaultPatchFile());
            p.setCommonParentPath(ChangesUtil.findCommonAncestor(((HistoryDialogModel)this.myModel).getChanges()));
            if (!this.showAsDialog(p)) {
                return;
            }
            Path base = Paths.get(p.getBaseDirName(), new String[0]);
            List patches = IdeaTextPatchBuilder.buildPatch((Project)this.myProject, ((HistoryDialogModel)this.myModel).getChanges(), (Path)base, (boolean)p.isReversePatch(), (boolean)false);
            if (p.isToClipboard()) {
                PatchWriter.writeAsPatchToClipboard((Project)this.myProject, (List)patches, (Path)base, (CommitContext)new CommitContext());
                this.showNotification(LocalHistoryBundle.message("message.patch.copied.to.clipboard", new Object[0]));
            } else {
                Path file = Paths.get(p.getFileName(), new String[0]);
                PatchWriter.writePatches((Project)this.myProject, (Path)file, (Path)base, (List)patches, null, (Charset)p.getEncoding());
                this.showNotification(LocalHistoryBundle.message("message.patch.created", new Object[0]));
                RevealFileAction.openFile((Path)file);
            }
        }
        catch (VcsException | IOException e) {
            this.showError(LocalHistoryBundle.message("message.error.during.create.patch", e));
        }
    }

    @NotNull
    private Path getDefaultPatchFile() {
        Path path = FileUtil.findSequentNonexistentFile((File)ProjectKt.getStateStore((Project)this.myProject).getProjectBasePath().toFile(), (String)"local_history", (String)"patch").toPath();
        if (path == null) {
            HistoryDialog.$$$reportNull$$$0(5);
        }
        return path;
    }

    private boolean showAsDialog(CreatePatchConfigurationPanel p) {
        MyDialogWrapper dialogWrapper = new MyDialogWrapper(this.myProject, p);
        dialogWrapper.setTitle(LocalHistoryBundle.message("create.patch.dialog.title", new Object[0]));
        dialogWrapper.setModal(true);
        dialogWrapper.show();
        return dialogWrapper.getExitCode() == 0;
    }

    public void showError(@NlsContexts.DialogMessage String s) {
        Messages.showErrorDialog((Project)this.myProject, (String)s, (String)CommonBundle.getErrorTitle());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/ui/views/HistoryDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/ui/views/HistoryDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevisionsSide";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevisionsToolbar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevisionsActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPatchFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatErrors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    private final class RevertAction
    extends MyAction {
        RevertAction() {
            super(LocalHistoryBundle.message("action.revert", new Object[0]), null, AllIcons.Actions.Rollback);
        }

        @Override
        protected void doPerform(T model) {
            LocalHistoryCounter.INSTANCE.logActionInvoked(LocalHistoryCounter.ActionKind.RevertRevisions, ((HistoryDialogModel)HistoryDialog.this.myModel).getKind());
            HistoryDialog.this.revert();
        }

        @Override
        protected boolean isEnabled(T model) {
            return HistoryDialog.this.isRevertEnabled();
        }
    }

    private final class CreatePatchAction
    extends MyAction {
        CreatePatchAction() {
            super(LocalHistoryBundle.message("action.create.patch", new Object[0]), null, AllIcons.Vcs.Patch);
        }

        @Override
        protected void doPerform(T model) {
            LocalHistoryCounter.INSTANCE.logActionInvoked(LocalHistoryCounter.ActionKind.CreatePatch, ((HistoryDialogModel)HistoryDialog.this.myModel).getKind());
            HistoryDialog.this.createPatch();
        }

        @Override
        protected boolean isEnabled(T model) {
            return HistoryDialog.this.isCreatePatchEnabled();
        }
    }

    private static final class MyDialogWrapper
    extends DialogWrapper {
        @NotNull
        private final CreatePatchConfigurationPanel myPanel;

        private MyDialogWrapper(@Nullable Project project, @NotNull CreatePatchConfigurationPanel centralPanel) {
            if (centralPanel == null) {
                MyDialogWrapper.$$$reportNull$$$0(0);
            }
            super(project, true);
            this.myPanel = centralPanel;
            this.init();
            this.initValidation();
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JComponent jComponent = this.myPanel.getPanel();
            if (jComponent == null) {
                MyDialogWrapper.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.myPanel.getPanel());
        }

        @Nullable
        protected ValidationInfo doValidate() {
            return this.myPanel.validateFields();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "centralPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/history/integration/ui/views/HistoryDialog$MyDialogWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/history/integration/ui/views/HistoryDialog$MyDialogWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCenterPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    protected abstract class MyAction
    extends AnAction {
        protected MyAction(@NlsActions.ActionDescription String text, String description, Icon icon) {
            super(text, description, icon);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(0);
            }
            this.doPerform(HistoryDialog.this.myModel);
        }

        protected abstract void doPerform(T var1);

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(2);
            }
            Presentation p = e.getPresentation();
            p.setEnabled(this.isEnabled());
        }

        private boolean isEnabled() {
            return !HistoryDialog.this.isUpdating && this.isEnabled(HistoryDialog.this.myModel);
        }

        protected abstract boolean isEnabled(T var1);

        public void performIfEnabled() {
            if (this.isEnabled()) {
                this.doPerform(HistoryDialog.this.myModel);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/history/integration/ui/views/HistoryDialog$MyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/history/integration/ui/views/HistoryDialog$MyAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

