/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.PosixProcessFunctions;

public class DefaultProcess
implements Process {
    public int getProcessId() throws NativeException {
        return PosixProcessFunctions.getPid();
    }

    public void detach() throws NativeException {
        FunctionResult result2 = new FunctionResult();
        PosixProcessFunctions.detach(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not detach process: %s", result2.getMessage()));
        }
    }

    public File getWorkingDirectory() throws NativeException {
        FunctionResult result2 = new FunctionResult();
        String dir2 = PosixProcessFunctions.getWorkingDirectory(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not get process working directory: %s", result2.getMessage()));
        }
        return new File(dir2);
    }

    public void setWorkingDirectory(File directory) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        PosixProcessFunctions.setWorkingDirectory(directory.getAbsolutePath(), result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not set process working directory to '%s': %s", directory.getAbsoluteFile(), result2.getMessage()));
        }
    }

    public String getEnvironmentVariable(String name2) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        String value2 = PosixProcessFunctions.getEnvironmentVariable(name2, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not get the value of environment variable '%s': %s", name2, result2.getMessage()));
        }
        return value2;
    }

    public void setEnvironmentVariable(String name2, String value2) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        PosixProcessFunctions.setEnvironmentVariable(name2, value2, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not set the value of environment variable '%s': %s", name2, result2.getMessage()));
        }
    }
}

