/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.SshConnectionUtil;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0007B\u0011\b\u0016\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB#\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ssh/SftpChannelConfig;", "", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)V", "()V", "command", "Lcom/intellij/ssh/SftpChannelConfig$SftpCommand;", "(Lcom/intellij/ssh/SftpChannelConfig$SftpCommand;)V", "(Lcom/intellij/ssh/SftpChannelConfig$SftpCommand;JLjava/util/concurrent/TimeUnit;)V", "getCommand", "()Lcom/intellij/ssh/SftpChannelConfig$SftpCommand;", "timeoutInMillis", "", "getTimeoutInMillis", "()I", "SftpCommand", "SudoCommand", "intellij.platform.ssh"})
public final class SftpChannelConfig {
    @Nullable
    private final SftpCommand command;
    private final int timeoutInMillis;

    public SftpChannelConfig(@Nullable SftpCommand command, long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.command = command;
        this.timeoutInMillis = SshConnectionUtil.toTimeoutInMillis(timeout, timeUnit);
    }

    public /* synthetic */ SftpChannelConfig(SftpCommand sftpCommand, long l, TimeUnit timeUnit, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        this(sftpCommand, l, timeUnit);
    }

    @Nullable
    public final SftpCommand getCommand() {
        return this.command;
    }

    public SftpChannelConfig(long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this(null, timeout, timeUnit);
    }

    public /* synthetic */ SftpChannelConfig(long l, TimeUnit timeUnit, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        this(l, timeUnit);
    }

    public SftpChannelConfig() {
        this(null);
    }

    public SftpChannelConfig(@Nullable SftpCommand command) {
        this(command, 0L, TimeUnit.MILLISECONDS);
    }

    public final int getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ssh/SftpChannelConfig$SftpCommand;", "", "command", "", "sudoCommand", "Lcom/intellij/ssh/SftpChannelConfig$SudoCommand;", "(Ljava/lang/String;Lcom/intellij/ssh/SftpChannelConfig$SudoCommand;)V", "getCommand", "()Ljava/lang/String;", "getSudoCommand", "()Lcom/intellij/ssh/SftpChannelConfig$SudoCommand;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.platform.ssh"})
    public static final class SftpCommand {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String command;
        @Nullable
        private final SudoCommand sudoCommand;
        @NotNull
        public static final String detectSftpCommandString = "/usr/bin/env sh -c \"cat /etc/ssh/sshd_config | sed -n 's@\\s*Subsystem\\s*sftp\\s*\\([a-z\\/_\\\\-]*\\)\\(.*\\)@\\1@p'\"";
        @NotNull
        private static final String detectAndRunSftpCommandString = "/usr/bin/env sh -c \"$(cat /etc/ssh/sshd_config | sed -n 's@\\s*Subsystem\\s*sftp\\s*\\([a-z\\/_\\\\-]*\\)\\(.*\\)@\\1@p')\"";

        public SftpCommand(@NotNull String command, @Nullable SudoCommand sudoCommand) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            this.command = command;
            this.sudoCommand = sudoCommand;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @Nullable
        public final SudoCommand getSudoCommand() {
            return this.sudoCommand;
        }

        @NotNull
        public final String component1() {
            return this.command;
        }

        @Nullable
        public final SudoCommand component2() {
            return this.sudoCommand;
        }

        @NotNull
        public final SftpCommand copy(@NotNull String command, @Nullable SudoCommand sudoCommand) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return new SftpCommand(command, sudoCommand);
        }

        public static /* synthetic */ SftpCommand copy$default(SftpCommand sftpCommand, String string, SudoCommand sudoCommand, int n, Object object) {
            if ((n & 1) != 0) {
                string = sftpCommand.command;
            }
            if ((n & 2) != 0) {
                sudoCommand = sftpCommand.sudoCommand;
            }
            return sftpCommand.copy(string, sudoCommand);
        }

        @NotNull
        public String toString() {
            return "SftpCommand(command=" + this.command + ", sudoCommand=" + this.sudoCommand + ")";
        }

        public int hashCode() {
            int result2 = this.command.hashCode();
            result2 = result2 * 31 + (this.sudoCommand == null ? 0 : this.sudoCommand.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SftpCommand)) {
                return false;
            }
            SftpCommand sftpCommand = (SftpCommand)other;
            if (!Intrinsics.areEqual((Object)this.command, (Object)sftpCommand.command)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sudoCommand, (Object)sftpCommand.sudoCommand);
        }

        @JvmStatic
        @Nullable
        public static final SftpCommand createCustomSftpCommand(boolean useSudo, @Nullable String customSudoCommand, @Nullable String customSftpCommand, @NotNull Function0<? extends PasswordStringProvider> passwordStringProvider) {
            return Companion.createCustomSftpCommand(useSudo, customSudoCommand, customSftpCommand, passwordStringProvider);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ssh/SftpChannelConfig$SftpCommand$Companion;", "", "()V", "detectAndRunSftpCommandString", "", "detectSftpCommandString", "createCustomSftpCommand", "Lcom/intellij/ssh/SftpChannelConfig$SftpCommand;", "useSudo", "", "customSudoCommand", "customSftpCommand", "passwordStringProvider", "Lkotlin/Function0;", "Lcom/intellij/ssh/PasswordStringProvider;", "intellij.platform.ssh"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Nullable
            public final SftpCommand createCustomSftpCommand(boolean useSudo, @Nullable String customSudoCommand, @Nullable String customSftpCommand, @NotNull Function0<? extends PasswordStringProvider> passwordStringProvider) {
                SftpCommand sftpCommand;
                Intrinsics.checkNotNullParameter(passwordStringProvider, (String)"passwordStringProvider");
                if (useSudo) {
                    String string;
                    String sudoCommandString;
                    String string2 = customSudoCommand;
                    if (string2 == null) {
                        string2 = sudoCommandString = "sudo";
                    }
                    if ((string = customSftpCommand) == null) {
                        string = SftpCommand.detectAndRunSftpCommandString;
                    }
                    String sftpCommandString = string;
                    SudoCommand sudoCommand = new SudoCommand(sudoCommandString, (PasswordStringProvider)passwordStringProvider.invoke());
                    sftpCommand = new SftpCommand(sftpCommandString, sudoCommand);
                } else {
                    sftpCommand = customSftpCommand != null ? new SftpCommand(customSftpCommand, null) : null;
                }
                return sftpCommand;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ssh/SftpChannelConfig$SudoCommand;", "", "sudoCommand", "", "sudoPasswordStringProvider", "Lcom/intellij/ssh/PasswordStringProvider;", "(Ljava/lang/String;Lcom/intellij/ssh/PasswordStringProvider;)V", "getSudoCommand", "()Ljava/lang/String;", "getSudoPasswordStringProvider", "()Lcom/intellij/ssh/PasswordStringProvider;", "equals", "", "other", "hashCode", "", "intellij.platform.ssh"})
    public static final class SudoCommand {
        @NotNull
        private final String sudoCommand;
        @NotNull
        private final PasswordStringProvider sudoPasswordStringProvider;

        public SudoCommand(@NotNull String sudoCommand, @NotNull PasswordStringProvider sudoPasswordStringProvider) {
            Intrinsics.checkNotNullParameter((Object)sudoCommand, (String)"sudoCommand");
            Intrinsics.checkNotNullParameter((Object)sudoPasswordStringProvider, (String)"sudoPasswordStringProvider");
            this.sudoCommand = sudoCommand;
            this.sudoPasswordStringProvider = sudoPasswordStringProvider;
        }

        @NotNull
        public final String getSudoCommand() {
            return this.sudoCommand;
        }

        @NotNull
        public final PasswordStringProvider getSudoPasswordStringProvider() {
            return this.sudoPasswordStringProvider;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof SudoCommand && Intrinsics.areEqual((Object)this.sudoCommand, (Object)((SudoCommand)other).sudoCommand);
        }

        public int hashCode() {
            return this.sudoCommand.hashCode();
        }
    }
}

