/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class VcsRepositoryManager
implements Disposable {
    public static final ExtensionPointName<VcsRepositoryCreator> EP_NAME = new ExtensionPointName("com.intellij.vcsRepositoryCreator");
    private static final Logger LOG = Logger.getInstance(VcsRepositoryManager.class);
    @Topic.ProjectLevel
    public static final Topic<VcsRepositoryMappingListener> VCS_REPOSITORY_MAPPING_UPDATED = new Topic(VcsRepositoryMappingListener.class, Topic.BroadcastDirection.NONE);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ReentrantReadWriteLock REPO_LOCK;
    @NotNull
    private final ReentrantReadWriteLock.WriteLock MODIFY_LOCK;
    @NotNull
    private final Map<VirtualFile, Repository> myRepositories;
    @NotNull
    private final Map<VirtualFile, Repository> myExternalRepositories;
    @NotNull
    private final Map<String, VirtualFile> myPathToRootMap;
    private final Alarm myUpdateAlarm;
    private volatile boolean myDisposed;
    private final AtomicBoolean myStarted;
    private final AtomicBoolean myUpdateScheduled;

    @NotNull
    public static VcsRepositoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            VcsRepositoryManager.$$$reportNull$$$0(0);
        }
        VcsRepositoryManager vcsRepositoryManager = Objects.requireNonNull((VcsRepositoryManager)project.getService(VcsRepositoryManager.class));
        if (vcsRepositoryManager == null) {
            VcsRepositoryManager.$$$reportNull$$$0(1);
        }
        return vcsRepositoryManager;
    }

    public VcsRepositoryManager(@NotNull Project project) {
        if (project == null) {
            VcsRepositoryManager.$$$reportNull$$$0(2);
        }
        this.REPO_LOCK = new ReentrantReadWriteLock();
        this.MODIFY_LOCK = new ReentrantReadWriteLock().writeLock();
        this.myRepositories = new HashMap<VirtualFile, Repository>();
        this.myExternalRepositories = new HashMap<VirtualFile, Repository>();
        this.myPathToRootMap = CollectionFactory.createFilePathMap();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myStarted = new AtomicBoolean(false);
        this.myUpdateScheduled = new AtomicBoolean(false);
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, this::scheduleUpdate);
        EP_NAME.addChangeListener(() -> {
            this.disposeAllRepositories(false);
            this.scheduleUpdate();
            ((VcsRepositoryMappingListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VCS_REPOSITORY_MAPPING_UPDATED)).mappingChanged();
        }, (Disposable)this);
    }

    public void dispose() {
        this.myDisposed = true;
        this.disposeAllRepositories(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAllRepositories(boolean disposeExternal) {
        this.REPO_LOCK.writeLock().lock();
        try {
            for (Repository repo : this.myRepositories.values()) {
                Disposer.dispose((Disposable)repo);
            }
            this.myRepositories.clear();
            if (disposeExternal) {
                for (Repository repo : this.myExternalRepositories.values()) {
                    Disposer.dispose((Disposable)repo);
                }
                this.myExternalRepositories.clear();
            }
            this.updatePathToRootMap();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    private void scheduleUpdate() {
        if (!this.myStarted.get() || this.myDisposed) {
            return;
        }
        if (this.myUpdateScheduled.compareAndSet(false, true)) {
            this.myUpdateAlarm.addRequest(() -> this.checkAndUpdateRepositoryCollection(null), 100);
        }
    }

    @ApiStatus.Internal
    public void ensureUpToDate() {
        if (this.myStarted.compareAndSet(false, true)) {
            this.myUpdateScheduled.set(true);
            this.myUpdateAlarm.addRequest(() -> this.checkAndUpdateRepositoryCollection(null), 0);
        }
        CountDownLatch waiter = new CountDownLatch(1);
        this.myUpdateAlarm.addRequest(() -> waiter.countDown(), 10);
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)waiter);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @Nullable
    public Repository getRepositoryForFile(@Nullable VirtualFile virtualFile) {
        void file;
        ThreadingAssertions.assertBackgroundThread();
        return this.getRepositoryForFile((VirtualFile)file, false);
    }

    @Nullable
    public Repository getRepositoryForFileQuick(@Nullable VirtualFile file) {
        return this.getRepositoryForFile(file, true);
    }

    @Nullable
    public Repository getRepositoryForFile(@Nullable VirtualFile file, boolean quick) {
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(file);
        if (vcsRoot == null) {
            return this.getExternalRepositoryForFile(file);
        }
        return quick ? this.getRepositoryForRootQuick(vcsRoot.getPath()) : this.getRepositoryForRoot(vcsRoot.getPath());
    }

    @Nullable
    public Repository getRepositoryForFile(@Nullable FilePath file, boolean quick) {
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(file);
        if (vcsRoot == null) {
            return this.getExternalRepositoryForFile(file);
        }
        return quick ? this.getRepositoryForRootQuick(vcsRoot.getPath()) : this.getRepositoryForRoot(vcsRoot.getPath());
    }

    @Nullable
    public Repository getExternalRepositoryForFile(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        Map<VirtualFile, Repository> repositories = this.getExternalRepositories();
        for (Map.Entry<VirtualFile, Repository> entry : repositories.entrySet()) {
            if (!entry.getKey().isValid() || !VfsUtilCore.isAncestor((VirtualFile)entry.getKey(), (VirtualFile)file, (boolean)false)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public Repository getExternalRepositoryForFile(@Nullable FilePath file) {
        if (file == null) {
            return null;
        }
        Map<VirtualFile, Repository> repositories = this.getExternalRepositories();
        for (Map.Entry<VirtualFile, Repository> entry : repositories.entrySet()) {
            if (!entry.getKey().isValid() || !FileUtil.isAncestor((String)entry.getKey().getPath(), (String)file.getPath(), (boolean)false)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public Repository getRepositoryForRootQuick(@Nullable FilePath rootPath) {
        VirtualFile root = this.getVirtualFileForRoot(rootPath);
        if (root == null) {
            return null;
        }
        return this.getRepositoryForRoot(root, false);
    }

    @Nullable
    private VirtualFile getVirtualFileForRoot(@Nullable FilePath rootPath) {
        if (rootPath == null) {
            return null;
        }
        this.REPO_LOCK.readLock().lock();
        try {
            VirtualFile virtualFile = this.myPathToRootMap.get(rootPath.getPath());
            return virtualFile;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    private void updatePathToRootMap() {
        this.myPathToRootMap.clear();
        for (VirtualFile root : this.myRepositories.keySet()) {
            this.myPathToRootMap.put(root.getPath(), root);
        }
        for (VirtualFile root : this.myExternalRepositories.keySet()) {
            this.myPathToRootMap.put(root.getPath(), root);
        }
    }

    @Nullable
    public Repository getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, false);
    }

    @Nullable
    public Repository getRepositoryForRoot(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Repository getRepositoryForRoot(@Nullable VirtualFile root, boolean updateIfNeeded) {
        if (root == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (updateIfNeeded && application.isDispatchThread() && !application.isUnitTestMode() && !application.isHeadlessEnvironment()) {
            updateIfNeeded = false;
            LOG.error("Do not call synchronous repository update in EDT");
        }
        this.REPO_LOCK.readLock().lock();
        try {
            if (this.myDisposed) {
                throw new ProcessCanceledException();
            }
            Repository repo = this.myRepositories.get(root);
            if (repo != null) {
                Repository repository = repo;
                return repository;
            }
            Repository externalRepo = this.myExternalRepositories.get(root);
            if (externalRepo != null) {
                Repository repository = externalRepo;
                return repository;
            }
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        if (updateIfNeeded && ArrayUtil.contains((Object)root, (Object[])this.myVcsManager.getAllVersionedRoots())) {
            this.checkAndUpdateRepositoryCollection(root);
            this.REPO_LOCK.readLock().lock();
            try {
                Repository repository = this.myRepositories.get(root);
                return repository;
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
        }
        return null;
    }

    public void addExternalRepository(@NotNull VirtualFile root, @NotNull Repository repository) {
        if (root == null) {
            VcsRepositoryManager.$$$reportNull$$$0(3);
        }
        if (repository == null) {
            VcsRepositoryManager.$$$reportNull$$$0(4);
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.put(root, repository);
            this.updatePathToRootMap();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void removeExternalRepository(@NotNull VirtualFile root) {
        if (root == null) {
            VcsRepositoryManager.$$$reportNull$$$0(5);
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.remove(root);
            this.updatePathToRootMap();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public boolean isExternal(@NotNull Repository repository) {
        if (repository == null) {
            VcsRepositoryManager.$$$reportNull$$$0(6);
        }
        this.REPO_LOCK.readLock().lock();
        try {
            boolean bl = !this.myRepositories.containsValue(repository) && this.myExternalRepositories.containsValue(repository);
            return bl;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @NotNull
    public Collection<Repository> getRepositories() {
        this.REPO_LOCK.readLock().lock();
        ArrayList<Repository> arrayList = new ArrayList<Repository>(this.myRepositories.values());
        ArrayList<Repository> arrayList2 = arrayList;
        if (arrayList2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(7);
        }
        return arrayList2;
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @NotNull
    private Map<VirtualFile, Repository> getExternalRepositories() {
        this.REPO_LOCK.readLock().lock();
        HashMap<VirtualFile, Repository> hashMap = new HashMap<VirtualFile, Repository>(this.myExternalRepositories);
        HashMap<VirtualFile, Repository> hashMap2 = hashMap;
        if (hashMap2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(8);
        }
        return hashMap2;
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private void checkAndUpdateRepositoryCollection(@Nullable VirtualFile virtualFile) {
        ThreadingAssertions.assertBackgroundThread();
        this.myUpdateScheduled.set(false);
        if (this.MODIFY_LOCK.isHeldByCurrentThread()) {
            LOG.error(new Throwable("Recursive Repository initialization"));
            return;
        }
        this.MODIFY_LOCK.lock();
        try {
            void checkedRoot;
            HashMap<VirtualFile, Repository> repositories;
            this.REPO_LOCK.readLock().lock();
            try {
                repositories = new HashMap<VirtualFile, Repository>(this.myRepositories);
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
            if (checkedRoot != null && repositories.containsKey(checkedRoot)) {
                return;
            }
            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, () -> {
                Collection<VirtualFile> invalidRoots = this.findInvalidRoots(repositories.values());
                repositories.keySet().removeAll(invalidRoots);
                Map<VirtualFile, Repository> newRoots = this.findNewRoots(repositories.keySet());
                repositories.putAll(newRoots);
            });
            this.REPO_LOCK.writeLock().lock();
            try {
                if (!this.myDisposed) {
                    for (VirtualFile file : this.myRepositories.keySet()) {
                        Repository newRepo;
                        Repository oldRepo = this.myRepositories.get(file);
                        if (oldRepo == (newRepo = (Repository)repositories.get(file))) continue;
                        Disposer.dispose((Disposable)oldRepo);
                    }
                    this.myRepositories.clear();
                    this.myRepositories.putAll(repositories);
                }
                this.updatePathToRootMap();
            }
            finally {
                this.REPO_LOCK.writeLock().unlock();
            }
        }
        finally {
            this.MODIFY_LOCK.unlock();
        }
        ((VcsRepositoryMappingListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VCS_REPOSITORY_MAPPING_UPDATED)).mappingChanged();
    }

    @NotNull
    private Map<VirtualFile, Repository> findNewRoots(@NotNull Set<VirtualFile> knownRoots) {
        if (knownRoots == null) {
            VcsRepositoryManager.$$$reportNull$$$0(9);
        }
        HashMap<VirtualFile, Repository> newRootsMap = new HashMap<VirtualFile, Repository>();
        for (VcsRoot root : this.myVcsManager.getAllVcsRoots()) {
            Repository repository;
            VirtualFile rootPath = root.getPath();
            if (knownRoots.contains(rootPath) || (repository = VcsRepositoryManager.tryCreateRepository(this.myProject, root.getVcs(), rootPath, this)) == null) continue;
            newRootsMap.put(rootPath, repository);
        }
        HashMap<VirtualFile, Repository> hashMap = newRootsMap;
        if (hashMap == null) {
            VcsRepositoryManager.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    private Collection<VirtualFile> findInvalidRoots(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            VcsRepositoryManager.$$$reportNull$$$0(11);
        }
        ArrayList<VirtualFile> invalidRepos = new ArrayList<VirtualFile>();
        for (Repository repository : repositories) {
            VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(repository.getRoot());
            if (vcsRoot != null && repository.getRoot().equals(vcsRoot.getPath()) && repository.getVcs().equals((Object)vcsRoot.getVcs())) continue;
            invalidRepos.add(repository.getRoot());
        }
        ArrayList<VirtualFile> arrayList = invalidRepos;
        if (arrayList == null) {
            VcsRepositoryManager.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Nullable
    private static Repository tryCreateRepository(@NotNull Project project, @Nullable AbstractVcs vcs, @NotNull VirtualFile rootPath, @NotNull Disposable disposable) {
        if (project == null) {
            VcsRepositoryManager.$$$reportNull$$$0(13);
        }
        if (rootPath == null) {
            VcsRepositoryManager.$$$reportNull$$$0(14);
        }
        if (disposable == null) {
            VcsRepositoryManager.$$$reportNull$$$0(15);
        }
        if (vcs == null) {
            return null;
        }
        return (Repository)EP_NAME.computeSafeIfAny(creator -> {
            if (creator.getVcsKey().equals((Object)vcs.getKeyInstanceMethod())) {
                return creator.createRepositoryIfValid(project, rootPath, disposable);
            }
            return null;
        });
    }

    @NotNull
    public String toString() {
        String string = "RepositoryManager(repositories=" + this.myRepositories + ")";
        if (string == null) {
            VcsRepositoryManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    @TestOnly
    public void waitForAsyncTaskCompletion() {
        try {
            this.myUpdateAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 8, 10, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/repo/VcsRepositoryManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/repo/VcsRepositoryManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalRepositories";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findNewRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findInvalidRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addExternalRepository";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeExternalRepository";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findNewRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findInvalidRoots";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateRepository";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 8, 10, 12, 16 -> new IllegalStateException(string);
        };
    }

    static final class MyStartupActivity
    implements VcsStartupActivity {
        MyStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            VcsRepositoryManager.getInstance(project).ensureUpToDate();
        }

        public int getOrder() {
            return VcsInitObject.OTHER_INITIALIZATION.getOrder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/repo/VcsRepositoryManager$MyStartupActivity", "runActivity"));
        }
    }
}

