/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyModel;

import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicyCache;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.DefaultModuleComponentIdentifier;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetArtifactIndex.GradleSourceSetArtifactIndex;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.specs.Spec;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.util.StringUtils;

public final class GradleDependencyResolver {
    private static final boolean IS_83_OR_BETTER = GradleVersionUtil.isCurrentGradleAtLeast((String)"8.3");
    private static final Pattern PUNCTUATION_IN_SUFFIX_PATTERN = Pattern.compile("[\\p{Punct}\\s]+$");
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDependencyDownloadPolicy myDownloadPolicy;
    @NotNull
    private final GradleSourceSetArtifactIndex mySourceSetArtifactIndex;

    public GradleDependencyResolver(@NotNull ModelBuilderContext context, @NotNull Project project, @NotNull GradleDependencyDownloadPolicy downloadPolicy) {
        if (context == null) {
            GradleDependencyResolver.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleDependencyResolver.$$$reportNull$$$0(1);
        }
        if (downloadPolicy == null) {
            GradleDependencyResolver.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDownloadPolicy = downloadPolicy;
        this.mySourceSetArtifactIndex = GradleSourceSetArtifactIndex.getInstance(context);
    }

    public GradleDependencyResolver(@NotNull ModelBuilderContext context, @NotNull Project project) {
        if (context == null) {
            GradleDependencyResolver.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleDependencyResolver.$$$reportNull$$$0(4);
        }
        this(context, project, GradleDependencyDownloadPolicyCache.getInstance(context).getDependencyDownloadPolicy(project));
    }

    private static void ensureConfigurationArtifactsResolved(@NotNull Configuration configuration) {
        if (configuration == null) {
            GradleDependencyResolver.$$$reportNull$$$0(5);
        }
        try {
            ArtifactView artifactView = configuration.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(){

                public void execute(@NotNull ArtifactView.ViewConfiguration configuration) {
                    if (configuration == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    configuration.setLenient(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/GradleDependencyResolver$1", "execute"));
                }
            });
            artifactView.getArtifacts().getArtifacts();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public Collection<ExternalDependency> resolveDependencies(@Nullable Configuration configuration) {
        if (configuration == null) {
            Set<ExternalDependency> set = Collections.emptySet();
            if (set == null) {
                GradleDependencyResolver.$$$reportNull$$$0(6);
            }
            return set;
        }
        GradleDependencyResolver.ensureConfigurationArtifactsResolved(configuration);
        LenientConfiguration lenientConfiguration = configuration.getResolvedConfiguration().getLenientConfiguration();
        LinkedHashMap<ResolvedDependency, Set<ResolvedArtifact>> resolvedArtifacts = new LinkedHashMap<ResolvedDependency, Set<ResolvedArtifact>>();
        boolean hasFailedToTransformDependencies = false;
        for (Object dependency : lenientConfiguration.getAllModuleDependencies()) {
            try {
                resolvedArtifacts.put((ResolvedDependency)dependency, dependency.getModuleArtifacts());
            }
            catch (GradleException e) {
                hasFailedToTransformDependencies = true;
                resolvedArtifacts.put((ResolvedDependency)dependency, Collections.emptySet());
            }
            catch (Exception e) {}
        }
        HashMap<ModuleVersionIdentifier, ResolvedDependencyResult> transformedProjectDependenciesResultMap = new HashMap<ModuleVersionIdentifier, ResolvedDependencyResult>();
        if (hasFailedToTransformDependencies) {
            for (DependencyResult dependencyResult : configuration.getIncoming().getResolutionResult().getAllDependencies()) {
                ComponentSelector resultRequested = dependencyResult.getRequested();
                if (!(dependencyResult instanceof ResolvedDependencyResult) || !(resultRequested instanceof ProjectComponentSelector)) continue;
                ResolvedComponentResult resolvedComponentResult = ((ResolvedDependencyResult)dependencyResult).getSelected();
                ModuleVersionIdentifier selectedResultVersion = resolvedComponentResult.getModuleVersion();
                transformedProjectDependenciesResultMap.put(selectedResultVersion, (ResolvedDependencyResult)dependencyResult);
            }
        }
        Map<ComponentIdentifier, ComponentArtifactsResult> auxiliaryArtifactsMap = this.buildAuxiliaryArtifactsMap(configuration, resolvedArtifacts);
        HashSet<String> resolvedFiles = new HashSet<String>();
        Collection<ExternalDependency> artifactDependencies = this.resolveArtifactDependencies(resolvedFiles, resolvedArtifacts, auxiliaryArtifactsMap, transformedProjectDependenciesResultMap);
        Collection<FileCollectionDependency> otherFileDependencies = GradleDependencyResolver.resolveOtherFileDependencies(resolvedFiles, configuration);
        Collection<ExternalDependency> unresolvedDependencies = GradleDependencyResolver.collectUnresolvedDependencies(lenientConfiguration);
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        result.addAll(otherFileDependencies);
        result.addAll(artifactDependencies);
        result.addAll(unresolvedDependencies);
        int order = 0;
        for (ExternalDependency dependency : result) {
            ((AbstractExternalDependency)dependency).setClasspathOrder(++order);
        }
        LinkedHashSet<ExternalDependency> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleDependencyResolver.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<ExternalDependency> resolveArtifactDependencies(@NotNull Set<String> resolvedFiles, @NotNull Map<ResolvedDependency, Set<ResolvedArtifact>> resolvedArtifacts, @NotNull Map<ComponentIdentifier, ComponentArtifactsResult> auxiliaryArtifactsMap, @NotNull Map<ModuleVersionIdentifier, ResolvedDependencyResult> transformedProjectDependenciesResultMap) {
        if (resolvedFiles == null) {
            GradleDependencyResolver.$$$reportNull$$$0(8);
        }
        if (resolvedArtifacts == null) {
            GradleDependencyResolver.$$$reportNull$$$0(9);
        }
        if (auxiliaryArtifactsMap == null) {
            GradleDependencyResolver.$$$reportNull$$$0(10);
        }
        if (transformedProjectDependenciesResultMap == null) {
            GradleDependencyResolver.$$$reportNull$$$0(11);
        }
        LinkedHashSet<ExternalDependency> artifactDependencies = new LinkedHashSet<ExternalDependency>();
        HashMap<String, DefaultExternalProjectDependency> resolvedProjectDependencies = new HashMap<String, DefaultExternalProjectDependency>();
        for (Map.Entry<ResolvedDependency, Set<ResolvedArtifact>> resolvedDependencySetEntry : resolvedArtifacts.entrySet()) {
            ExternalProjectDependency dependency;
            ResolvedDependency resolvedDependency = resolvedDependencySetEntry.getKey();
            Set<ResolvedArtifact> artifacts = resolvedDependencySetEntry.getValue();
            for (ResolvedArtifact artifact : artifacts) {
                AbstractExternalDependency dependency2;
                File artifactFile = this.resolveArtifactFile(resolvedFiles, artifact);
                if (artifactFile == null) continue;
                ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
                if (componentIdentifier instanceof ProjectComponentIdentifier) {
                    dependency2 = this.resolveProjectDependency(resolvedProjectDependencies, resolvedDependency, artifactFile, (ProjectComponentIdentifier)componentIdentifier);
                    if (dependency2 == null) continue;
                    artifactDependencies.add(dependency2);
                    continue;
                }
                dependency2 = GradleDependencyResolver.resolveLibraryDependency(artifact, artifactFile, auxiliaryArtifactsMap);
                artifactDependencies.add(dependency2);
            }
            if (!artifacts.isEmpty() || (dependency = this.resolveFailedToTransformProjectDependency(resolvedProjectDependencies, resolvedDependency, transformedProjectDependenciesResultMap)) == null) continue;
            artifactDependencies.add((ExternalDependency)dependency);
        }
        LinkedHashSet<ExternalDependency> linkedHashSet = artifactDependencies;
        if (linkedHashSet == null) {
            GradleDependencyResolver.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    @Nullable
    private File resolveArtifactFile(@NotNull Set<String> resolvedFiles, @NotNull ResolvedArtifact artifact) {
        File artifactFile;
        if (resolvedFiles == null) {
            GradleDependencyResolver.$$$reportNull$$$0(13);
        }
        if (artifact == null) {
            GradleDependencyResolver.$$$reportNull$$$0(14);
        }
        if (resolvedFiles.contains((artifactFile = artifact.getFile()).getPath())) {
            return null;
        }
        resolvedFiles.add(artifactFile.getPath());
        String artifactPath = this.mySourceSetArtifactIndex.findArtifactBySourceSetOutputDir(artifactFile.getPath());
        if (artifactPath != null) {
            artifactFile = new File(artifactPath);
            if (resolvedFiles.contains(artifactFile.getPath())) {
                return null;
            }
            resolvedFiles.add(artifactFile.getPath());
        }
        return artifactFile;
    }

    @NotNull
    private static String getProjectDependencyKey(@NotNull ResolvedDependency resolvedDependency, @NotNull ProjectComponentIdentifier projectComponentIdentifier) {
        if (resolvedDependency == null) {
            GradleDependencyResolver.$$$reportNull$$$0(15);
        }
        if (projectComponentIdentifier == null) {
            GradleDependencyResolver.$$$reportNull$$$0(16);
        }
        String buildName = GradleDependencyResolver.getBuildName(projectComponentIdentifier);
        String projectPath = projectComponentIdentifier.getProjectPath();
        String string = buildName + "_" + projectPath + "_" + resolvedDependency.getConfiguration();
        if (string == null) {
            GradleDependencyResolver.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String getProjectDependencyKey(@NotNull ResolvedDependency resolvedDependency, @NotNull ResolvedDependencyResult resolvedDependencyResult) {
        if (resolvedDependency == null) {
            GradleDependencyResolver.$$$reportNull$$$0(18);
        }
        if (resolvedDependencyResult == null) {
            GradleDependencyResolver.$$$reportNull$$$0(19);
        }
        ProjectComponentSelector dependencyResultRequested = (ProjectComponentSelector)resolvedDependencyResult.getRequested();
        String projectPath = dependencyResultRequested.getProjectPath();
        String string = projectPath + "_" + resolvedDependency.getConfiguration();
        if (string == null) {
            GradleDependencyResolver.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    private DefaultExternalProjectDependency resolveProjectDependency(@NotNull Map<String, DefaultExternalProjectDependency> resolvedProjectDependencies, @NotNull ResolvedDependency resolvedDependency, @NotNull File artifactFile, @NotNull ProjectComponentIdentifier projectComponentIdentifier) {
        String key;
        DefaultExternalProjectDependency cachedProjectDependency;
        if (resolvedProjectDependencies == null) {
            GradleDependencyResolver.$$$reportNull$$$0(21);
        }
        if (resolvedDependency == null) {
            GradleDependencyResolver.$$$reportNull$$$0(22);
        }
        if (artifactFile == null) {
            GradleDependencyResolver.$$$reportNull$$$0(23);
        }
        if (projectComponentIdentifier == null) {
            GradleDependencyResolver.$$$reportNull$$$0(24);
        }
        if ((cachedProjectDependency = resolvedProjectDependencies.get(key = GradleDependencyResolver.getProjectDependencyKey(resolvedDependency, projectComponentIdentifier))) != null) {
            LinkedHashSet<File> projectDependencyArtifacts = new LinkedHashSet<File>(cachedProjectDependency.getProjectDependencyArtifacts());
            projectDependencyArtifacts.add(artifactFile);
            cachedProjectDependency.setProjectDependencyArtifacts(projectDependencyArtifacts);
            LinkedHashSet<File> artifactSources = new LinkedHashSet<File>(cachedProjectDependency.getProjectDependencyArtifactsSources());
            artifactSources.addAll(this.mySourceSetArtifactIndex.findArtifactSources(artifactFile));
            cachedProjectDependency.setProjectDependencyArtifactsSources(artifactSources);
            return null;
        }
        DefaultExternalProjectDependency projectDependency = new DefaultExternalProjectDependency();
        resolvedProjectDependencies.put(key, projectDependency);
        projectDependency.setName(projectComponentIdentifier.getProjectName());
        projectDependency.setGroup(resolvedDependency.getModuleGroup());
        projectDependency.setVersion(resolvedDependency.getModuleVersion());
        projectDependency.setProjectPath(projectComponentIdentifier.getProjectPath());
        projectDependency.setConfigurationName(resolvedDependency.getConfiguration());
        projectDependency.setProjectDependencyArtifacts(Collections.singleton(artifactFile));
        projectDependency.setProjectDependencyArtifactsSources(this.mySourceSetArtifactIndex.findArtifactSources(artifactFile));
        return projectDependency;
    }

    @NotNull
    private static DefaultExternalLibraryDependency resolveLibraryDependency(@NotNull ResolvedArtifact artifact, @NotNull File artifactFile, @NotNull Map<ComponentIdentifier, ComponentArtifactsResult> auxiliaryArtifactsMap) {
        if (artifact == null) {
            GradleDependencyResolver.$$$reportNull$$$0(25);
        }
        if (artifactFile == null) {
            GradleDependencyResolver.$$$reportNull$$$0(26);
        }
        if (auxiliaryArtifactsMap == null) {
            GradleDependencyResolver.$$$reportNull$$$0(27);
        }
        DefaultExternalLibraryDependency libraryDependency = new DefaultExternalLibraryDependency();
        ModuleVersionIdentifier moduleVersionIdentifier = artifact.getModuleVersion().getId();
        libraryDependency.setName(moduleVersionIdentifier.getName());
        libraryDependency.setGroup(moduleVersionIdentifier.getGroup());
        libraryDependency.setVersion(moduleVersionIdentifier.getVersion());
        libraryDependency.setFile(artifactFile);
        ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
        ComponentArtifactsResult artifactsResult = auxiliaryArtifactsMap.get(componentIdentifier);
        if (artifactsResult != null) {
            Set<File> javadocArtifactFiles;
            File javadocFile;
            Set<File> sourcesArtifactFiles = GradleDependencyResolver.getResolvedAuxiliaryArtifactFiles(artifactsResult, SourcesArtifact.class);
            File sourcesFile = GradleDependencyResolver.chooseAuxiliaryArtifactFile(artifactFile, sourcesArtifactFiles);
            if (sourcesFile != null) {
                libraryDependency.setSource(sourcesFile);
            }
            if ((javadocFile = GradleDependencyResolver.chooseAuxiliaryArtifactFile(artifactFile, javadocArtifactFiles = GradleDependencyResolver.getResolvedAuxiliaryArtifactFiles(artifactsResult, JavadocArtifact.class))) != null) {
                libraryDependency.setJavadoc(javadocFile);
            }
        }
        if (artifact.getExtension() != null) {
            libraryDependency.setPackaging(artifact.getExtension());
        }
        libraryDependency.setClassifier(artifact.getClassifier());
        DefaultExternalLibraryDependency defaultExternalLibraryDependency = libraryDependency;
        if (defaultExternalLibraryDependency == null) {
            GradleDependencyResolver.$$$reportNull$$$0(28);
        }
        return defaultExternalLibraryDependency;
    }

    @Nullable
    private ExternalProjectDependency resolveFailedToTransformProjectDependency(@NotNull Map<String, DefaultExternalProjectDependency> resolvedProjectDependencies, @NotNull ResolvedDependency resolvedDependency, @NotNull Map<ModuleVersionIdentifier, ResolvedDependencyResult> transformedProjectDependenciesResultMap) {
        ModuleVersionIdentifier moduleVersionIdentifier;
        ResolvedDependencyResult resolvedDependencyResult;
        if (resolvedProjectDependencies == null) {
            GradleDependencyResolver.$$$reportNull$$$0(29);
        }
        if (resolvedDependency == null) {
            GradleDependencyResolver.$$$reportNull$$$0(30);
        }
        if (transformedProjectDependenciesResultMap == null) {
            GradleDependencyResolver.$$$reportNull$$$0(31);
        }
        if ((resolvedDependencyResult = transformedProjectDependenciesResultMap.get(moduleVersionIdentifier = resolvedDependency.getModule().getId())) == null) {
            return null;
        }
        String key = GradleDependencyResolver.getProjectDependencyKey(resolvedDependency, resolvedDependencyResult);
        DefaultExternalProjectDependency cachedProjectDependency = resolvedProjectDependencies.get(key);
        if (cachedProjectDependency != null) {
            return null;
        }
        DefaultExternalProjectDependency projectDependency = new DefaultExternalProjectDependency();
        resolvedProjectDependencies.put(key, projectDependency);
        ProjectComponentSelector dependencyResultRequested = (ProjectComponentSelector)resolvedDependencyResult.getRequested();
        String projectPath = dependencyResultRequested.getProjectPath();
        String projectName = Path.path((String)projectPath).getName();
        projectDependency.setName(projectName);
        projectDependency.setGroup(resolvedDependency.getModuleGroup());
        projectDependency.setVersion(resolvedDependency.getModuleVersion());
        projectDependency.setProjectPath(projectPath);
        projectDependency.setConfigurationName(resolvedDependency.getConfiguration());
        Project project = this.myProject.findProject(projectPath);
        if (project == null) {
            return null;
        }
        Configuration configuration = (Configuration)project.getConfigurations().findByName(resolvedDependency.getConfiguration());
        if (configuration == null) {
            return null;
        }
        Set projectArtifacts = configuration.getArtifacts().getFiles().getFiles();
        projectDependency.setProjectDependencyArtifacts(projectArtifacts);
        projectDependency.setProjectDependencyArtifactsSources(this.mySourceSetArtifactIndex.findArtifactSources(projectArtifacts));
        return projectDependency;
    }

    @NotNull
    private Map<ComponentIdentifier, ComponentArtifactsResult> buildAuxiliaryArtifactsMap(@NotNull Configuration configuration, @NotNull Map<ResolvedDependency, Set<ResolvedArtifact>> resolvedArtifacts) {
        boolean bl;
        if (configuration == null) {
            GradleDependencyResolver.$$$reportNull$$$0(32);
        }
        if (resolvedArtifacts == null) {
            GradleDependencyResolver.$$$reportNull$$$0(33);
        }
        ArrayList<ModuleComponentIdentifier> components = new ArrayList<ModuleComponentIdentifier>();
        for (Collection collection : resolvedArtifacts.values()) {
            for (ResolvedArtifact artifact : collection) {
                if (artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) continue;
                ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
                components.add(DefaultModuleComponentIdentifier.create(id));
            }
        }
        if (components.isEmpty()) {
            Map<ComponentIdentifier, ComponentArtifactsResult> map = Collections.emptyMap();
            if (map == null) {
                GradleDependencyResolver.$$$reportNull$$$0(34);
            }
            return map;
        }
        ArrayList<Class> artifactTypes = new ArrayList<Class>(2);
        if (this.myDownloadPolicy.isDownloadSources()) {
            artifactTypes.add(SourcesArtifact.class);
        }
        if (this.myDownloadPolicy.isDownloadJavadoc()) {
            artifactTypes.add(JavadocArtifact.class);
        }
        DependencyHandler dependencyHandler = (bl = this.myProject.getBuildscript().getConfigurations().contains((Object)configuration)) ? this.myProject.getBuildscript().getDependencies() : this.myProject.getDependencies();
        Set componentResults = dependencyHandler.createArtifactResolutionQuery().forComponents(components).withArtifacts(JvmLibrary.class, artifactTypes).execute().getResolvedComponents();
        HashMap<ComponentIdentifier, ComponentArtifactsResult> result = new HashMap<ComponentIdentifier, ComponentArtifactsResult>(componentResults.size());
        for (ComponentArtifactsResult artifactsResult : componentResults) {
            result.put(artifactsResult.getId(), artifactsResult);
        }
        HashMap<ComponentIdentifier, ComponentArtifactsResult> hashMap = result;
        if (hashMap == null) {
            GradleDependencyResolver.$$$reportNull$$$0(35);
        }
        return hashMap;
    }

    @NotNull
    private static Collection<FileCollectionDependency> resolveOtherFileDependencies(@NotNull Set<String> resolvedFiles, @NotNull Configuration configuration) {
        if (resolvedFiles == null) {
            GradleDependencyResolver.$$$reportNull$$$0(36);
        }
        if (configuration == null) {
            GradleDependencyResolver.$$$reportNull$$$0(37);
        }
        ArtifactView artifactView = configuration.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(){

            public void execute(ArtifactView.ViewConfiguration configuration) {
                configuration.setLenient(true);
                configuration.componentFilter((Spec)new Spec<ComponentIdentifier>(){

                    public boolean isSatisfiedBy(ComponentIdentifier identifier) {
                        return !(identifier instanceof ProjectComponentIdentifier) && !(identifier instanceof ModuleComponentIdentifier);
                    }
                });
            }
        });
        Set artifactResults = artifactView.getArtifacts().getArtifacts();
        LinkedHashSet<FileCollectionDependency> result = new LinkedHashSet<FileCollectionDependency>();
        for (ResolvedArtifactResult artifactResult : artifactResults) {
            File file = artifactResult.getFile();
            if (resolvedFiles.contains(file.getPath())) continue;
            resolvedFiles.add(file.getPath());
            result.add(new DefaultFileCollectionDependency(Collections.singleton(file)));
        }
        LinkedHashSet<FileCollectionDependency> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleDependencyResolver.$$$reportNull$$$0(38);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<ExternalDependency> collectUnresolvedDependencies(@NotNull LenientConfiguration lenientConfiguration) {
        if (lenientConfiguration == null) {
            GradleDependencyResolver.$$$reportNull$$$0(39);
        }
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        Set unresolvedModuleDependencies = lenientConfiguration.getUnresolvedModuleDependencies();
        for (UnresolvedDependency unresolvedDependency : unresolvedModuleDependencies) {
            MyModuleVersionSelector moduleVersionSelector = null;
            Throwable problem = unresolvedDependency.getProblem();
            if (problem.getCause() != null) {
                problem = problem.getCause();
            }
            try {
                ComponentSelector componentSelector;
                if (problem instanceof ModuleVersionResolveException && (componentSelector = ((ModuleVersionResolveException)problem).getSelector()) instanceof ModuleComponentSelector) {
                    ModuleComponentSelector moduleComponentSelector = (ModuleComponentSelector)componentSelector;
                    moduleVersionSelector = new MyModuleVersionSelector(moduleComponentSelector.getModule(), moduleComponentSelector.getGroup(), moduleComponentSelector.getVersion());
                }
            }
            catch (Throwable componentSelector) {
                // empty catch block
            }
            if (moduleVersionSelector == null) {
                problem = unresolvedDependency.getProblem();
                ModuleVersionSelector selector = unresolvedDependency.getSelector();
                moduleVersionSelector = new MyModuleVersionSelector(selector.getName(), selector.getGroup(), selector.getVersion());
            }
            DefaultUnresolvedExternalDependency dependency = new DefaultUnresolvedExternalDependency();
            dependency.setName(moduleVersionSelector.name);
            dependency.setGroup(moduleVersionSelector.group);
            dependency.setVersion(moduleVersionSelector.version);
            dependency.setFailureMessage(problem.getMessage());
            result.add(dependency);
        }
        LinkedHashSet<ExternalDependency> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleDependencyResolver.$$$reportNull$$$0(40);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<File> getResolvedAuxiliaryArtifactFiles(@NotNull ComponentArtifactsResult artifactsResult, @NotNull Class<? extends Artifact> artifactType) {
        if (artifactsResult == null) {
            GradleDependencyResolver.$$$reportNull$$$0(41);
        }
        if (artifactType == null) {
            GradleDependencyResolver.$$$reportNull$$$0(42);
        }
        Set<File> set = artifactsResult.getArtifacts(artifactType).stream().filter(ResolvedArtifactResult.class::isInstance).map(ResolvedArtifactResult.class::cast).map(ResolvedArtifactResult::getFile).collect(Collectors.toSet());
        if (set == null) {
            GradleDependencyResolver.$$$reportNull$$$0(43);
        }
        return set;
    }

    @VisibleForTesting
    @Nullable
    static File chooseAuxiliaryArtifactFile(@NotNull File main, @NotNull Set<File> auxiliaries) {
        Iterator<File> auxiliariesIterator;
        if (main == null) {
            GradleDependencyResolver.$$$reportNull$$$0(44);
        }
        if (auxiliaries == null) {
            GradleDependencyResolver.$$$reportNull$$$0(45);
        }
        if (!(auxiliariesIterator = auxiliaries.iterator()).hasNext()) {
            return null;
        }
        File firstAuxiliary = auxiliariesIterator.next();
        if (!auxiliariesIterator.hasNext()) {
            return firstAuxiliary;
        }
        String mainName = main.getName();
        String firstAuxiliaryName = firstAuxiliary.getName();
        int commonSuffixOfAuxiliaries = firstAuxiliaryName.length();
        do {
            File nextAuxiliary;
            int commonSuffix;
            if ((commonSuffix = StringUtils.commonSuffixLength(firstAuxiliaryName, (nextAuxiliary = auxiliariesIterator.next()).getName())) >= commonSuffixOfAuxiliaries) continue;
            commonSuffixOfAuxiliaries = commonSuffix;
        } while (auxiliariesIterator.hasNext());
        int commonSuffixOfMainAndAuxiliaries = Math.min(commonSuffixOfAuxiliaries, StringUtils.commonSuffixLength(mainName, firstAuxiliaryName));
        String mainSuffixlessName = mainName.substring(0, mainName.length() - commonSuffixOfMainAndAuxiliaries);
        int commonPrefixOfMainAndShortlistedAuxiliaries = 0;
        TreeMap<String, File> shortlistedAuxiliariesBySuffixlessName = new TreeMap<String, File>(Comparator.comparingInt(String::length).thenComparing(String::compareTo));
        for (File auxiliary : auxiliaries) {
            String auxiliaryName = auxiliary.getName();
            String auxiliarySuffixlessName = auxiliaryName.substring(0, auxiliaryName.length() - commonSuffixOfAuxiliaries);
            int commonPrefixNaive = StringUtils.commonPrefixLength(mainSuffixlessName, auxiliarySuffixlessName);
            Matcher commonPrefixExcessMatcher = PUNCTUATION_IN_SUFFIX_PATTERN.matcher(auxiliarySuffixlessName).region(0, commonPrefixNaive);
            int commonPrefix = commonPrefixExcessMatcher.find() ? commonPrefixExcessMatcher.start() : commonPrefixNaive;
            if (commonPrefix < commonPrefixOfMainAndShortlistedAuxiliaries) continue;
            if (commonPrefix > commonPrefixOfMainAndShortlistedAuxiliaries) {
                commonPrefixOfMainAndShortlistedAuxiliaries = commonPrefix;
                shortlistedAuxiliariesBySuffixlessName.clear();
            }
            shortlistedAuxiliariesBySuffixlessName.put(auxiliarySuffixlessName, auxiliary);
        }
        return (File)shortlistedAuxiliariesBySuffixlessName.firstEntry().getValue();
    }

    @NotNull
    private static String getBuildName(@NotNull ProjectComponentIdentifier projectComponentIdentifier) {
        if (projectComponentIdentifier == null) {
            GradleDependencyResolver.$$$reportNull$$$0(46);
        }
        BuildIdentifier buildIdentifier = projectComponentIdentifier.getBuild();
        if (IS_83_OR_BETTER) {
            String string = buildIdentifier.getBuildPath();
            if (string == null) {
                GradleDependencyResolver.$$$reportNull$$$0(47);
            }
            return string;
        }
        String string = buildIdentifier.getName();
        if (string == null) {
            GradleDependencyResolver.$$$reportNull$$$0(48);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 17: 
            case 20: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 17: 
            case 20: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadPolicy";
                break;
            }
            case 5: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 17: 
            case 20: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/GradleDependencyResolver";
                break;
            }
            case 8: 
            case 13: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFiles";
                break;
            }
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedArtifacts";
                break;
            }
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auxiliaryArtifactsMap";
                break;
            }
            case 11: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedProjectDependenciesResultMap";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 15: 
            case 18: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedDependency";
                break;
            }
            case 16: 
            case 24: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectComponentIdentifier";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedDependencyResult";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedProjectDependencies";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFile";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lenientConfiguration";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactsResult";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auxiliaries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/GradleDependencyResolver";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependencies";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifactDependencies";
                break;
            }
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDependencyKey";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLibraryDependency";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAuxiliaryArtifactsMap";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveOtherFileDependencies";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnresolvedDependencies";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedAuxiliaryArtifactFiles";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureConfigurationArtifactsResolved";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 17: 
            case 20: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 48: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactDependencies";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactFile";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDependencyKey";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectDependency";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveLibraryDependency";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveFailedToTransformProjectDependency";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildAuxiliaryArtifactsMap";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "resolveOtherFileDependencies";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "collectUnresolvedDependencies";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedAuxiliaryArtifactFiles";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "chooseAuxiliaryArtifactFile";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getBuildName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 17: 
            case 20: 
            case 28: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyModuleVersionSelector {
        private final String name;
        private final String group;
        private final String version;

        private MyModuleVersionSelector(String name, String group, String version) {
            this.name = name;
            this.group = group;
            this.version = version;
        }
    }
}

