/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.ComponentItemDialog;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.palette.Palette;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;

public class EditComponentAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(EditComponentAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditComponentAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        ComponentItem selectedItem = (ComponentItem)e.getData(ComponentItem.DATA_KEY);
        if (project == null || selectedItem == null || selectedItem.isAnyComponent() || selectedItem.isSpacer()) {
            return;
        }
        ComponentItem itemToBeEdited = selectedItem.clone();
        Window parentWindow = WindowManager.getInstance().suggestParentWindow(project);
        ComponentItemDialog dialog = new ComponentItemDialog(project, parentWindow, itemToBeEdited, false);
        dialog.setTitle(UIDesignerBundle.message("title.edit.component", new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        GroupItem groupItem = null;
        Palette palette = Palette.getInstance(project);
        for (GroupItem group : palette.getGroups()) {
            if (group.containsItemCopy(selectedItem, itemToBeEdited.getClassName())) {
                return;
            }
            if (!group.containsItemClass(selectedItem.getClassName())) continue;
            groupItem = group;
        }
        LOG.assertTrue(groupItem != null);
        palette.replaceItem(groupItem, selectedItem, itemToBeEdited);
        palette.fireGroupsChanged();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            EditComponentAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            EditComponentAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        ComponentItem selectedItem = (ComponentItem)e.getData(ComponentItem.DATA_KEY);
        GroupItem groupItem = (GroupItem)e.getData(GroupItem.DATA_KEY);
        e.getPresentation().setEnabled(project != null && selectedItem != null && groupItem != null && !selectedItem.isAnyComponent() && !selectedItem.isSpacer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/palette/EditComponentAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/palette/EditComponentAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

