/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.CeProcessCanceledException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class Cancellation {
    private static final ThreadLocal<Boolean> isInNonCancelableSection = new ThreadLocal();

    private Cancellation() {
    }

    @VisibleForTesting
    @Nullable
    public static Job currentJob() {
        return ThreadContext.currentThreadContext().get(Job.Key);
    }

    public static void checkCancelled() {
        ThreadContext.warnAccidentalCancellation();
        Job currentJob = Cancellation.currentJob();
        if (currentJob != null) {
            try {
                JobKt.ensureActive(currentJob);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (CancellationException e2) {
                throw new CeProcessCanceledException(e2);
            }
        }
    }

    public static boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            Cancellation.$$$reportNull$$$0(0);
        }
        try {
            if (Cancellation.isInNonCancelableSection()) {
                return (T)computable.compute();
            }
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                Object object = computable.compute();
                return (T)object;
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
        catch (ProcessCanceledException e2) {
            throw new RuntimeException("PCE is not expected in non-cancellable section execution", e2);
        }
    }

    public static void executeInNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            Cancellation.$$$reportNull$$$0(1);
        }
        Cancellation.computeInNonCancelableSection(() -> {
            runnable.run();
            return null;
        });
    }

    @NotNull
    public static AccessToken withNonCancelableSection() {
        if (Cancellation.isInNonCancelableSection()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                Cancellation.$$$reportNull$$$0(2);
            }
            return accessToken;
        }
        isInNonCancelableSection.set(Boolean.TRUE);
        return new AccessToken(){

            @Override
            public void finish() {
                isInNonCancelableSection.remove();
            }
        };
    }

    @Deprecated
    @ApiStatus.Internal
    public static <T> T forceNonCancellableSectionInClassInitializer(@NotNull Supplier<T> computable) {
        if (computable == null) {
            Cancellation.$$$reportNull$$$0(3);
        }
        return Cancellation.computeInNonCancelableSection(computable::get);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/Cancellation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/Cancellation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withNonCancelableSection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeInNonCancelableSection";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forceNonCancellableSectionInClassInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

