/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.BitUtil;
import com.sun.jna.platform.win32.Kernel32;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NioFiles {
    public static final BasicFileAttributes BROKEN_SYMLINK = new BasicFileAttributes(){
        private final FileTime ZERO = FileTime.fromMillis(0L);

        @Override
        public FileTime lastModifiedTime() {
            return this.ZERO;
        }

        @Override
        public FileTime lastAccessTime() {
            return this.ZERO;
        }

        @Override
        public FileTime creationTime() {
            return this.ZERO;
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return true;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            return null;
        }
    };
    private static final Logger LOG = Logger.getInstance(NioFiles.class);
    private static final LinkOption[] NO_FOLLOW = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    private NioFiles() {
    }

    @Nullable
    public static Path toPath(@NotNull String path) {
        if (path == null) {
            NioFiles.$$$reportNull$$$0(0);
        }
        try {
            return Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e2) {
            return null;
        }
    }

    @NotNull
    @NlsSafe
    public static String getFileName(@NotNull Path path) {
        Path name;
        if (path == null) {
            NioFiles.$$$reportNull$$$0(1);
        }
        String string2 = ((name = path.getFileName()) != null ? name : path).toString();
        if (string2 == null) {
            NioFiles.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    public static Path createDirectories(@NotNull Path path) throws IOException {
        if (path == null) {
            NioFiles.$$$reportNull$$$0(3);
        }
        try {
            NioFiles.tryCreateDirectory(path);
        }
        catch (FileAlreadyExistsException e2) {
            throw e2;
        }
        catch (IOException e3) {
            Path parent = path.getParent();
            if (parent == null) {
                throw e3;
            }
            NioFiles.createDirectories(parent);
            NioFiles.tryCreateDirectory(path);
        }
        Path path2 = path;
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(4);
        }
        return path2;
    }

    private static void tryCreateDirectory(Path path) throws IOException {
        block2: {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e2) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw e2;
            }
        }
    }

    @NotNull
    public static Path createParentDirectories(@NotNull Path path) throws IOException {
        Path parent;
        if (path == null) {
            NioFiles.$$$reportNull$$$0(5);
        }
        if ((parent = path.getParent()) != null) {
            NioFiles.createDirectories(parent);
        }
        Path path2 = path;
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(6);
        }
        return path2;
    }

    @NotNull
    public static Path createIfNotExists(@NotNull Path path) throws IOException {
        block4: {
            if (path == null) {
                NioFiles.$$$reportNull$$$0(7);
            }
            NioFiles.createParentDirectories(path);
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e2) {
                if (Files.isRegularFile(path, new LinkOption[0])) break block4;
                throw e2;
            }
        }
        Path path2 = path;
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(8);
        }
        return path2;
    }

    public static boolean isWritable(@NotNull Path path) {
        if (path == null) {
            NioFiles.$$$reportNull$$$0(9);
        }
        try {
            return Files.isWritable(path);
        }
        catch (SecurityException e2) {
            return false;
        }
    }

    public static void setReadOnly(@NotNull Path path, boolean value) throws IOException {
        PosixFileAttributeView posixView;
        if (path == null) {
            NioFiles.$$$reportNull$$$0(10);
        }
        if ((posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            boolean modified;
            Set<PosixFilePermission> permissions = posixView.readAttributes().permissions();
            boolean bl2 = modified = value ? permissions.removeAll(Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE)) : permissions.add(PosixFilePermission.OWNER_WRITE);
            if (modified) {
                posixView.setPermissions(permissions);
            }
        } else {
            DosFileAttributeView dosView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (dosView != null) {
                dosView.setReadOnly(value);
            } else {
                throw new IOException("Not supported: " + path.getFileSystem());
            }
        }
    }

    public static void setExecutable(@NotNull Path file2) throws IOException {
        Set<PosixFilePermission> permissions;
        PosixFileAttributeView view;
        if (file2 == null) {
            NioFiles.$$$reportNull$$$0(11);
        }
        if ((view = Files.getFileAttributeView(file2, PosixFileAttributeView.class, new LinkOption[0])) != null && (permissions = view.readAttributes().permissions()).add(PosixFilePermission.OWNER_EXECUTE)) {
            view.setPermissions(permissions);
        }
    }

    @NotNull
    public static List<Path> list(@NotNull Path directory) {
        ArrayList<Path> arrayList;
        if (directory == null) {
            NioFiles.$$$reportNull$$$0(12);
        }
        try {
            ArrayList<Path> files2 = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
                for (Path path : stream) {
                    files2.add(path);
                }
            }
            arrayList = files2;
        }
        catch (IOException e2) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                NioFiles.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (arrayList == null) {
            NioFiles.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static BasicFileAttributes readAttributes(@NotNull Path path) throws IOException, SecurityException {
        BasicFileAttributes basicFileAttributes;
        if (path == null) {
            NioFiles.$$$reportNull$$$0(15);
        }
        try {
            basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, NO_FOLLOW);
        }
        catch (AccessDeniedException | NoSuchFileException e2) {
            throw e2;
        }
        catch (FileSystemException e3) {
            if (SystemInfo.isWindows && JnaLoader.isLoaded() && NioFiles.isNtfsReparsePoint(path)) {
                LOG.debug(e3);
                BasicFileAttributes basicFileAttributes2 = BROKEN_SYMLINK;
                if (basicFileAttributes2 == null) {
                    NioFiles.$$$reportNull$$$0(17);
                }
                return basicFileAttributes2;
            }
            throw e3;
        }
        if (basicFileAttributes == null) {
            NioFiles.$$$reportNull$$$0(16);
        }
        return basicFileAttributes;
    }

    private static boolean isNtfsReparsePoint(Path path) {
        int attrs = Kernel32.INSTANCE.GetFileAttributes(path.toString());
        return attrs != -1 && BitUtil.isSet(attrs, 1024);
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory) throws IOException {
        if (fileOrDirectory == null) {
            NioFiles.$$$reportNull$$$0(18);
        }
        FileUtilRt.deleteRecursively((Path)fileOrDirectory, null);
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory, @NotNull Consumer<? super Path> callback) throws IOException {
        if (fileOrDirectory == null) {
            NioFiles.$$$reportNull$$$0(19);
        }
        if (callback == null) {
            NioFiles.$$$reportNull$$$0(20);
        }
        FileUtilRt.deleteRecursively((Path)fileOrDirectory, callback::accept);
    }

    @ApiStatus.Experimental
    public static void copyRecursively(@NotNull Path from, @NotNull Path to) throws IOException {
        if (from == null) {
            NioFiles.$$$reportNull$$$0(21);
        }
        if (to == null) {
            NioFiles.$$$reportNull$$$0(22);
        }
        NioFiles.copyRecursively(from, to, null);
    }

    @ApiStatus.Experimental
    public static void copyRecursively(final @NotNull Path from, final @NotNull Path to, final @Nullable Consumer<? super Path> callback) throws IOException {
        if (from == null) {
            NioFiles.$$$reportNull$$$0(23);
        }
        if (to == null) {
            NioFiles.$$$reportNull$$$0(24);
        }
        Files.walkFileTree(from, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (callback != null) {
                    callback.accept(dir);
                }
                Path copy2 = dir == from ? to : to.resolve(from.relativize(dir));
                NioFiles.createDirectories(copy2);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                if (callback != null) {
                    callback.accept(file2);
                }
                Path copy2 = file2 == from ? to : to.resolve(from.relativize(file2));
                Files.copy(file2, copy2, LinkOption.NOFOLLOW_LINKS, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createParentDirectories";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createIfNotExists";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "readAttributes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDirectories";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createIfNotExists";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setExecutable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readAttributes";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyRecursively";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class StatsCollectingVisitor
    extends SimpleFileVisitor<Path> {
        protected abstract void countDirectory(Path var1, BasicFileAttributes var2);

        protected abstract void countFile(Path var1, BasicFileAttributes var2);

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            this.countDirectory(dir, attrs);
            if (attrs.isSymbolicLink() || SystemInfoRt.isWindows && attrs.isOther()) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
            this.countFile(file2, attrs);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file2, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

