/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class MetadataXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, Metadata metadata2) throws IOException {
        MXSerializer serializer2 = new MXSerializer();
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer2.setOutput(writer);
        serializer2.startDocument(metadata2.getModelEncoding(), null);
        this.writeMetadata(metadata2, "metadata", serializer2);
        serializer2.endDocument();
    }

    public void write(OutputStream stream, Metadata metadata2) throws IOException {
        MXSerializer serializer2 = new MXSerializer();
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer2.setOutput(stream, metadata2.getModelEncoding());
        serializer2.startDocument(metadata2.getModelEncoding(), null);
        this.writeMetadata(metadata2, "metadata", serializer2);
        serializer2.endDocument();
    }

    private void writeMetadata(Metadata metadata2, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (metadata2.getModelVersion() != null) {
            serializer2.attribute(NAMESPACE, "modelVersion", metadata2.getModelVersion());
        }
        if (metadata2.getGroupId() != null) {
            serializer2.startTag(NAMESPACE, "groupId").text(metadata2.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (metadata2.getArtifactId() != null) {
            serializer2.startTag(NAMESPACE, "artifactId").text(metadata2.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        if (metadata2.getVersioning() != null) {
            this.writeVersioning(metadata2.getVersioning(), "versioning", serializer2);
        }
        if (metadata2.getVersion() != null) {
            serializer2.startTag(NAMESPACE, "version").text(metadata2.getVersion()).endTag(NAMESPACE, "version");
        }
        if (metadata2.getPlugins() != null && metadata2.getPlugins().size() > 0) {
            serializer2.startTag(NAMESPACE, "plugins");
            for (Plugin o2 : metadata2.getPlugins()) {
                this.writePlugin(o2, "plugin", serializer2);
            }
            serializer2.endTag(NAMESPACE, "plugins");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writePlugin(Plugin plugin, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (plugin.getName() != null) {
            serializer2.startTag(NAMESPACE, "name").text(plugin.getName()).endTag(NAMESPACE, "name");
        }
        if (plugin.getPrefix() != null) {
            serializer2.startTag(NAMESPACE, "prefix").text(plugin.getPrefix()).endTag(NAMESPACE, "prefix");
        }
        if (plugin.getArtifactId() != null) {
            serializer2.startTag(NAMESPACE, "artifactId").text(plugin.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeSnapshot(Snapshot snapshot, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (snapshot.getTimestamp() != null) {
            serializer2.startTag(NAMESPACE, "timestamp").text(snapshot.getTimestamp()).endTag(NAMESPACE, "timestamp");
        }
        if (snapshot.getBuildNumber() != 0) {
            serializer2.startTag(NAMESPACE, "buildNumber").text(String.valueOf(snapshot.getBuildNumber())).endTag(NAMESPACE, "buildNumber");
        }
        if (snapshot.isLocalCopy()) {
            serializer2.startTag(NAMESPACE, "localCopy").text(String.valueOf(snapshot.isLocalCopy())).endTag(NAMESPACE, "localCopy");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeSnapshotVersion(SnapshotVersion snapshotVersion, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (snapshotVersion.getClassifier() != null && !snapshotVersion.getClassifier().equals("")) {
            serializer2.startTag(NAMESPACE, "classifier").text(snapshotVersion.getClassifier()).endTag(NAMESPACE, "classifier");
        }
        if (snapshotVersion.getExtension() != null) {
            serializer2.startTag(NAMESPACE, "extension").text(snapshotVersion.getExtension()).endTag(NAMESPACE, "extension");
        }
        if (snapshotVersion.getVersion() != null) {
            serializer2.startTag(NAMESPACE, "value").text(snapshotVersion.getVersion()).endTag(NAMESPACE, "value");
        }
        if (snapshotVersion.getUpdated() != null) {
            serializer2.startTag(NAMESPACE, "updated").text(snapshotVersion.getUpdated()).endTag(NAMESPACE, "updated");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeVersioning(Versioning versioning, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (versioning.getLatest() != null) {
            serializer2.startTag(NAMESPACE, "latest").text(versioning.getLatest()).endTag(NAMESPACE, "latest");
        }
        if (versioning.getRelease() != null) {
            serializer2.startTag(NAMESPACE, "release").text(versioning.getRelease()).endTag(NAMESPACE, "release");
        }
        if (versioning.getVersions() != null && versioning.getVersions().size() > 0) {
            serializer2.startTag(NAMESPACE, "versions");
            for (String version : versioning.getVersions()) {
                serializer2.startTag(NAMESPACE, "version").text(version).endTag(NAMESPACE, "version");
            }
            serializer2.endTag(NAMESPACE, "versions");
        }
        if (versioning.getLastUpdated() != null) {
            serializer2.startTag(NAMESPACE, "lastUpdated").text(versioning.getLastUpdated()).endTag(NAMESPACE, "lastUpdated");
        }
        if (versioning.getSnapshot() != null) {
            this.writeSnapshot(versioning.getSnapshot(), "snapshot", serializer2);
        }
        if (versioning.getSnapshotVersions() != null && versioning.getSnapshotVersions().size() > 0) {
            serializer2.startTag(NAMESPACE, "snapshotVersions");
            for (SnapshotVersion o2 : versioning.getSnapshotVersions()) {
                this.writeSnapshotVersion(o2, "snapshotVersion", serializer2);
            }
            serializer2.endTag(NAMESPACE, "snapshotVersions");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }
}

