/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.value.FontSpecification;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.swing.AWTFSFont;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AWTFontResolver
implements FontResolver {
    private final Map<String, Font> instanceHash = new HashMap<String, Font>();
    private final Map<String, Font> availableFontsHash = new HashMap<String, Font>();

    public AWTFontResolver() {
        this.init();
    }

    private void init() {
        String[] availableFonts;
        GraphicsEnvironment gfx = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String fontName : availableFonts = gfx.getAvailableFontFamilyNames()) {
            this.availableFontsHash.put(fontName, null);
        }
        this.availableFontsHash.put("Serif", new Font("Serif", 0, 1));
        this.availableFontsHash.put("SansSerif", new Font("SansSerif", 0, 1));
        this.availableFontsHash.put("Monospaced", new Font("Monospaced", 0, 1));
    }

    public void flushCache() {
        this.instanceHash.clear();
        this.availableFontsHash.clear();
        this.init();
    }

    public FSFont resolveFont(SharedContext ctx2, String[] families, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        ArrayList<Font> fonts = new ArrayList<Font>(3);
        if (families != null) {
            for (int i = 0; i < families.length; ++i) {
                Font font = this.resolveFont(ctx2, families[i], size, weight, style, variant);
                if (font == null) continue;
                fonts.add(font);
            }
        }
        String family = "SansSerif";
        if (style == IdentValue.ITALIC) {
            family = "Serif";
        }
        Font fnt = AWTFontResolver.createFont(ctx2, this.availableFontsHash.get(family), size, weight, style, variant);
        this.instanceHash.put(AWTFontResolver.getFontInstanceHashName(ctx2, family, size, weight, style, variant), fnt);
        fonts.add(fnt);
        return new AWTFSFont(fonts, size);
    }

    public void setFontMapping(String name, Font font) {
        this.availableFontsHash.put(name, font.deriveFont(1.0f));
    }

    protected static Font createFont(SharedContext ctx2, Font rootFont, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        int fontConst = 0;
        if (weight != null && (weight == IdentValue.BOLD || weight == IdentValue.FONT_WEIGHT_700 || weight == IdentValue.FONT_WEIGHT_800 || weight == IdentValue.FONT_WEIGHT_900)) {
            fontConst |= 1;
        }
        if (style != null && (style == IdentValue.ITALIC || style == IdentValue.OBLIQUE)) {
            fontConst |= 2;
        }
        Font fnt = rootFont.deriveFont(fontConst, size *= ctx2.getTextRenderer().getFontScale());
        if (variant != null && variant == IdentValue.SMALL_CAPS) {
            fnt = fnt.deriveFont((float)((double)fnt.getSize() * 0.6));
        }
        return fnt;
    }

    protected Font resolveFont(SharedContext ctx2, String font, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        String fontInstanceName;
        if (font.startsWith("\"")) {
            font = font.substring(1);
        }
        if (font.endsWith("\"")) {
            font = font.substring(0, font.length() - 1);
        }
        if (font.equalsIgnoreCase("serif")) {
            font = "Serif";
        }
        if (font.equalsIgnoreCase("sans-serif")) {
            font = "SansSerif";
        }
        if (font.equalsIgnoreCase("monospace")) {
            font = "Monospaced";
        }
        if (font.equals("Serif") && style == IdentValue.OBLIQUE) {
            font = "SansSerif";
        }
        if (font.equals("SansSerif") && style == IdentValue.ITALIC) {
            font = "Serif";
        }
        if (this.instanceHash.containsKey(fontInstanceName = AWTFontResolver.getFontInstanceHashName(ctx2, font, size, weight, style, variant))) {
            return this.instanceHash.get(fontInstanceName);
        }
        if (this.availableFontsHash.containsKey(font)) {
            Font possiblyNullFont = this.availableFontsHash.get(font);
            Font rootFont = null;
            if (possiblyNullFont != null) {
                rootFont = possiblyNullFont;
            } else {
                rootFont = new Font(font, 0, 1);
                this.availableFontsHash.put(font, rootFont);
            }
            Font fnt = AWTFontResolver.createFont(ctx2, rootFont, size, weight, style, variant);
            this.instanceHash.put(fontInstanceName, fnt);
            return fnt;
        }
        return null;
    }

    protected static String getFontInstanceHashName(SharedContext ctx2, String name, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        return name + "-" + size * ctx2.getTextRenderer().getFontScale() + "-" + weight + "-" + style + "-" + variant;
    }

    @Override
    public FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return this.resolveFont(renderingContext, spec.families, spec.size, spec.fontWeight, spec.fontStyle, spec.variant);
    }
}

