/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import org.jetbrains.annotations.NotNull;

public class HtmlEntity
extends Node
implements TextContainer {
    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        if (!this.getChars().isEmpty()) {
            out.append(" \"").append(this.getChars()).append("\"");
        }
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    public HtmlEntity() {
    }

    public HtmlEntity(BasedSequence chars) {
        super(chars);
    }

    @Override
    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags, NodeVisitor nodeVisitor) {
        if (BitFieldSet.any(flags, F_NODE_TEXT)) {
            out.append(this.getChars());
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(this.getChars());
            BasedSequence unescaped = Escaping.unescape(this.getChars(), textMapper);
            out.append(unescaped);
        }
        return false;
    }
}

