/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.welcome;

import com.intellij.llmInstaller.ui.welcome.features.WelcomeFeatureDescriptor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0007\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007J\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0007\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/WelcomeFeaturesOrderedNavigationService;", "", "()V", "orderedFeatures", "", "Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;", "addFeature", "", "feature", "clearFeatures", "", "getNextFeature", "Lkotlin/Pair;", "index", "getPreviousFeature", "Companion", "intellij.llmInstaller"})
public final class WelcomeFeaturesOrderedNavigationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<WelcomeFeatureDescriptor> orderedFeatures = new ArrayList();

    @Nullable
    public final Pair<WelcomeFeatureDescriptor, Integer> getPreviousFeature(int index) {
        if (index < 0 || index >= this.orderedFeatures.size() || this.orderedFeatures.size() < 2) {
            return null;
        }
        int previousIndex = index == 0 ? this.orderedFeatures.size() - 1 : index - 1;
        return new Pair((Object)this.orderedFeatures.get(previousIndex), (Object)previousIndex);
    }

    @Nullable
    public final Pair<WelcomeFeatureDescriptor, Integer> getNextFeature(int index) {
        if (index < 0 || index >= this.orderedFeatures.size() || this.orderedFeatures.size() < 2) {
            return null;
        }
        int nextIndex = index == this.orderedFeatures.size() - 1 ? 0 : index + 1;
        return new Pair((Object)this.orderedFeatures.get(nextIndex), (Object)nextIndex);
    }

    public final int addFeature(@NotNull WelcomeFeatureDescriptor feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this.orderedFeatures.add(feature);
        return this.orderedFeatures.size() - 1;
    }

    public final void clearFeatures() {
        this.orderedFeatures.clear();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/WelcomeFeaturesOrderedNavigationService$Companion;", "", "()V", "getInstance", "Lcom/intellij/llmInstaller/ui/welcome/WelcomeFeaturesOrderedNavigationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.llmInstaller"})
    @SourceDebugExtension(value={"SMAP\nWelcomeFeaturesOrderedNavigationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WelcomeFeaturesOrderedNavigationService.kt\ncom/intellij/llmInstaller/ui/welcome/WelcomeFeaturesOrderedNavigationService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,46:1\n31#2,2:47\n*S KotlinDebug\n*F\n+ 1 WelcomeFeaturesOrderedNavigationService.kt\ncom/intellij/llmInstaller/ui/welcome/WelcomeFeaturesOrderedNavigationService$Companion\n*L\n20#1:47,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        @NotNull
        public final WelcomeFeaturesOrderedNavigationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ThreadingAssertions.assertEventDispatchThread();
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WelcomeFeaturesOrderedNavigationService> serviceClass$iv = WelcomeFeaturesOrderedNavigationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WelcomeFeaturesOrderedNavigationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

