/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactState;

public class MavenArtifactNode
implements Serializable {
    private final MavenArtifactNode myParent;
    private final MavenArtifact myArtifact;
    private final MavenArtifactState myState;
    private final MavenArtifact myRelatedArtifact;
    private final String myOriginalScope;
    private final String myPremanagedVersion;
    private final String myPremanagedScope;
    private List<MavenArtifactNode> myDependencies;

    public MavenArtifactNode(MavenArtifactNode parent, MavenArtifact artifact, MavenArtifactState state, MavenArtifact relatedArtifact, String originalScope, String premanagedVersion, String premanagedScope) {
        this.myParent = parent;
        this.myArtifact = artifact;
        this.myState = state;
        this.myRelatedArtifact = relatedArtifact;
        this.myOriginalScope = originalScope;
        this.myPremanagedVersion = premanagedVersion;
        this.myPremanagedScope = premanagedScope;
    }

    @Nullable
    public MavenArtifactNode getParent() {
        return this.myParent;
    }

    public MavenArtifact getArtifact() {
        return this.myArtifact;
    }

    public MavenArtifactState getState() {
        return this.myState;
    }

    @Nullable
    public MavenArtifact getRelatedArtifact() {
        return this.myRelatedArtifact;
    }

    @Nullable
    public String getOriginalScope() {
        return this.myOriginalScope;
    }

    @Nullable
    public String getPremanagedVersion() {
        return this.myPremanagedVersion;
    }

    @Nullable
    public String getPremanagedScope() {
        return this.myPremanagedScope;
    }

    public List<MavenArtifactNode> getDependencies() {
        return this.myDependencies;
    }

    public void setDependencies(List<MavenArtifactNode> dependencies) {
        this.myDependencies = new ArrayList<MavenArtifactNode>(dependencies);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.myArtifact.getDisplayStringWithTypeAndClassifier());
        if (this.myState != MavenArtifactState.ADDED) {
            result.append('[').append((Object)this.myState).append(':').append(this.myRelatedArtifact.getDisplayStringWithTypeAndClassifier()).append(']');
        }
        result.append("->(");
        for (int i = 0; i < this.myDependencies.size(); ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.myDependencies.get(i));
        }
        result.append(')');
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifactNode that = (MavenArtifactNode)o;
        return this.myArtifact.equals(that.myArtifact);
    }

    public int hashCode() {
        return this.myArtifact.hashCode();
    }
}

