/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrDisjunctionTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrRemoveExceptionFix
extends PsiUpdateModCommandAction<PsiElement> {
    @IntentionName
    private final String myText;
    private final boolean myDisjunction;

    public GrRemoveExceptionFix(boolean isDisjunction) {
        super(PsiElement.class);
        this.myDisjunction = isDisjunction;
        this.myText = isDisjunction ? GroovyBundle.message("remove.exception", new Object[0]) : GroovyBundle.message("remove.catch.block", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("try.catch.fix", new Object[0]);
        if (string == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(2);
        }
        GrCatchClause target = this.myDisjunction ? GrRemoveExceptionFix.findTypeElementInDisjunction(element, context.offset()) : GrRemoveExceptionFix.findCatch(element);
        return target == null ? null : Presentation.of((String)this.myText);
    }

    @Nullable
    private static GrTypeElement findTypeElementInDisjunction(@NotNull PsiElement at, int offset) {
        GrDisjunctionTypeElement disjunction;
        if (at == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(3);
        }
        if ((disjunction = (GrDisjunctionTypeElement)PsiTreeUtil.getParentOfType((PsiElement)at, GrDisjunctionTypeElement.class)) == null) {
            return null;
        }
        for (GrTypeElement element : disjunction.getTypeElements()) {
            if (!element.getTextRange().contains(offset)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static GrCatchClause findCatch(@NotNull PsiElement at) {
        if (at == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(4);
        }
        return (GrCatchClause)PsiTreeUtil.getParentOfType((PsiElement)at, GrCatchClause.class);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement at, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(5);
        }
        if (at == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            GrRemoveExceptionFix.$$$reportNull$$$0(7);
        }
        if (this.myDisjunction) {
            GrTypeElement element = GrRemoveExceptionFix.findTypeElementInDisjunction(at, context.offset());
            if (element != null) {
                element.delete();
            }
        } else {
            GrCatchClause aCatch = GrRemoveExceptionFix.findCatch(at);
            if (aCatch != null) {
                aCatch.delete();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GrRemoveExceptionFix";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GrRemoveExceptionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTypeElementInDisjunction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findCatch";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

