/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrInExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSwitchExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteState;

public final class ControlFlowBuilderUtil {
    private ControlFlowBuilderUtil() {
    }

    @Nullable
    private static ReadBeforeWriteState getLastReadBeforeWriteState(Instruction[] flow, boolean onlyFirstRead) {
        DFAEngine<ReadBeforeWriteState> engine = new DFAEngine<ReadBeforeWriteState>(flow, new ReadBeforeWriteInstance(onlyFirstRead), ReadBeforeWriteSemilattice.INSTANCE);
        List<ReadBeforeWriteState> dfaResult = engine.performDFAWithTimeout();
        return dfaResult == null ? null : dfaResult.get(dfaResult.size() - 1);
    }

    public static List<Pair<ReadWriteVariableInstruction, VariableDescriptor>> getReadsWithoutPriorWrites(GroovyControlFlow flow, boolean onlyFirstRead) {
        ReadBeforeWriteState lastState = ControlFlowBuilderUtil.getLastReadBeforeWriteState(flow.getFlow(), onlyFirstRead);
        if (lastState == null) {
            return Collections.emptyList();
        }
        BitSet reads = lastState.getReads();
        ArrayList<Pair<ReadWriteVariableInstruction, VariableDescriptor>> result2 = new ArrayList<Pair<ReadWriteVariableInstruction, VariableDescriptor>>();
        int i2 = reads.nextSetBit(0);
        while (i2 >= 0 && i2 != Integer.MAX_VALUE) {
            ReadWriteVariableInstruction instr = (ReadWriteVariableInstruction)flow.getFlow()[i2];
            result2.add((Pair<ReadWriteVariableInstruction, VariableDescriptor>)new Pair((Object)instr, (Object)flow.getVarIndices()[instr.getDescriptor()]));
            i2 = reads.nextSetBit(i2 + 1);
        }
        return result2;
    }

    public static boolean isInstanceOfBinary(GrBinaryExpression binary) {
        if (binary instanceof GrInExpression) {
            GrExpression left = binary.getLeftOperand();
            GrExpression right = binary.getRightOperand();
            if (left instanceof GrReferenceExpression && ((GrReferenceExpression)left).getQualifier() == null && right instanceof GrReferenceExpression && ControlFlowBuilderUtil.findClassByText((GrReferenceExpression)right)) {
                return true;
            }
        }
        return false;
    }

    private static boolean findClassByText(GrReferenceExpression ref2) {
        String text = ref2.getText();
        int i2 = text.indexOf(60);
        String className = i2 == -1 ? text : text.substring(0, i2);
        PsiClass[] names = PsiShortNamesCache.getInstance((Project)ref2.getProject()).getClassesByName(className, ref2.getResolveScope());
        if (names.length > 0) {
            return true;
        }
        PsiFile file = ref2.getContainingFile();
        if (file instanceof GroovyFile) {
            GrImportStatement[] imports2;
            for (GrImportStatement anImport : imports2 = ((GroovyFile)file).getImportStatements()) {
                if (!className.equals(anImport.getImportedName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCertainlyReturnStatement(GrStatement st) {
        PsiElement parent2 = st.getParent();
        if (parent2 instanceof GrOpenBlock) {
            if (st != ArrayUtil.getLastElement((Object[])((GrOpenBlock)parent2).getStatements())) {
                return false;
            }
            PsiElement pparent = parent2.getParent();
            if (pparent instanceof GrMethod) {
                return true;
            }
            if (pparent instanceof GrBlockStatement || pparent instanceof GrCatchClause || pparent instanceof GrLabeledStatement) {
                pparent = pparent.getParent();
            }
            if (pparent instanceof GrControlStatement || pparent instanceof GrTryCatchStatement) {
                return ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)pparent);
            }
        } else {
            if (parent2 instanceof GrClosableBlock || parent2 instanceof GrBlockLambdaBody) {
                return st == ArrayUtil.getLastElement((Object[])((GrCodeBlock)parent2).getStatements());
            }
            if (parent2 instanceof GroovyFileBase) {
                return st == ArrayUtil.getLastElement((Object[])((GroovyFileBase)parent2).getStatements());
            }
            if (parent2 instanceof GrForStatement || parent2 instanceof GrIfStatement && st != ((GrIfStatement)parent2).getCondition() || parent2 instanceof GrSynchronizedStatement && st != ((GrSynchronizedStatement)parent2).getMonitor() || parent2 instanceof GrWhileStatement && st != ((GrWhileStatement)parent2).getCondition() || parent2 instanceof GrConditionalExpression && st != ((GrConditionalExpression)parent2).getCondition() || parent2 instanceof GrElvisExpression) {
                return ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)parent2);
            }
            if (parent2 instanceof GrCaseSection) {
                GrStatement switchAsStatement;
                Object[] statements2 = ((GrCaseSection)parent2).getStatements();
                GrStatement last = (GrStatement)ArrayUtil.getLastElement((Object[])statements2);
                GrSwitchElement switchElement = (GrSwitchElement)parent2.getParent();
                GrStatement grStatement = switchAsStatement = switchElement instanceof GrSwitchExpression ? (GrSwitchExpression)switchElement : (GrStatement)((Object)switchElement);
                if (last instanceof GrBreakStatement && statements2.length > 1 && statements2[statements2.length - 2] == st) {
                    return ControlFlowBuilderUtil.isCertainlyReturnStatement(switchAsStatement);
                }
                if (st == last && (st instanceof GrBreakStatement || ControlFlowBuilderUtil.isLastStatementInCaseSection((GrCaseSection)parent2, switchElement))) {
                    return ControlFlowBuilderUtil.isCertainlyReturnStatement(switchAsStatement);
                }
            }
        }
        return false;
    }

    private static boolean isLastStatementInCaseSection(GrCaseSection caseSection, GrSwitchElement switchStatement) {
        Object[] sections = switchStatement.getCaseSections();
        int i2 = ArrayUtilRt.find((Object[])sections, (Object)caseSection);
        if (i2 == sections.length - 1) {
            return true;
        }
        for (int j = i2 + 1; j < sections.length; ++j) {
            Object section = sections[j];
            for (GrStatement statement : section.getStatements()) {
                if (statement instanceof GrBreakStatement) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isCertainlyYieldStatement(GrStatement statement) {
        PsiElement parent2 = statement.getParent();
        if (parent2 instanceof GrOpenBlock || parent2 instanceof GrCaseSection) {
            if (statement != ArrayUtil.getLastElement((Object[])((GrStatementOwner)parent2).getStatements())) {
                return false;
            }
            PsiElement pparent = parent2.getParent();
            if (parent2 instanceof GrCaseSection && pparent instanceof GrSwitchElement) {
                return true;
            }
            if (pparent instanceof GrStatement) {
                return ControlFlowBuilderUtil.isCertainlyYieldStatement((GrStatement)pparent);
            }
        }
        return false;
    }
}

