/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.noncode;

import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;

public final class MixinMemberContributor {
    public static boolean processClassMixins(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            MixinMemberContributor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            MixinMemberContributor.$$$reportNull$$$0(1);
        }
        if (place == null) {
            MixinMemberContributor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            MixinMemberContributor.$$$reportNull$$$0(3);
        }
        if (MixinMemberContributor.isInAnnotation(place)) {
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierType);
        if (aClass == null) {
            return true;
        }
        if (aClass.getLanguage() != GroovyLanguage.INSTANCE) {
            return true;
        }
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return true;
        }
        ArrayList mixins = new ArrayList();
        for (PsiAnnotation annotation : MixinMemberContributor.getAllMixins(modifierList)) {
            PsiAnnotationMemberValue value2 = annotation.findAttributeValue("value");
            if (value2 instanceof GrAnnotationArrayInitializer) {
                GrAnnotationMemberValue[] initializers;
                for (GrAnnotationMemberValue initializer : initializers = ((GrAnnotationArrayInitializer)value2).getInitializers()) {
                    MixinMemberContributor.addMixin(initializer, mixins);
                }
                continue;
            }
            if (!(value2 instanceof GrExpression)) continue;
            MixinMemberContributor.addMixin((GrExpression)value2, mixins);
        }
        MixinProcessor delegate = new MixinProcessor(processor, qualifierType, place);
        for (PsiClass mixin : mixins) {
            if (mixin.processDeclarations((PsiScopeProcessor)delegate, state, null, place)) continue;
            return false;
        }
        return true;
    }

    @NonNls
    public static String getOriginInfoForCategory(PsiMethod element) {
        PsiClass aClass = element.getContainingClass();
        if (aClass != null && aClass.getName() != null) {
            return "mixed in from " + aClass.getName();
        }
        return "mixed in";
    }

    @NonNls
    public static String getOriginInfoForMixin(@NotNull PsiType subjectType) {
        if (subjectType == null) {
            MixinMemberContributor.$$$reportNull$$$0(4);
        }
        return "mixed in " + subjectType.getPresentableText();
    }

    private static List<PsiAnnotation> getAllMixins(PsiModifierList modifierList) {
        ArrayList<PsiAnnotation> result2 = new ArrayList<PsiAnnotation>();
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            if (!"groovy.lang.Mixin".equals(annotation.getQualifiedName())) continue;
            result2.add(annotation);
        }
        return result2;
    }

    private static boolean isInAnnotation(PsiElement place) {
        return place.getParent() instanceof GrAnnotation || place.getParent() instanceof GrAnnotationArrayInitializer;
    }

    private static void addMixin(GrAnnotationMemberValue value2, List<? super PsiClass> mixins) {
        PsiElement resolved;
        if (value2 instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)value2).resolve()) instanceof PsiClass) {
            mixins.add((PsiClass)((PsiClass)resolved));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subjectType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/noncode/MixinMemberContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processClassMixins";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOriginInfoForMixin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MixinProcessor
    extends DelegatingScopeProcessor {
        private final PsiType myType;
        private final PsiElement myPlace;

        public MixinProcessor(PsiScopeProcessor delegate, @NotNull PsiType qualifierType, @Nullable PsiElement place) {
            if (qualifierType == null) {
                MixinProcessor.$$$reportNull$$$0(0);
            }
            super(delegate);
            this.myType = qualifierType;
            this.myPlace = place;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            PsiMethod method;
            if (element == null) {
                MixinProcessor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                MixinProcessor.$$$reportNull$$$0(2);
            }
            if (element instanceof PsiMethod && GdkMethodUtil.isCategoryMethod(method = (PsiMethod)element, this.myType, this.myPlace, (PsiSubstitutor)state.get(PsiSubstitutor.KEY))) {
                String originInfo = MixinMemberContributor.getOriginInfoForCategory(method);
                return super.execute((PsiElement)GrGdkMethodImpl.createGdkMethod(method, false, originInfo), state);
            }
            if (element instanceof PsiMethod) {
                return super.execute((PsiElement)new MixinedMethod((PsiMethod)element, MixinMemberContributor.getOriginInfoForMixin(this.myType)), state);
            }
            return super.execute(element, state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifierType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/noncode/MixinMemberContributor$MixinProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MixinedMethod
    extends LightMethod
    implements OriginInfoAwareElement,
    PsiMirrorElement {
        private final String myOriginInfo;
        private final PsiMethod myPrototype;

        MixinedMethod(@NotNull PsiMethod method, String originInfo) {
            if (method == null) {
                MixinedMethod.$$$reportNull$$$0(0);
            }
            super(method.getManager(), method, Objects.requireNonNull(method.getContainingClass()));
            this.myOriginInfo = originInfo;
            this.myPrototype = method;
        }

        @Nullable
        public String getOriginInfo() {
            return this.myOriginInfo;
        }

        @NotNull
        public PsiElement getPrototype() {
            PsiMethod psiMethod = this.myPrototype;
            if (psiMethod == null) {
                MixinedMethod.$$$reportNull$$$0(1);
            }
            return psiMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/noncode/MixinMemberContributor$MixinedMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/noncode/MixinMemberContributor$MixinedMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrototype";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

