/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.ProcessorWithHints;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.BaseGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0016\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001!B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\nH\u0016R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/KindsResolverProcessor;", "Lcom/intellij/psi/scope/ProcessorWithHints;", "Lcom/intellij/psi/scope/NameHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind$Hint;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "kinds", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Ljava/util/Set;)V", "candidates", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "getKinds", "()Ljava/util/Set;", "getName", "()Ljava/lang/String;", "getPlace", "()Lcom/intellij/psi/PsiElement;", "execute", "", "element", "state", "Lcom/intellij/psi/ResolveState;", "executeInner", "", "getAllCandidates", "", "getCandidate", "kind", "shouldProcess", "Companion", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nKindsResolverProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KindsResolverProcessor.kt\norg/jetbrains/plugins/groovy/lang/resolve/processors/KindsResolverProcessor\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n306#2:74\n1747#3,3:75\n*S KotlinDebug\n*F\n+ 1 KindsResolverProcessor.kt\norg/jetbrains/plugins/groovy/lang/resolve/processors/KindsResolverProcessor\n*L\n36#1:74\n66#1:75,3\n*E\n"})
public class KindsResolverProcessor
extends ProcessorWithHints
implements NameHint,
GroovyResolveKind.Hint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final PsiElement place;
    @NotNull
    private final Set<GroovyResolveKind> kinds;
    @NotNull
    private final Map<GroovyResolveKind, GroovyResolveResult> candidates;
    @NotNull
    private static final Set<GroovyResolveKind> propertyKinds;

    public KindsResolverProcessor(@NotNull String name, @NotNull PsiElement place, @NotNull Set<? extends GroovyResolveKind> kinds) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter(kinds, (String)"kinds");
        this.name = name;
        this.place = place;
        this.kinds = kinds;
        this.hint(NameHint.KEY, this);
        this.hint(GroovyResolveKind.HINT_KEY, this);
        boolean $i$f$enumMapOf = false;
        this.candidates = new EnumMap(GroovyResolveKind.class);
    }

    @NotNull
    protected final String getName() {
        return this.name;
    }

    @NotNull
    protected final PsiElement getPlace() {
        return this.place;
    }

    @NotNull
    protected final Set<GroovyResolveKind> getKinds() {
        return this.kinds;
    }

    @NotNull
    public final String getName(@NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.name;
    }

    @Override
    public boolean shouldProcess(@NotNull GroovyResolveKind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return this.kinds.contains((Object)kind) && !this.candidates.containsKey((Object)kind);
    }

    private final void executeInner(PsiElement element, ResolveState state) {
        if (!(element instanceof PsiNamedElement || element instanceof GrReferenceElement && ResolveUtilKt.isReferenceResolveTarget((GrReferenceElement)element))) {
            return;
        }
        if (!element.isValid()) {
            boolean $i$a$-require-KindsResolverProcessor$executeInner$22 = false;
            String $i$a$-require-KindsResolverProcessor$executeInner$22 = "Invalid element. " + PsiUtilKt.elementInfo(element);
            throw new IllegalArgumentException($i$a$-require-KindsResolverProcessor$executeInner$22.toString());
        }
        String elementName = ResolveUtilKt.getName(state, element);
        if (!Intrinsics.areEqual((Object)this.name, (Object)elementName)) {
            return;
        }
        GroovyResolveKind kind = ResolveUtilKt.getResolveKind(element);
        if (kind == null) {
            ResolveUtilKt.getLog().warn("Unknown kind. " + PsiUtilKt.elementInfo(element));
        } else if (!this.kinds.contains((Object)kind)) {
            if (!Intrinsics.areEqual((Object)state.get(ResolveUtilKt.sorryCannotKnowElementKind), (Object)true)) {
                ResolveUtilKt.getLog().error("Unneeded kind: " + kind + ". " + PsiUtilKt.elementInfo(element));
            }
        } else if (!this.candidates.containsKey((Object)kind)) {
            boolean invokedOnProperty = propertyKinds.contains((Object)kind);
            Map<GroovyResolveKind, GroovyResolveResult> map2 = this.candidates;
            Object object = this.place;
            object = new BaseGroovyResolveResult<PsiElement>(element, state, invokedOnProperty, object){
                final /* synthetic */ boolean $invokedOnProperty;
                {
                    this.$invokedOnProperty = $invokedOnProperty;
                    super($element, $super_call_param$1, $state);
                }

                public boolean isInvokedOnProperty() {
                    return this.$invokedOnProperty;
                }
            };
            map2.put(kind, (GroovyResolveResult)object);
        }
    }

    public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.executeInner(element, state);
            Iterable $this$any$iv = this.kinds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GroovyResolveKind it = (GroovyResolveKind)((Object)element$iv);
                    boolean bl2 = false;
                    boolean bl3 = !this.candidates.containsKey((Object)it);
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final GroovyResolveResult getCandidate(@NotNull GroovyResolveKind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return this.candidates.get((Object)kind);
    }

    @NotNull
    public final List<GroovyResolveResult> getAllCandidates() {
        return CollectionsKt.toList((Iterable)this.candidates.values());
    }

    static {
        GroovyResolveKind[] groovyResolveKindArray = new GroovyResolveKind[]{GroovyResolveKind.VARIABLE, GroovyResolveKind.BINDING, GroovyResolveKind.FIELD, GroovyResolveKind.PROPERTY};
        propertyKinds = SetsKt.setOf((Object[])groovyResolveKindArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/KindsResolverProcessor$Companion;", "", "()V", "propertyKinds", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

