/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api.graphql;

import com.intellij.collaboration.api.HttpApiHelper;
import com.intellij.collaboration.api.HttpApiHelperKt;
import com.intellij.collaboration.api.dto.GraphQLErrorDTO;
import com.intellij.collaboration.api.dto.GraphQLRequestDTO;
import com.intellij.collaboration.api.dto.GraphQLResponseDTO;
import com.intellij.collaboration.api.dto.GraphQLResponseDTOKt;
import com.intellij.collaboration.api.graphql.GraphQLApiHelper;
import com.intellij.collaboration.api.graphql.GraphQLDataDeserializer;
import com.intellij.collaboration.api.httpclient.ByteArrayProducingBodyPublisher;
import com.intellij.collaboration.api.httpclient.HttpClientUtil;
import com.intellij.collaboration.api.json.HttpJsonDeserializationException;
import com.intellij.collaboration.api.json.JsonDataSerializer;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Image;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096A\u00a2\u0006\u0002\u0010\u0010JH\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00120\f\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J(\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0011\u0010\u000e\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0096\u0001J\u0011\u0010\u000e\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0017H\u0096\u0001J\u001e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096A\u00a2\u0006\u0002\u0010\u0010J2\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00120\f\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00120$H\u0096A\u00a2\u0006\u0002\u0010%R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/collaboration/api/graphql/GraphQLApiHelperImpl;", "Lcom/intellij/collaboration/api/graphql/GraphQLApiHelper;", "Lcom/intellij/collaboration/api/HttpApiHelper;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "httpHelper", "serializer", "Lcom/intellij/collaboration/api/json/JsonDataSerializer;", "deserializer", "Lcom/intellij/collaboration/api/graphql/GraphQLDataDeserializer;", "(Lcom/intellij/openapi/diagnostic/Logger;Lcom/intellij/collaboration/api/HttpApiHelper;Lcom/intellij/collaboration/api/json/JsonDataSerializer;Lcom/intellij/collaboration/api/graphql/GraphQLDataDeserializer;)V", "loadImage", "Ljava/net/http/HttpResponse;", "Ljava/awt/Image;", "request", "Ljava/net/http/HttpRequest;", "(Ljava/net/http/HttpRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadResponseByClass", "T", "clazz", "Ljava/lang/Class;", "pathFromData", "", "", "(Ljava/net/http/HttpRequest;Ljava/lang/Class;[Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "query", "uri", "Ljava/net/URI;", "loadQuery", "Lkotlin/Function0;", "variablesObject", "", "Ljava/net/http/HttpRequest$Builder;", "sendAndAwaitCancellable", "", "bodyHandler", "Ljava/net/http/HttpResponse$BodyHandler;", "(Ljava/net/http/HttpRequest;Ljava/net/http/HttpResponse$BodyHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.collaborationTools"})
final class GraphQLApiHelperImpl
implements GraphQLApiHelper,
HttpApiHelper {
    @NotNull
    private final Logger logger;
    @NotNull
    private final HttpApiHelper httpHelper;
    @NotNull
    private final JsonDataSerializer serializer;
    @NotNull
    private final GraphQLDataDeserializer deserializer;

    public GraphQLApiHelperImpl(@NotNull Logger logger, @NotNull HttpApiHelper httpHelper, @NotNull JsonDataSerializer serializer, @NotNull GraphQLDataDeserializer deserializer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)httpHelper, (String)"httpHelper");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)deserializer, (String)"deserializer");
        this.logger = logger;
        this.httpHelper = httpHelper;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @Override
    @Nullable
    public Object loadImage(@NotNull HttpRequest request, @NotNull Continuation<? super HttpResponse<? extends Image>> $completion) {
        return this.httpHelper.loadImage(request, $completion);
    }

    @Override
    @NotNull
    public HttpRequest.Builder request(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.httpHelper.request(uri);
    }

    @Override
    @NotNull
    public HttpRequest.Builder request(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.httpHelper.request(uri);
    }

    @Override
    @Nullable
    public Object sendAndAwaitCancellable(@NotNull HttpRequest request, @NotNull Continuation<? super HttpResponse<? extends Unit>> $completion) {
        return this.httpHelper.sendAndAwaitCancellable(request, $completion);
    }

    @Override
    @Nullable
    public <T> Object sendAndAwaitCancellable(@NotNull HttpRequest request, @NotNull HttpResponse.BodyHandler<T> bodyHandler2, @NotNull Continuation<? super HttpResponse<? extends T>> $completion) {
        return this.httpHelper.sendAndAwaitCancellable(request, bodyHandler2, $completion);
    }

    @Override
    @NotNull
    public HttpRequest query(@NotNull URI uri, @NotNull Function0<String> loadQuery2, @Nullable Object variablesObject) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(loadQuery2, (String)"loadQuery");
        ByteArrayProducingBodyPublisher publisher2 = new ByteArrayProducingBodyPublisher((Function0<byte[]>)((Function0)new Function0<byte[]>(this, uri, loadQuery2, variablesObject){
            final /* synthetic */ GraphQLApiHelperImpl this$0;
            final /* synthetic */ URI $uri;
            final /* synthetic */ Function0<String> $loadQuery;
            final /* synthetic */ Object $variablesObject;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                this.$loadQuery = $loadQuery;
                this.$variablesObject = $variablesObject;
                super(0);
            }

            @NotNull
            public final byte[] invoke() {
                GraphQLApiHelperImpl.access$getLogger$p(this.this$0).debug("GraphQL request " + this.$uri);
                String query2 = (String)this.$loadQuery.invoke();
                GraphQLRequestDTO request = new GraphQLRequestDTO(query2, this.$variablesObject);
                byte[] jsonBytes = GraphQLApiHelperImpl.access$getSerializer$p(this.this$0).toJsonBytes(request);
                if (GraphQLApiHelperImpl.access$getLogger$p(this.this$0).isTraceEnabled()) {
                    GraphQLApiHelperImpl.access$getLogger$p(this.this$0).trace("GraphQL request " + this.$uri + " : Request body: " + new String(jsonBytes, Charsets.UTF_8));
                }
                return jsonBytes;
            }
        }));
        HttpRequest httpRequest = this.httpHelper.request(uri).POST(publisher2).header("Content-Type", "application/json").build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"build(...)");
        return httpRequest;
    }

    @Override
    @Nullable
    public <T> Object loadResponseByClass(@NotNull HttpRequest request, @NotNull Class<T> clazz, @NotNull String[] pathFromData, @NotNull Continuation<? super HttpResponse<? extends T>> $completion) {
        HttpResponse.BodyHandler handler2 = HttpClientUtil.INSTANCE.inflateAndReadWithErrorHandlingAndLogging(this.logger, request, (Function2)new Function2<Reader, HttpResponse.ResponseInfo, T>(this, pathFromData, clazz, request){
            final /* synthetic */ GraphQLApiHelperImpl this$0;
            final /* synthetic */ String[] $pathFromData;
            final /* synthetic */ Class<T> $clazz;
            final /* synthetic */ HttpRequest $request;
            {
                this.this$0 = $receiver;
                this.$pathFromData = $pathFromData;
                this.$clazz = $clazz;
                this.$request = $request;
                super(2);
            }

            @Nullable
            public final T invoke(@NotNull Reader reader, @NotNull HttpResponse.ResponseInfo responseInfo) {
                GraphQLResponseDTO<T, GraphQLErrorDTO> graphQLResponseDTO;
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"<anonymous parameter 1>");
                try {
                    graphQLResponseDTO = GraphQLApiHelperImpl.access$getDeserializer$p(this.this$0).readAndMapGQLResponse(reader, this.$pathFromData, this.$clazz);
                }
                catch (Throwable e) {
                    GraphQLApiHelperImpl.access$getLogger$p(this.this$0).warn("API response deserialization failed", e);
                    throw new HttpJsonDeserializationException(HttpApiHelperKt.logName(this.$request), e);
                }
                GraphQLResponseDTO<T, GraphQLErrorDTO> result = graphQLResponseDTO;
                return GraphQLResponseDTOKt.getOrThrow(result);
            }
        });
        return this.httpHelper.sendAndAwaitCancellable(request, handler2, $completion);
    }

    public static final /* synthetic */ Logger access$getLogger$p(GraphQLApiHelperImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ JsonDataSerializer access$getSerializer$p(GraphQLApiHelperImpl $this) {
        return $this.serializer;
    }

    public static final /* synthetic */ GraphQLDataDeserializer access$getDeserializer$p(GraphQLApiHelperImpl $this) {
        return $this.deserializer;
    }
}

