/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.issues;

import com.intellij.collaboration.ui.codereview.issues.IssueIdsProcessorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0000\u001a\u001b\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001ad\u0010\u0005\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022@\u0010\t\u001a<\u0012\u0018\u0012\u00160\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0003\u0012\u0018\u0012\u00160\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020\u00010\nH\u0002\u001a \u0010\r\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\u000e\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u001a \u0010\u000f\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\u0010\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a8\u0010\u0014\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00130\u0013 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00170\u0015*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"markdownLink", "", "Lcom/intellij/openapi/util/NlsSafe;", "text", "target", "processIssueIds", "project", "Lcom/intellij/openapi/project/Project;", "textToProcess", "linkConverter", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "processIssueIdsHtml", "htmlText", "processIssueIdsMarkdown", "markdown", "isPossiblyLink", "", "Lcom/intellij/openapi/vcs/IssueNavigationConfiguration$LinkMatch;", "parseIssuesAndLinks", "", "kotlin.jvm.PlatformType", "", "intellij.platform.collaborationTools"})
@SourceDebugExtension(value={"SMAP\nissueIdsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 issueIdsProcessor.kt\ncom/intellij/collaboration/ui/codereview/issues/IssueIdsProcessorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n766#2:49\n857#2,2:50\n*S KotlinDebug\n*F\n+ 1 issueIdsProcessor.kt\ncom/intellij/collaboration/ui/codereview/issues/IssueIdsProcessorKt\n*L\n32#1:49\n32#1:50,2\n*E\n"})
public final class IssueIdsProcessorKt {
    @NotNull
    public static final String markdownLink(@NotNull String text2, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return "[" + text2 + "](" + target + ")";
    }

    @NotNull
    public static final String processIssueIdsMarkdown(@NotNull Project project, @NotNull String markdown) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
        return IssueIdsProcessorKt.processIssueIds(project, markdown, (Function2<? super String, ? super String, String>)((Function2)processIssueIdsMarkdown.1.INSTANCE));
    }

    @NotNull
    public static final String processIssueIdsHtml(@NotNull Project project, @NotNull String htmlText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
        return IssueIdsProcessorKt.processIssueIds(project, htmlText, (Function2<? super String, ? super String, String>)((Function2)processIssueIdsHtml.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private static final String processIssueIds(Project project, String textToProcess, Function2<? super String, ? super String, String> linkConverter) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        StringBuilder markdownWithIssueLinksBuilder = new StringBuilder();
        List<IssueNavigationConfiguration.LinkMatch> list2 = IssueIdsProcessorKt.parseIssuesAndLinks(textToProcess, project);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"parseIssuesAndLinks(...)");
        Iterable iterable = list2;
        String string = textToProcess;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IssueNavigationConfiguration.LinkMatch it = (IssueNavigationConfiguration.LinkMatch)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(!IssueIdsProcessorKt.isPossiblyLink(it, textToProcess))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        IssueNavigationConfiguration.processTextWithLinks((String)string, (List)((List)destination$iv$iv), arg_0 -> IssueIdsProcessorKt.processIssueIds$lambda$1((Function1)new Function1<String, Unit>(markdownWithIssueLinksBuilder){
            final /* synthetic */ StringBuilder $markdownWithIssueLinksBuilder;
            {
                this.$markdownWithIssueLinksBuilder = $markdownWithIssueLinksBuilder;
                super(1);
            }

            public final void invoke(String text2) {
                this.$markdownWithIssueLinksBuilder.append(text2);
            }
        }, arg_0), (arg_0, arg_1) -> IssueIdsProcessorKt.processIssueIds$lambda$2((Function2)new Function2<String, String, Unit>(markdownWithIssueLinksBuilder, linkConverter){
            final /* synthetic */ StringBuilder $markdownWithIssueLinksBuilder;
            final /* synthetic */ Function2<String, String, String> $linkConverter;
            {
                this.$markdownWithIssueLinksBuilder = $markdownWithIssueLinksBuilder;
                this.$linkConverter = $linkConverter;
                super(2);
            }

            public final void invoke(String text2, String target) {
                Intrinsics.checkNotNull((Object)text2);
                Intrinsics.checkNotNull((Object)target);
                this.$markdownWithIssueLinksBuilder.append((String)this.$linkConverter.invoke((Object)text2, (Object)target));
            }
        }, arg_0, arg_1));
        String string2 = markdownWithIssueLinksBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final List<IssueNavigationConfiguration.LinkMatch> parseIssuesAndLinks(String $this$parseIssuesAndLinks, Project project) {
        return IssueNavigationConfiguration.getInstance((Project)project).findIssueLinks((CharSequence)$this$parseIssuesAndLinks);
    }

    private static final boolean isPossiblyLink(IssueNavigationConfiguration.LinkMatch $this$isPossiblyLink, String textToProcess) {
        return URLUtil.canContainUrl((String)((Object)$this$isPossiblyLink.getRange().subSequence((CharSequence)textToProcess)).toString());
    }

    private static final void processIssueIds$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processIssueIds$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

