/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.context.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.webSymbols.context.WebSymbolContextChangeListener;
import com.intellij.webSymbols.context.WebSymbolsContext;
import com.intellij.webSymbols.context.impl.ContextFileConfigInDir;
import com.intellij.webSymbols.context.impl.ContextRulesConfigInDir;
import com.intellij.webSymbols.context.impl.WebSymbolsContextDiscoveryInfo;
import com.intellij.webSymbols.context.impl.WebSymbolsContextDiscoveryKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\tJ-\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\t2\n\u0010\u001b\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\u001c\u001a\u00060\u000ej\u0002`\u001d\u00a2\u0006\u0002\u0010\u001eJ(\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\t2\n\u0010\u001b\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\u001c\u001a\u00060\u000ej\u0002`\u001dR)\u0010\u0007\u001a\u001d\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/webSymbols/context/impl/WebSymbolsContextDiscoveryInfo;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "cachedData", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/webSymbols/context/impl/WebSymbolsContextDiscoveryInfo$CachedData;", "previousContext", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/webSymbols/ContextKind;", "", "dispose", "", "getCachedDataForDir", "dir", "getContextFileConfigInDir", "Lcom/intellij/webSymbols/context/impl/ContextFileConfigInDir;", "getContextRulesConfigInDir", "Lcom/intellij/webSymbols/context/impl/ContextRulesConfigInDir;", "getProximityFromExtensions", "", "kind", "name", "Lcom/intellij/webSymbols/ContextName;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Integer;", "updateContext", "contextFile", "CachedData", "intellij.platform.webSymbols"})
final class WebSymbolsContextDiscoveryInfo
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ConcurrentHashMap<String, Map<VirtualFile, String>> previousContext;
    @NotNull
    private final ConcurrentMap<VirtualFile, CachedData> cachedData;

    public WebSymbolsContextDiscoveryInfo(@NotNull Project project2, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project2;
        this.cs = cs;
        this.previousContext = new ConcurrentHashMap();
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.cachedData = concurrentMap;
        MessageBusConnection messageBus = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = ModuleRootListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBus.subscribe(topic, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                previousContext.clear();
                cachedData.clear();
                1 $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(1.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Notifying that Web Symbol context may have changed due to roots changes.");
                ((WebSymbolContextChangeListener)project.getMessageBus().syncPublisher(WebSymbolContextChangeListener.Companion.getTOPIC())).contextMayHaveChanged();
            }
        });
        messageBus.subscribe(WebSymbolContextChangeListener.Companion.getTOPIC(), () -> WebSymbolsContextDiscoveryInfo._init_$lambda$0(this));
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        messageBus.subscribe(topic2, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Object v1;
                block2: {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    Iterable iterable = events;
                    for (Object t : iterable) {
                        VFileEvent it = (VFileEvent)t;
                        boolean bl = false;
                        VirtualFile virtualFile = it.getFile();
                        if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getName() : null), (Object)WebSymbolsContext.WEB_SYMBOLS_CONTEXT_FILE)) continue;
                        v1 = t;
                        break block2;
                    }
                    v1 = null;
                }
                VFileEvent wsFile = v1;
                if (wsFile != null) {
                    3 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(3.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("Notifying that Web Symbol context may have changed due to changes in " + wsFile.getPath() + ".");
                    BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ WebSymbolsContextDiscoveryInfo this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    ((WebSymbolContextChangeListener)WebSymbolsContextDiscoveryInfo.access$getProject$p(this.this$0).getMessageBus().syncPublisher(WebSymbolContextChangeListener.Companion.getTOPIC())).contextMayHaveChanged();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }
        });
    }

    @Nullable
    public final Integer getProximityFromExtensions(@NotNull VirtualFile dir, @NotNull String kind, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Integer)this.getCachedDataForDir(dir).getProximity().computeIfAbsent((Pair<String, String>)new Pair((Object)kind, (Object)name), arg_0 -> WebSymbolsContextDiscoveryInfo.getProximityFromExtensions$lambda$1((Function1)new Function1<Pair<? extends String, ? extends String>, CachedValue<Integer>>(this, kind, name, dir){
            final /* synthetic */ WebSymbolsContextDiscoveryInfo this$0;
            final /* synthetic */ String $kind;
            final /* synthetic */ String $name;
            final /* synthetic */ VirtualFile $dir;
            {
                this.this$0 = $receiver;
                this.$kind = $kind;
                this.$name = $name;
                this.$dir = $dir;
                super(1);
            }

            @NotNull
            public final CachedValue<Integer> invoke(@NotNull Pair<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return CachedValuesManager.getManager((Project)WebSymbolsContextDiscoveryInfo.access$getProject$p(this.this$0)).createCachedValue(() -> getProximityFromExtensions.1.invoke$lambda$0(this.$kind, this.$name, this.this$0, this.$dir));
            }

            private static final CachedValueProvider.Result invoke$lambda$0(String $kind, String $name, WebSymbolsContextDiscoveryInfo this$0, VirtualFile $dir) {
                Intrinsics.checkNotNullParameter((Object)$kind, (String)"$kind");
                Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$dir, (String)"$dir");
                return WebSymbolsContextDiscoveryKt.access$webContextProximityFromProviders($kind, $name, WebSymbolsContextDiscoveryInfo.access$getProject$p(this$0), $dir);
            }
        }, arg_0)).getValue();
    }

    @Nullable
    public final String updateContext(@NotNull VirtualFile contextFile, @NotNull String kind, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.previousContext.computeIfAbsent(kind, arg_0 -> WebSymbolsContextDiscoveryInfo.updateContext$lambda$2(updateContext.1.INSTANCE, arg_0)).put(contextFile, name);
    }

    @NotNull
    public final ContextRulesConfigInDir getContextRulesConfigInDir(@NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Object object = this.getCachedDataForDir(dir).getRulesConfig().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ContextRulesConfigInDir)object;
    }

    @NotNull
    public final ContextFileConfigInDir getContextFileConfigInDir(@NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Object object = this.getCachedDataForDir(dir).getFilesConfig().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ContextFileConfigInDir)object;
    }

    private final CachedData getCachedDataForDir(VirtualFile dir) {
        CachedData cachedData = this.cachedData.computeIfAbsent(dir, arg_0 -> WebSymbolsContextDiscoveryInfo.getCachedDataForDir$lambda$3((Function1)new Function1<VirtualFile, CachedData>(this, dir){
            final /* synthetic */ WebSymbolsContextDiscoveryInfo this$0;
            final /* synthetic */ VirtualFile $dir;
            {
                this.this$0 = $receiver;
                this.$dir = $dir;
                super(1);
            }

            public final CachedData invoke(VirtualFile it) {
                return new CachedData(WebSymbolsContextDiscoveryInfo.access$getProject$p(this.this$0), this.$dir);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)cachedData, (String)"computeIfAbsent(...)");
        return cachedData;
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(WebSymbolsContextDiscoveryInfo this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DaemonCodeAnalyzer.getInstance((Project)this$0.project).restart();
    }

    private static final CachedValue getProximityFromExtensions$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CachedValue)$tmp0.invoke(p0);
    }

    private static final Map updateContext$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final CachedData getCachedDataForDir$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CachedData)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\f\u001a*\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\b\u0012\u00060\u000fj\u0002`\u00110\u000e\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/webSymbols/context/impl/WebSymbolsContextDiscoveryInfo$CachedData;", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "filesConfig", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/webSymbols/context/impl/ContextFileConfigInDir;", "getFilesConfig", "()Lcom/intellij/psi/util/CachedValue;", "proximity", "", "Lkotlin/Pair;", "", "Lcom/intellij/webSymbols/ContextKind;", "Lcom/intellij/webSymbols/ContextName;", "", "getProximity", "()Ljava/util/Map;", "rulesConfig", "Lcom/intellij/webSymbols/context/impl/ContextRulesConfigInDir;", "getRulesConfig", "intellij.platform.webSymbols"})
    private static final class CachedData {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile directory;
        @NotNull
        private final Map<Pair<String, String>, CachedValue<Integer>> proximity;
        @NotNull
        private final CachedValue<ContextRulesConfigInDir> rulesConfig;
        @NotNull
        private final CachedValue<ContextFileConfigInDir> filesConfig;

        public CachedData(@NotNull Project project2, @NotNull VirtualFile directory) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            this.project = project2;
            this.directory = directory;
            this.proximity = new ConcurrentHashMap();
            CachedValue cachedValue = CachedValuesManager.getManager((Project)this.project).createCachedValue(() -> CachedData.rulesConfig$lambda$0(this));
            Intrinsics.checkNotNullExpressionValue((Object)cachedValue, (String)"createCachedValue(...)");
            this.rulesConfig = cachedValue;
            CachedValue cachedValue2 = CachedValuesManager.getManager((Project)this.project).createCachedValue(() -> CachedData.filesConfig$lambda$1(this));
            Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"createCachedValue(...)");
            this.filesConfig = cachedValue2;
        }

        @NotNull
        public final Map<Pair<String, String>, CachedValue<Integer>> getProximity() {
            return this.proximity;
        }

        @NotNull
        public final CachedValue<ContextRulesConfigInDir> getRulesConfig() {
            return this.rulesConfig;
        }

        @NotNull
        public final CachedValue<ContextFileConfigInDir> getFilesConfig() {
            return this.filesConfig;
        }

        private static final CachedValueProvider.Result rulesConfig$lambda$0(CachedData this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ContextRulesConfigInDir result2 = WebSymbolsContextDiscoveryKt.access$loadContextRulesConfiguration(this$0.project, this$0.directory);
            return CachedValueProvider.Result.create((Object)result2, (Collection)result2.getDependencies());
        }

        private static final CachedValueProvider.Result filesConfig$lambda$1(CachedData this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ContextFileConfigInDir result2 = WebSymbolsContextDiscoveryKt.access$loadContextFilesConfiguration(this$0.directory);
            return CachedValueProvider.Result.create((Object)result2, (Collection)result2.getDependencies());
        }
    }
}

