/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.customElements.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.webSymbols.customElements.json.ClassField;
import com.intellij.webSymbols.customElements.json.CustomElementsMember;
import com.intellij.webSymbols.customElements.json.Deprecated;
import com.intellij.webSymbols.customElements.json.MemberBase;
import com.intellij.webSymbols.customElements.json.Parameter;
import com.intellij.webSymbols.customElements.json.Reference;
import com.intellij.webSymbols.customElements.json.Return;
import com.intellij.webSymbols.customElements.json.SourceReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"deprecated", "description", "inheritedFrom", "name", "parameters", "privacy", "return", "source", "static", "summary"})
public class ClassMethod
extends MemberBase
implements CustomElementsMember {
    @JsonProperty(value="deprecated")
    @JsonPropertyDescription(value="Whether the function is deprecated.\nIf the value is a string, it's the reason for the deprecation.")
    private Deprecated deprecated;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="A markdown description.")
    private String description;
    @JsonProperty(value="inheritedFrom")
    @JsonPropertyDescription(value="A reference to an export of a module.\n\nAll references are required to be publically accessible, so the canonical\nrepresentation of a reference is the export it's available from.\n\n`package` should generally refer to an npm package name. If `package` is\nundefined then the reference is local to this package. If `module` is\nundefined the reference is local to the containing module.\n\nReferences to global symbols like `Array`, `HTMLElement`, or `Event` should\nuse a `package` name of `\"global:\"`.")
    private Reference inheritedFrom;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="parameters")
    private List<Parameter> parameters = new ArrayList<Parameter>();
    @JsonProperty(value="privacy")
    private ClassField.Privacy privacy;
    @JsonProperty(value="return")
    private Return _return;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="A reference to the source of a declaration or member.")
    private SourceReference source;
    @JsonProperty(value="static")
    private Boolean _static;
    @JsonProperty(value="summary")
    @JsonPropertyDescription(value="A markdown summary suitable for display in a listing.")
    private String summary;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    @JsonProperty(value="deprecated")
    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Deprecated deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description2) {
        this.description = description2;
    }

    @Override
    @JsonProperty(value="inheritedFrom")
    public Reference getInheritedFrom() {
        return this.inheritedFrom;
    }

    @JsonProperty(value="inheritedFrom")
    public void setInheritedFrom(Reference inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="parameters")
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    @JsonProperty(value="privacy")
    public ClassField.Privacy getPrivacy() {
        return this.privacy;
    }

    @JsonProperty(value="privacy")
    public void setPrivacy(ClassField.Privacy privacy) {
        this.privacy = privacy;
    }

    @JsonProperty(value="return")
    public Return getReturn() {
        return this._return;
    }

    @JsonProperty(value="return")
    public void setReturn(Return _return) {
        this._return = _return;
    }

    @Override
    @JsonProperty(value="source")
    public SourceReference getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(SourceReference source2) {
        this.source = source2;
    }

    @Override
    @JsonProperty(value="static")
    public Boolean getStatic() {
        return this._static;
    }

    @JsonProperty(value="static")
    public void setStatic(Boolean _static) {
        this._static = _static;
    }

    @Override
    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary2) {
        this.summary = summary2;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

