/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection.custom;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.profile.codeInspection.ui.InspectionMetaDataDialog;
import com.intellij.profile.codeInspection.ui.InspectionProfileActionProvider;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import java.util.List;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.custom.CustomRegExpInspection;
import org.intellij.lang.regexp.inspection.custom.RegExpDialog;
import org.intellij.lang.regexp.inspection.custom.RegExpInspectionConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpProfileActionProvider
extends InspectionProfileActionProvider {
    @Nullable
    public ActionGroup getAddActions(@NotNull SingleInspectionProfilePanel panel) {
        if (panel == null) {
            RegExpProfileActionProvider.$$$reportNull$$$0(0);
        }
        return RegExpProfileActionProvider.getActionGroup(panel);
    }

    public List<InspectionProfileActionProvider.ProfilePanelAction> getProfilePanelActions(SingleInspectionProfilePanel panel) {
        return List.of(new InspectionProfileActionProvider.ProfilePanelAction((AnAction)RegExpProfileActionProvider.getActionGroup(panel), "regexp.profile.action.provider.add.group"));
    }

    @NotNull
    private static DefaultActionGroup getActionGroup(@NotNull SingleInspectionProfilePanel panel) {
        if (panel == null) {
            RegExpProfileActionProvider.$$$reportNull$$$0(1);
        }
        return new DefaultActionGroup(new AnAction[]{new AddCustomRegExpInspectionAction(panel, RegExpBundle.message("action.add.regexp.search.inspection.text", new Object[0]), false), new AddCustomRegExpInspectionAction(panel, RegExpBundle.message("action.add.regexp.replace.inspection.text", new Object[0]), true)});
    }

    public boolean canDeleteInspection(InspectionProfileEntry entry2) {
        return entry2 instanceof CustomRegExpInspection;
    }

    public void deleteInspection(InspectionProfileEntry entry2, String shortName) {
        if (entry2 instanceof CustomRegExpInspection) {
            CustomRegExpInspection regExpInspection = (CustomRegExpInspection)entry2;
            regExpInspection.removeConfigurationWithUuid(shortName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "panel";
        objectArray2[1] = "org/intellij/lang/regexp/inspection/custom/RegExpProfileActionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAddActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class AddCustomRegExpInspectionAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;
        private final boolean myReplace;

        AddCustomRegExpInspectionAction(@NotNull SingleInspectionProfilePanel panel, @NlsActions.ActionText String text2, boolean replace) {
            if (panel == null) {
                AddCustomRegExpInspectionAction.$$$reportNull$$$0(0);
            }
            super(text2);
            this.myPanel = panel;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            RegExpDialog dialog;
            if (e == null) {
                AddCustomRegExpInspectionAction.$$$reportNull$$$0(1);
            }
            if (!(dialog = new RegExpDialog(e.getProject(), true, this.myReplace ? RegExpInspectionConfiguration.InspectionPattern.EMPTY_REPLACE_PATTERN : null)).showAndGet()) {
                return;
            }
            RegExpInspectionConfiguration.InspectionPattern pattern2 = dialog.getPattern();
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            CustomRegExpInspection inspection = CustomRegExpInspection.getCustomRegExpInspection((InspectionProfile)profile);
            Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project2 == null) {
                return;
            }
            InspectionMetaDataDialog metaDataDialog = inspection.createMetaDataDialog(project2, profile.getDisplayName(), null);
            if (pattern2.replacement() != null) {
                metaDataDialog.showCleanupOption(false);
            }
            if (!metaDataDialog.showAndGet()) {
                return;
            }
            RegExpInspectionConfiguration configuration = new RegExpInspectionConfiguration(metaDataDialog.getName());
            configuration.addPattern(pattern2);
            configuration.setDescription(metaDataDialog.getDescription());
            configuration.setSuppressId(metaDataDialog.getSuppressId());
            configuration.setProblemDescriptor(metaDataDialog.getProblemDescriptor());
            configuration.setCleanup(metaDataDialog.isCleanup());
            configuration.setUuid(null);
            inspection.addConfiguration(configuration);
            CustomRegExpInspection.addInspectionToProfile(project2, (InspectionProfileImpl)profile, configuration);
            profile.setModified(true);
            profile.getProfileManager().fireProfileChanged((InspectionProfileImpl)profile);
            this.myPanel.selectInspectionTool(configuration.getUuid());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/lang/regexp/inspection/custom/RegExpProfileActionProvider$AddCustomRegExpInspectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

