/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpHighlighter;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpConditional;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpOptions;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpPosixBracketExpression;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.psi.RegExpRecursiveElementVisitor;
import org.intellij.lang.regexp.psi.RegExpSetOptions;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.intellij.lang.regexp.psi.impl.RegExpGroupImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpAnnotator
extends RegExpElementVisitor
implements Annotator {
    @NonNls
    private static final Set<String> POSIX_CHARACTER_CLASSES = ContainerUtil.newHashSet((Object[])new String[]{"alnum", "alpha", "ascii", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "word", "xdigit"});
    private AnnotationHolder myHolder;
    private final RegExpLanguageHosts myLanguageHosts;
    private final Key<Map<String, RegExpGroup>> NAMED_GROUP_MAP = new Key("REG_EXP_NAMED_GROUP_MAP");

    public RegExpAnnotator() {
        this.myLanguageHosts = RegExpLanguageHosts.getInstance();
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            RegExpAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RegExpAnnotator.$$$reportNull$$$0(1);
        }
        assert (this.myHolder == null) : "unsupported concurrent annotator invocation";
        try {
            this.myHolder = holder;
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitRegExpSetOptions(RegExpSetOptions options) {
        this.checkValidFlag(options.getOnOptions(), false);
        this.checkValidFlag(options.getOffOptions(), true);
    }

    private void checkValidFlag(@Nullable RegExpOptions options, boolean skipMinus) {
        int start2;
        if (options == null) {
            return;
        }
        String text2 = options.getText();
        int length = text2.length();
        for (int i = start2 = skipMinus ? 1 : 0; i < length; ++i) {
            int c = text2.codePointAt(i);
            if (Character.isBmpCodePoint(c) && this.myLanguageHosts.supportsInlineOptionFlag((char)c, options)) continue;
            int offset = options.getTextOffset() + i;
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.inline.option.flag", new Object[0])).range(new TextRange(offset, offset + 1)).create();
        }
    }

    @Override
    public void visitRegExpCharRange(RegExpCharRange range) {
        RegExpChar from = range.getFrom();
        PsiElement hyphen = from.getNextSibling();
        this.myHolder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range(hyphen).textAttributes(RegExpHighlighter.META).create();
        RegExpChar to = range.getTo();
        if (to == null) {
            return;
        }
        int fromCodePoint = from.getValue();
        int toCodePoint = to.getValue();
        if (fromCodePoint == -1 || toCodePoint == -1) {
            return;
        }
        if (toCodePoint < fromCodePoint) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.character.range.to.from", new Object[0])).range((PsiElement)range).create();
        }
    }

    @Override
    public void visitRegExpBoundary(RegExpBoundary boundary) {
        if (!this.myLanguageHosts.supportsBoundary(boundary)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.this.boundary.is.not.supported.in.this.regex.dialect", new Object[0])).create();
        }
    }

    @Override
    public void visitSimpleClass(RegExpSimpleClass simpleClass) {
        if (!this.myLanguageHosts.supportsSimpleClass(simpleClass)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.unsupported.escape.sequence", new Object[0])).create();
        }
    }

    @Override
    public void visitRegExpChar(RegExpChar ch) {
        RegExpChar.Type charType;
        PsiElement child = ch.getFirstChild();
        IElementType type2 = child.getNode().getElementType();
        if (type2 == RegExpTT.CHARACTER) {
            if (ch.getTextLength() > 1) {
                this.myHolder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range((PsiElement)ch).textAttributes(RegExpHighlighter.ESC_CHARACTER).create();
            }
        } else {
            if (type2 == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.unsupported.escape.sequence", new Object[0])).create();
                return;
            }
            if (type2 == RegExpTT.BAD_HEX_VALUE) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.hexadecimal.escape.sequence", new Object[0])).create();
                return;
            }
            if (type2 == RegExpTT.BAD_OCT_VALUE) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.octal.escape.sequence", new Object[0])).create();
                return;
            }
            if (type2 == StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.unicode.escape.sequence", new Object[0])).create();
                return;
            }
        }
        String text2 = ch.getUnescapedText();
        if (type2 == RegExpTT.ESC_CTRL_CHARACTER && text2.equals("\\b") && !this.myLanguageHosts.supportsLiteralBackspace(ch)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.unsupported.escape.sequence", new Object[0])).create();
        }
        if ((charType = ch.getType()) == RegExpChar.Type.HEX || charType == RegExpChar.Type.UNICODE) {
            if (ch.getValue() == -1) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.unicode.escape.sequence", new Object[0])).create();
                return;
            }
            if (text2.charAt(text2.length() - 1) == '}' && !this.myLanguageHosts.supportsExtendedHexCharacter(ch)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.this.hex.character.syntax.is.not.supported.in.this.regex.dialect", new Object[0])).create();
            }
        }
    }

    @Override
    public void visitRegExpProperty(RegExpProperty property) {
        ASTNode category = property.getCategoryNode();
        if (category == null) {
            return;
        }
        if (!this.myLanguageHosts.supportsPropertySyntax(property)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.property.escape.sequences.are.not.supported.in.this.regex.dialect", new Object[0])).create();
            return;
        }
        String propertyName = category.getText();
        ASTNode next = category.getTreeNext();
        if (next == null || next.getElementType() != RegExpTT.EQ) {
            if (!this.myLanguageHosts.isValidCategory(category.getPsi(), propertyName)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.character.category", new Object[0])).range(category).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        } else {
            if (!this.myLanguageHosts.isValidPropertyName(category.getPsi(), propertyName)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.property.name", new Object[0])).range(category).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
                return;
            }
            ASTNode valueNode = property.getValueNode();
            if (valueNode != null && !this.myLanguageHosts.isValidPropertyValue(category.getPsi(), propertyName, valueNode.getText())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.property.value", new Object[0])).range(valueNode).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        }
    }

    @Override
    public void visitRegExpNamedCharacter(RegExpNamedCharacter namedCharacter) {
        ASTNode node;
        if (!this.myLanguageHosts.supportsNamedCharacters(namedCharacter)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.named.unicode.characters.are.not.allowed.in.this.regex.dialect", new Object[0])).create();
        } else if (!this.myLanguageHosts.isValidNamedCharacter(namedCharacter) && (node = namedCharacter.getNameNode()) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.character.name", new Object[0])).range(node).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
        }
    }

    @Override
    public void visitRegExpBackref(RegExpBackref backref) {
        RegExpGroup group = backref.resolve();
        if (group == null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unresolved.back.reference", new Object[0])).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
        } else if (PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)backref, (boolean)true)) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, RegExpBundle.message("error.back.reference.is.nested.into.the.capturing.group.it.refers.to", new Object[0])).create();
        }
    }

    @Override
    public void visitRegExpGroup(RegExpGroup group) {
        RegExpGroup.Type groupType;
        ASTNode node;
        AnnotationSession session;
        Map namedGroups;
        ASTNode node2;
        String name;
        RegExpGroup.Type type2;
        RegExpAtom[] atoms;
        if (RegExpGroupImpl.isPcreConditionalGroup(group.getNode())) {
            RegExpBranch[] branches;
            RegExpConditional conditional;
            if (RegExpGroupImpl.isPcreDefine(group.getNode()) && (conditional = (RegExpConditional)ObjectUtils.tryCast((Object)group.getParent(), RegExpConditional.class)) != null && (branches = (RegExpBranch[])PsiTreeUtil.getChildrenOfType((PsiElement)conditional, RegExpBranch.class)) != null && branches.length > 1) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.define.subpattern.contains.more.than.one.branch", new Object[0])).create();
            }
            return;
        }
        RegExpPattern pattern2 = group.getPattern();
        RegExpBranch[] branches = pattern2.getBranches();
        if (RegExpAnnotator.isEmpty(branches) && group.getNode().getLastChildNode().getElementType() == RegExpTT.GROUP_END) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, RegExpBundle.message("error.empty.group", new Object[0])).create();
        } else if (branches.length == 1 && (atoms = branches[0].getAtoms()).length == 1 && atoms[0] instanceof RegExpGroup && ((type2 = group.getType()) == RegExpGroup.Type.CAPTURING_GROUP || type2 == RegExpGroup.Type.ATOMIC || type2 == RegExpGroup.Type.NON_CAPTURING)) {
            RegExpGroup innerGroup = (RegExpGroup)atoms[0];
            if (group.isCapturing() == innerGroup.isCapturing()) {
                this.myHolder.newAnnotation(HighlightSeverity.WARNING, RegExpBundle.message("error.redundant.group.nesting", new Object[0])).create();
            }
        }
        if (group.isAnyNamedGroup() && !this.myLanguageHosts.supportsNamedGroupSyntax(group)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.this.named.group.syntax.is.not.supported.in.this.regex.dialect", new Object[0])).create();
        }
        if (group.getType() == RegExpGroup.Type.ATOMIC && !this.myLanguageHosts.supportsPossessiveQuantifiers(group)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.atomic.groups.are.not.supported.in.this.regex.dialect", new Object[0])).create();
        }
        if ((name = group.getName()) != null && !this.myLanguageHosts.isValidGroupName(name, group) && (node2 = group.getNode().findChildByType(RegExpTT.NAME)) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.invalid.group.name", new Object[0])).range(node2).create();
        }
        if ((namedGroups = (Map)this.NAMED_GROUP_MAP.get((UserDataHolder)(session = this.myHolder.getCurrentAnnotationSession()), new HashMap())).isEmpty()) {
            session.putUserData(this.NAMED_GROUP_MAP, (Object)namedGroups);
        }
        if (namedGroups.put(name, group) != null && !this.myLanguageHosts.isDuplicateGroupNamesAllowed(group) && (node = group.getNode().findChildByType(RegExpTT.NAME)) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.group.with.name.0.already.defined", name)).range(node).create();
        }
        if ((groupType = group.getType()) == RegExpGroup.Type.POSITIVE_LOOKBEHIND || groupType == RegExpGroup.Type.NEGATIVE_LOOKBEHIND) {
            RegExpLanguageHost.Lookbehind support = this.myLanguageHosts.supportsLookbehind(group);
            if (support == RegExpLanguageHost.Lookbehind.NOT_SUPPORTED) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.look.behind.groups.are.not.supported.in.this.regex.dialect", new Object[0])).create();
            } else {
                group.accept(new LookbehindVisitor(support, this.myHolder));
            }
        }
    }

    @Override
    public void visitRegExpNamedGroupRef(RegExpNamedGroupRef groupRef) {
        if (!(groupRef.getParent() instanceof RegExpConditional) && !this.myLanguageHosts.supportsNamedGroupRefSyntax(groupRef)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.this.named.group.reference.syntax.is.not.supported.in.this.regex.dialect", new Object[0])).create();
            return;
        }
        if (groupRef.getGroupName() == null) {
            return;
        }
        RegExpGroup group = groupRef.resolve();
        if (group == null) {
            ASTNode node = groupRef.getNode().findChildByType(RegExpTT.NAME);
            if (node != null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unresolved.named.group.reference", new Object[0])).range(node).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        } else if (PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)groupRef, (boolean)true)) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, RegExpBundle.message("error.group.reference.is.nested.into.the.named.group.it.refers.to", new Object[0])).create();
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            RegExpAnnotator.$$$reportNull$$$0(2);
        }
        if (comment.getText().startsWith("(?#") && !this.myLanguageHosts.supportsPerl5EmbeddedComments(comment)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.embedded.comments.are.not.supported.in.this.regex.dialect", new Object[0])).create();
        }
    }

    @Override
    public void visitRegExpConditional(RegExpConditional conditional) {
        RegExpAtom condition;
        if (!this.myLanguageHosts.supportsConditionals(conditional)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.conditionals.are.not.supported.in.this.regex.dialect", new Object[0])).create();
        }
        if (!this.myLanguageHosts.supportConditionalCondition(condition = conditional.getCondition())) {
            ASTNode child;
            IElementType type2;
            if (condition instanceof RegExpGroup) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.lookaround.conditions.in.conditionals.not.supported.in.this.regex.dialect", new Object[0])).range((PsiElement)condition).create();
            } else if (condition != null && ((type2 = (child = condition.getNode().getFirstChildNode()).getElementType()) == RegExpTT.QUOTED_CONDITION_BEGIN || type2 == RegExpTT.GROUP_BEGIN || type2 == RegExpTT.ANGLE_BRACKET_CONDITION_BEGIN)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.this.kind.group.reference.condition.not.supported.in.this.regex.dialect", new Object[0])).range((PsiElement)condition).create();
            }
        }
    }

    private static boolean isEmpty(RegExpBranch[] branches) {
        return !ContainerUtil.exists((Object[])branches, branch -> branch.getAtoms().length > 0);
    }

    @Override
    public void visitRegExpClosure(RegExpClosure closure) {
        if (closure.getAtom() instanceof RegExpSetOptions) {
            RegExpQuantifier quantifier = closure.getQuantifier();
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.dangling.metacharacter", quantifier.getUnescapedText())).range((PsiElement)quantifier).create();
        }
    }

    @Override
    public void visitRegExpQuantifier(RegExpQuantifier quantifier) {
        if (quantifier.isCounted()) {
            RegExpNumber minElement = quantifier.getMin();
            RegExpNumber maxElement = quantifier.getMax();
            Number minValue = null;
            if (minElement != null && (minValue = this.myLanguageHosts.getQuantifierValue(minElement)) == null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.repetition.value.too.large", new Object[0])).range((PsiElement)minElement).create();
            }
            Number maxValue = null;
            if (maxElement != null && minElement != maxElement && (maxValue = this.myLanguageHosts.getQuantifierValue(maxElement)) == null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.repetition.value.too.large", new Object[0])).range((PsiElement)maxElement).create();
            }
            if (minValue != null && maxValue != null && (minValue.longValue() > maxValue.longValue() || minValue.doubleValue() > maxValue.doubleValue())) {
                TextRange range = new TextRange(minElement.getTextOffset(), maxElement.getTextOffset() + maxElement.getTextLength());
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.repetition.range.min.max", new Object[0])).range(range).create();
            }
        }
        if (quantifier.isPossessive() && !this.myLanguageHosts.supportsPossessiveQuantifiers(quantifier)) {
            ASTNode modifier = quantifier.getModifier();
            assert (modifier != null);
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.nested.quantifier.in.regexp", new Object[0])).range(modifier).create();
        }
    }

    @Override
    public void visitPosixBracketExpression(RegExpPosixBracketExpression posixBracketExpression) {
        ASTNode node;
        String className = posixBracketExpression.getClassName();
        if (!(POSIX_CHARACTER_CLASSES.contains(className) || "<".equals(className) || ">".equals(className) || (node = posixBracketExpression.getNode().findChildByType(RegExpTT.NAME)) == null)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.posix.character.class", new Object[0])).range(node).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/regexp/validation/RegExpAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LookbehindVisitor
    extends RegExpRecursiveElementVisitor {
        private final RegExpLanguageHost.Lookbehind mySupport;
        private final AnnotationHolder myHolder;
        private int myLength = 0;
        private boolean myStop = false;

        LookbehindVisitor(RegExpLanguageHost.Lookbehind support, AnnotationHolder holder) {
            this.mySupport = support;
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpElement(RegExpElement element) {
            if (this.myStop) {
                return;
            }
            super.visitRegExpElement(element);
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            super.visitRegExpChar(ch);
            ++this.myLength;
        }

        @Override
        public void visitSimpleClass(RegExpSimpleClass simpleClass) {
            super.visitSimpleClass(simpleClass);
            ++this.myLength;
        }

        @Override
        public void visitRegExpClass(RegExpClass regExpClass) {
            ++this.myLength;
        }

        @Override
        public void visitRegExpProperty(RegExpProperty property) {
            super.visitRegExpProperty(property);
            ++this.myLength;
        }

        @Override
        public void visitRegExpBackref(RegExpBackref backref) {
            super.visitRegExpBackref(backref);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(backref, RegExpBundle.message("error.group.reference.not.allowed.inside.lookbehind", new Object[0]));
            }
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern2) {
            RegExpBranch[] branches;
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FIXED_LENGTH_ALTERNATION) {
                super.visitRegExpPattern(pattern2);
                return;
            }
            int length = this.myLength;
            int branchLength = -1;
            for (RegExpBranch branch : branches = pattern2.getBranches()) {
                this.myLength = 0;
                super.visitRegExpBranch(branch);
                if (branchLength == -1) {
                    branchLength = this.myLength;
                    continue;
                }
                if (branchLength == this.myLength) continue;
                this.stopAndReportError(pattern2, RegExpBundle.message("error.alternation.alternatives.needs.to.have.the.same.length.inside.lookbehind", new Object[0]));
                return;
            }
            this.myLength = length + branchLength;
        }

        @Override
        public void visitRegExpClosure(RegExpClosure closure) {
            if (this.mySupport == RegExpLanguageHost.Lookbehind.FULL) {
                return;
            }
            RegExpQuantifier quantifier = closure.getQuantifier();
            if (quantifier.isCounted()) {
                if (this.mySupport == RegExpLanguageHost.Lookbehind.FIXED_LENGTH_ALTERNATION || this.mySupport == RegExpLanguageHost.Lookbehind.VARIABLE_LENGTH_ALTERNATION) {
                    RegExpNumber minElement = quantifier.getMin();
                    RegExpNumber maxElement = quantifier.getMax();
                    if (minElement != null && maxElement != null) {
                        Number min = minElement.getValue();
                        if (min == null) {
                            this.myStop = true;
                            return;
                        }
                        Number max = maxElement.getValue();
                        if (min.equals(max)) {
                            int length = this.myLength;
                            this.myLength = 0;
                            RegExpAtom atom = closure.getAtom();
                            atom.accept(this);
                            int atomLength = this.myLength;
                            this.myLength = length + atomLength * min.intValue();
                            return;
                        }
                    }
                    this.stopAndReportError(quantifier, RegExpBundle.message("error.unequal.min.and.max.in.counted.quantifier.not.allowed.inside.lookbehind", new Object[0]));
                }
            } else {
                ASTNode token = quantifier.getToken();
                assert (token != null);
                if (token.getElementType().equals(RegExpTT.QUEST) && this.mySupport == RegExpLanguageHost.Lookbehind.FINITE_REPETITION) {
                    return;
                }
                this.stopAndReportError(quantifier, RegExpBundle.message("error.0.repetition.not.allowed.inside.lookbehind", quantifier.getText()));
            }
        }

        @Override
        public void visitRegExpNamedGroupRef(RegExpNamedGroupRef groupRef) {
            super.visitRegExpNamedGroupRef(groupRef);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(groupRef, RegExpBundle.message("error.named.group.reference.not.allowed.inside.lookbehind", new Object[0]));
            }
        }

        @Override
        public void visitRegExpConditional(RegExpConditional conditional) {
            super.visitRegExpConditional(conditional);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(conditional, RegExpBundle.message("error.conditional.group.reference.not.allowed.inside.lookbehind", new Object[0]));
            }
        }

        @Override
        public void visitPosixBracketExpression(RegExpPosixBracketExpression posixBracketExpression) {
            super.visitPosixBracketExpression(posixBracketExpression);
            ++this.myLength;
        }

        public void stopAndReportError(RegExpElement element, @NotNull @Nls String message2) {
            if (message2 == null) {
                LookbehindVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, message2).range((PsiElement)element).create();
            this.myStop = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/intellij/lang/regexp/validation/RegExpAnnotator$LookbehindVisitor", "stopAndReportError"));
        }
    }
}

