/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.coverage;

import com.intellij.coverage.filters.ModifiedFilesFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRemoteBranch;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/git/coverage/GitModifiedFilesFilter;", "Lcom/intellij/coverage/filters/ModifiedFilesFilter;", "project", "Lcom/intellij/openapi/project/Project;", "modifiedScope", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "branch", "Lgit4idea/GitRemoteBranch;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Lgit4idea/GitRemoteBranch;)V", "getModifiedScope", "()Ljava/util/Set;", "getBranchName", "", "isInModifiedScope", "", "file", "intellij.vcs.git.coverage"})
final class GitModifiedFilesFilter
extends ModifiedFilesFilter {
    @NotNull
    private final Set<VirtualFile> modifiedScope;
    @NotNull
    private final GitRemoteBranch branch;

    public GitModifiedFilesFilter(@NotNull Project project, @NotNull Set<? extends VirtualFile> modifiedScope, @NotNull GitRemoteBranch branch) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modifiedScope, (String)"modifiedScope");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        super(project);
        this.modifiedScope = modifiedScope;
        this.branch = branch;
    }

    @NotNull
    public final Set<VirtualFile> getModifiedScope() {
        return this.modifiedScope;
    }

    public boolean isInModifiedScope(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.modifiedScope.contains(file2);
    }

    @NotNull
    public String getBranchName() {
        String string = this.branch.getNameForLocalOperations();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameForLocalOperations(...)");
        return string;
    }
}

