/*
 * Decompiled with CFR 0.152.
 */
package git4idea.diff;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitRevisionContentPreLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitDiffProvider
implements DiffProvider,
DiffMixin {
    private final Project myProject;

    public GitDiffProvider(@NotNull Project project) {
        if (project == null) {
            GitDiffProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        try {
            return GitHistoryUtils.getCurrentRevision(this.myProject, VcsUtil.getFilePath((VirtualFile)file2), "HEAD");
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public VcsRevisionDescription getCurrentRevisionDescription(VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        try {
            return GitHistoryUtils.getCurrentRevisionDescription(this.myProject, VcsUtil.getFilePath((VirtualFile)file2));
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public ItemLatestState getLastRevision(VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        if (!this.hasGoodFileStatus(file2)) {
            return null;
        }
        try {
            return GitHistoryUtils.getLastRevision(this.myProject, VcsUtil.getFilePath((VirtualFile)file2));
        }
        catch (VcsException e) {
            return null;
        }
    }

    private boolean hasGoodFileStatus(VirtualFile file2) {
        FileStatus status = ChangeListManager.getInstance((Project)this.myProject).getStatus(file2);
        return status == FileStatus.NOT_CHANGED || status == FileStatus.DELETED || status == FileStatus.MODIFIED || status == FileStatus.MERGED_WITH_CONFLICTS;
    }

    @Nullable
    public ContentRevision createCurrentFileContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GitDiffProvider.$$$reportNull$$$0(1);
        }
        if (file2.isDirectory()) {
            return null;
        }
        if (GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(file2) == null) {
            return null;
        }
        VcsRevisionNumber revisionNumber = this.getCurrentRevision(file2);
        FilePath filePath = VcsUtil.getLastCommitPath((Project)this.myProject, (FilePath)VcsUtil.getFilePath((VirtualFile)file2));
        return GitContentRevision.createRevision(filePath, revisionNumber, this.myProject, file2.getCharset());
    }

    @Nullable
    public ContentRevision createFileContent(VcsRevisionNumber revisionNumber, VirtualFile selectedFile) {
        if (selectedFile.isDirectory()) {
            return null;
        }
        if (GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(selectedFile) == null) {
            return null;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)selectedFile);
        try {
            CommittedChangesProvider committedChangesProvider = GitVcs.getInstance(this.myProject).getCommittedChangesProvider();
            Pair pair = committedChangesProvider.getOneList(selectedFile, revisionNumber);
            if (pair != null) {
                return GitContentRevision.createRevision((FilePath)pair.getSecond(), revisionNumber, this.myProject, selectedFile.getCharset());
            }
        }
        catch (VcsException e) {
            GitVcs.getInstance(this.myProject).showErrors(Collections.singletonList(e), GitBundle.message("diff.find.error", selectedFile.getPresentableUrl()));
        }
        try {
            for (VcsFileRevision f : GitFileHistory.collectHistory(this.myProject, filePath, new String[0])) {
                GitFileRevision gitRevision = (GitFileRevision)f;
                if (!f.getRevisionNumber().equals(revisionNumber)) continue;
                return GitContentRevision.createRevision(gitRevision.getPath(), revisionNumber, this.myProject, selectedFile.getCharset());
            }
            GitContentRevision candidate = (GitContentRevision)GitContentRevision.createRevision(filePath, revisionNumber, this.myProject, selectedFile.getCharset());
            try {
                candidate.getContent();
                return candidate;
            }
            catch (VcsException vcsException) {
            }
        }
        catch (VcsException e) {
            GitVcs.getInstance(this.myProject).showErrors(Collections.singletonList(e), GitBundle.message("diff.find.error", selectedFile.getPresentableUrl()));
        }
        return null;
    }

    public ItemLatestState getLastRevision(FilePath filePath) {
        if (filePath.isDirectory()) {
            return null;
        }
        VirtualFile vf = filePath.getVirtualFile();
        if (vf != null && !this.hasGoodFileStatus(vf)) {
            return null;
        }
        try {
            return GitHistoryUtils.getLastRevision(this.myProject, filePath);
        }
        catch (VcsException e) {
            return null;
        }
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }

    public void preloadBaseRevisions(@NotNull VirtualFile root, @NotNull Collection<Change> revisions) {
        if (root == null) {
            GitDiffProvider.$$$reportNull$$$0(2);
        }
        if (revisions == null) {
            GitDiffProvider.$$$reportNull$$$0(3);
        }
        new GitRevisionContentPreLoader(this.myProject).preload(root, revisions);
    }

    public boolean canCompareWithWorkingDir() {
        return true;
    }

    @NotNull
    public Collection<Change> compareWithWorkingDir(@NotNull VirtualFile fileOrDir, @NotNull VcsRevisionNumber revNum) throws VcsException {
        if (fileOrDir == null) {
            GitDiffProvider.$$$reportNull$$$0(4);
        }
        if (revNum == null) {
            GitDiffProvider.$$$reportNull$$$0(5);
        }
        GitRepository repo2 = GitUtil.getRepositoryForFile(this.myProject, fileOrDir);
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)fileOrDir);
        List changes = GitChangeUtils.getDiffWithWorkingDir(this.myProject, repo2.getRoot(), revNum.asString(), Collections.singletonList(filePath), false);
        List list2 = changes.isEmpty() && !filePath.isDirectory() ? VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)GitContentRevision.createRevision(filePath, revNum, this.myProject)) : changes;
        if (list2 == null) {
            GitDiffProvider.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revNum";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/diff/GitDiffProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/diff/GitDiffProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWithWorkingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCurrentFileContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preloadBaseRevisions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareWithWorkingDir";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

