/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgWorkingCopyRevisionsCommand {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(HgWorkingCopyRevisionsCommand.class);

    public HgWorkingCopyRevisionsCommand(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<HgRevisionNumber> parents(@NotNull VirtualFile repo) {
        if (repo == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(0);
        }
        List<HgRevisionNumber> list = this.getRevisions(repo, "parents", null, null, true);
        if (list == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public Couple<HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable VirtualFile file) {
        if (repo == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(2);
        }
        Couple<HgRevisionNumber> couple = this.parents(repo, file, null);
        if (couple == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(3);
        }
        return couple;
    }

    @NotNull
    public Couple<HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable VirtualFile file, @Nullable HgRevisionNumber revision) {
        if (repo == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(4);
        }
        Couple<HgRevisionNumber> couple = this.parents(repo, VcsUtil.getFilePath((VirtualFile)file), revision);
        if (couple == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(5);
        }
        return couple;
    }

    @NotNull
    public Couple<HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable FilePath file) {
        if (repo == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(6);
        }
        Couple<HgRevisionNumber> couple = this.parents(repo, file, null);
        if (couple == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(7);
        }
        return couple;
    }

    @NotNull
    public Couple<HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable FilePath file, @Nullable HgRevisionNumber revision) {
        if (repo == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(8);
        }
        List<HgRevisionNumber> revisions = this.getRevisions(repo, "parents", file, revision, true);
        Couple couple = switch (revisions.size()) {
            case 1 -> Couple.of((Object)revisions.get(0), null);
            case 2 -> Couple.of((Object)revisions.get(0), (Object)revisions.get(1));
            default -> Couple.of(null, null);
        };
        if (couple == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(9);
        }
        return couple;
    }

    @Nullable
    public HgRevisionNumber firstParent(@NotNull VirtualFile repo) {
        List<HgRevisionNumber> parents;
        if (repo == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(10);
        }
        if ((parents = this.parents(repo)).isEmpty()) {
            return HgRevisionNumber.NULL_REVISION_NUMBER;
        }
        return parents.get(0);
    }

    @Nullable
    public HgRevisionNumber tip(@NotNull VirtualFile repo) {
        List<HgRevisionNumber> tips;
        if (repo == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(11);
        }
        if ((tips = this.getRevisions(repo, "tip", null, null, true)).size() > 1) {
            throw new IllegalStateException("There cannot be multiple tips");
        }
        if (!tips.isEmpty()) {
            return tips.get(0);
        }
        return HgRevisionNumber.NULL_REVISION_NUMBER;
    }

    @NotNull
    public Couple<HgRevisionNumber> identify(@NotNull VirtualFile repo) {
        List parts;
        if (repo == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(12);
        }
        HgCommandExecutor commandExecutor = new HgCommandExecutor(this.myProject);
        commandExecutor.setSilent(true);
        HgCommandResult result = commandExecutor.executeInCurrentThread(repo, "identify", Arrays.asList("--num", "--id"));
        if (result == null) {
            Couple couple = Couple.of((Object)HgRevisionNumber.NULL_REVISION_NUMBER, null);
            if (couple == null) {
                HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(13);
            }
            return couple;
        }
        List<String> lines = result.getOutputLines();
        if (!lines.isEmpty() && (parts = StringUtil.split((String)lines.get(0), (String)" ")).size() >= 2) {
            String changesets = (String)parts.get(0);
            String revisions = (String)parts.get(1);
            if (changesets.indexOf(43) != changesets.lastIndexOf(43)) {
                List chsets = StringUtil.split((String)changesets, (String)"+");
                List revs = StringUtil.split((String)revisions, (String)"+");
                Couple couple = Couple.of((Object)HgRevisionNumber.getInstance((String)revs.get(0) + "+", (String)chsets.get(0) + "+"), (Object)HgRevisionNumber.getInstance((String)revs.get(1) + "+", (String)chsets.get(1) + "+"));
                if (couple == null) {
                    HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(14);
                }
                return couple;
            }
            Couple couple = Couple.of((Object)HgRevisionNumber.getInstance(revisions, changesets), null);
            if (couple == null) {
                HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(15);
            }
            return couple;
        }
        Couple couple = Couple.of((Object)HgRevisionNumber.NULL_REVISION_NUMBER, null);
        if (couple == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(16);
        }
        return couple;
    }

    @NotNull
    public List<HgRevisionNumber> getRevisions(@NotNull VirtualFile repo, @NotNull @NonNls String command, @Nullable FilePath file, @Nullable HgRevisionNumber revision, boolean silent) {
        if (repo == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(17);
        }
        if (command == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(18);
        }
        LinkedList<String> args = new LinkedList<String>();
        args.add("--template");
        args.add(HgChangesetUtil.makeTemplate("{rev}", "{node}"));
        if (revision != null) {
            args.add("-r");
            args.add(revision.getChangeset());
        }
        if (file != null) {
            args.add(HgUtil.getOriginalFileName(file, ChangeListManager.getInstance((Project)this.myProject)).getPath());
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setSilent(silent);
        HgCommandResult result = executor.executeInCurrentThread(repo, command, args);
        if (result == null) {
            return new ArrayList<HgRevisionNumber>(0);
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : result.getRawOutput().split("\u0003")) {
            if (line.trim().isEmpty()) continue;
            lines.add(line);
        }
        if (lines.isEmpty()) {
            return new ArrayList<HgRevisionNumber>();
        }
        ArrayList<HgRevisionNumber> revisions = new ArrayList<HgRevisionNumber>(lines.size());
        for (String line : lines) {
            List parts = StringUtil.split((String)line, (String)"\u0017");
            if (parts.size() < 2) {
                LOG.error("getRevisions output parse error in line [" + line + "]\n All lines: \n" + lines);
                continue;
            }
            revisions.add(HgRevisionNumber.getInstance((String)parts.get(0), (String)parts.get(1)));
        }
        ArrayList<HgRevisionNumber> arrayList = revisions;
        if (arrayList == null) {
            HgWorkingCopyRevisionsCommand.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7, 9, 13, 14, 15, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parents";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "identify";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parents";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "firstParent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tip";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "identify";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRevisions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7, 9, 13, 14, 15, 16, 19 -> new IllegalStateException(string);
        };
    }
}

