/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageViewTypeLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.references.MavenPsiElementWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;

public final class MavenModelDocumentationProvider
implements DocumentationProvider,
ElementDescriptionProvider {
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return MavenModelDocumentationProvider.getDoc(element, false);
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        if ((element = MavenModelDocumentationProvider.getMavenElement(element)) == null) {
            return null;
        }
        if (MavenDomUtil.isMavenProperty(element)) {
            return Collections.emptyList();
        }
        return Collections.singletonList("http://maven.apache.org/ref/2.2.1/maven-model/maven.html");
    }

    @Nls
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        return MavenModelDocumentationProvider.getDoc(element, true);
    }

    @Nullable
    @Nls
    private static String getDoc(PsiElement element, boolean html) {
        return MavenModelDocumentationProvider.getMavenElementDescription(element, DescKind.TYPE_NAME_VALUE, html);
    }

    @Nls
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            MavenModelDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (location == null) {
            MavenModelDocumentationProvider.$$$reportNull$$$0(1);
        }
        return MavenModelDocumentationProvider.getMavenElementDescription(element, location instanceof UsageViewTypeLocation ? DescKind.TYPE : DescKind.NAME, false);
    }

    @Nullable
    @NlsContexts.DetailedDescription
    private static String getMavenElementDescription(PsiElement e, DescKind kind, boolean html) {
        String type2;
        if ((e = MavenModelDocumentationProvider.getMavenElement(e)) == null) {
            return null;
        }
        if (e instanceof FakePsiElement) {
            return ((FakePsiElement)e).getPresentableText();
        }
        boolean property = MavenDomUtil.isMavenProperty(e);
        String string = type2 = property ? MavenDomBundle.message("text.property", new Object[0]) : MavenDomBundle.message("text.model.property", new Object[0]);
        if (kind == DescKind.TYPE) {
            return type2;
        }
        String name = MavenModelDocumentationProvider.buildPropertyName(e, property);
        if (kind == DescKind.NAME) {
            return name;
        }
        if (kind == DescKind.TYPE_NAME_VALUE) {
            String[] stringArray;
            String br;
            String string2 = br = html ? "<br>" : "\n ";
            if (html) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "<b>";
                stringArray = stringArray2;
                stringArray2[1] = "</b>";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "";
                stringArray = stringArray3;
                stringArray3[1] = "";
            }
            String[] bold = stringArray;
            Object valueSuffix = "";
            if (e instanceof XmlTag) {
                valueSuffix = ": " + bold[0] + ((XmlTag)e).getValue().getTrimmedText() + bold[1];
            }
            return type2 + br + name + (String)valueSuffix;
        }
        MavenLog.LOG.error("unexpected desc kind: " + kind);
        return null;
    }

    @NlsContexts.DetailedDescription
    private static String buildPropertyName(PsiElement e, boolean property) {
        if (property) {
            return DescriptiveNameUtil.getDescriptiveName((PsiElement)e);
        }
        ArrayList<String> path2 = new ArrayList<String>();
        do {
            path2.add(DescriptiveNameUtil.getDescriptiveName((PsiElement)e));
        } while ((e = PsiTreeUtil.getParentOfType((PsiElement)e, XmlTag.class)) != null);
        Collections.reverse(path2);
        return StringUtil.join(path2, (String)".");
    }

    private static PsiElement getMavenElement(PsiElement e) {
        if (e instanceof MavenPsiElementWrapper) {
            e = ((MavenPsiElementWrapper)e).getWrappee();
        }
        if (!MavenDomUtil.isMavenFile(e)) {
            return null;
        }
        if (e instanceof PsiFile) {
            return null;
        }
        return e;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/dom/MavenModelDocumentationProvider";
        objectArray[2] = "getElementDescription";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum DescKind {
        TYPE,
        NAME,
        TYPE_NAME_VALUE;

    }
}

