/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings.introduce;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.StringLenComparator;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.utils.ComboBoxUtil;

public class IntroducePropertyDialog
extends DialogWrapper {
    private final Project myProject;
    private final XmlElement myContext;
    private final MavenDomProjectModel myMavenDomProjectModel;
    private final String mySelectedString;
    private NameSuggestionsField myNameField;
    private NameSuggestionsField.DataChanged myNameChangedListener;
    private JComboBox myMavenProjectsComboBox;
    private JPanel myMainPanel;
    private JPanel myFieldNamePanel;

    public IntroducePropertyDialog(@NotNull Project project2, @NotNull XmlElement context2, @NotNull MavenDomProjectModel mavenDomProjectModel, @NotNull String selectedString) {
        if (project2 == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(1);
        }
        if (mavenDomProjectModel == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(2);
        }
        if (selectedString == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(3);
        }
        super(project2, true);
        this.myProject = project2;
        this.myContext = context2;
        this.myMavenDomProjectModel = mavenDomProjectModel;
        this.mySelectedString = selectedString;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(MavenDomBundle.message("refactoring.introduce.property", objectArray));
        this.init();
    }

    protected void dispose() {
        this.myNameField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    protected void init() {
        super.init();
        this.updateOkStatus();
    }

    public String getEnteredName() {
        return this.myNameField.getEnteredName().trim();
    }

    @NotNull
    public MavenDomProjectModel getSelectedProject() {
        MavenDomProjectModel selectedItem = (MavenDomProjectModel)ComboBoxUtil.getSelectedValue((DefaultComboBoxModel)this.myMavenProjectsComboBox.getModel());
        MavenDomProjectModel mavenDomProjectModel = selectedItem == null ? this.myMavenDomProjectModel : selectedItem;
        if (mavenDomProjectModel == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(5);
        }
        return mavenDomProjectModel;
    }

    private String[] getSuggestions() {
        return this.getSuggestions(1);
    }

    private String[] getSuggestions(int level) {
        String newValue;
        AbstractCollection result2 = new HashSet<String>();
        String value = this.mySelectedString.trim();
        boolean addUnqualifiedForm = true;
        XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, XmlTag.class, (boolean)false);
        DomElement domParent = DomUtil.getDomElement((PsiElement)parent);
        if (domParent != null) {
            DomElement domSuperParent = domParent.getParent();
            DomFileElement domFile = DomUtil.getFileElement((DomElement)domParent);
            if (domSuperParent != null && domFile != null && domFile.getRootElement() == domSuperParent) {
                value = domSuperParent.getXmlElementName();
                addUnqualifiedForm = false;
            } else {
                String artifactId;
                MavenDomShortArtifactCoordinates coordinates = (MavenDomShortArtifactCoordinates)DomUtil.getParentOfType((DomElement)domParent, MavenDomShortArtifactCoordinates.class, (boolean)false);
                if (coordinates != null && !(coordinates instanceof MavenDomProjectModel) && domParent != coordinates.getArtifactId() && !StringUtil.isEmptyOrSpaces((String)(artifactId = coordinates.getArtifactId().getStringValue()))) {
                    value = artifactId;
                    addUnqualifiedForm = false;
                }
            }
        }
        while (!(newValue = value.replaceAll("  ", " ")).equals(value)) {
            value = newValue;
        }
        value = value.replaceAll(" ", ".");
        List parts = StringUtil.split((String)value, (String)".");
        String shortValue = (String)parts.get(parts.size() - 1);
        if (addUnqualifiedForm) {
            result2.add(value);
            result2.add(shortValue);
        }
        Object suffix = "";
        while (parent != null && level != 0) {
            suffix = parent.getName() + (String)suffix;
            result2.add(suffix);
            result2.add(value + "." + (String)suffix);
            result2.add(shortValue + "." + (String)suffix);
            suffix = "." + (String)suffix;
            parent = parent.getParentTag();
            --level;
        }
        result2 = new ArrayList(result2);
        ((List)((Object)result2)).sort(((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class)).PREFER_LONGER_NAMES ? StringLenComparator.getDescendingInstance() : StringLenComparator.getInstance());
        return ArrayUtilRt.toStringArray((Collection)result2);
    }

    private static String joinWords(@NotNull String s, @NotNull String delimiter) {
        if (s == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(6);
        }
        if (delimiter == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(7);
        }
        return IntroducePropertyDialog.joinWords(StringUtil.split((String)s, (String)delimiter));
    }

    private static String joinWords(@NotNull List<String> stringList) {
        if (stringList == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(8);
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < stringList.size(); ++i2) {
            String word = stringList.get(i2);
            if (StringUtil.isEmptyOrSpaces((String)word)) continue;
            sb.append(i2 == 0 ? StringUtil.decapitalize((String)word.trim()) : StringUtil.capitalize((String)word.trim()));
        }
        return sb.toString();
    }

    protected JComponent createCenterPanel() {
        this.myFieldNamePanel.setLayout(new BorderLayout());
        this.myNameField = new NameSuggestionsField(this.myProject);
        this.myNameChangedListener = () -> this.updateOkStatus();
        this.myNameField.addDataChangedListener(this.myNameChangedListener);
        this.myNameField.setSuggestions(this.getSuggestions());
        this.myFieldNamePanel.add((Component)this.myNameField, "Center");
        List<MavenDomProjectModel> projects2 = this.getProjects();
        ComboBoxUtil.setModel(this.myMavenProjectsComboBox, new DefaultComboBoxModel(), projects2, model -> Pair.create((Object)MavenDomUtil.getProjectName(model), (Object)model));
        this.myMavenProjectsComboBox.setSelectedItem(this.myMavenDomProjectModel);
        return this.myMainPanel;
    }

    private List<MavenDomProjectModel> getProjects() {
        ArrayList<MavenDomProjectModel> projects2 = new ArrayList<MavenDomProjectModel>();
        projects2.add(this.myMavenDomProjectModel);
        projects2.addAll(MavenDomProjectProcessorUtils.collectParentProjects(this.myMavenDomProjectModel));
        return projects2;
    }

    private void updateOkStatus() {
        String text2 = this.getEnteredName();
        this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)text2) && !IntroducePropertyDialog.isContainWrongSymbols(text2) && !this.isPropertyExist(text2));
    }

    private static boolean isContainWrongSymbols(@NotNull String text2) {
        if (text2 == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(9);
        }
        return text2.length() == 0 || Character.isDigit(text2.charAt(0)) || StringUtil.containsAnyChar((String)text2, (String)"\t ;*'\"\\/,()^&<>={}[]");
    }

    private boolean isPropertyExist(@NotNull String text2) {
        MavenDomProjectModel project2;
        if (text2 == null) {
            IntroducePropertyDialog.$$$reportNull$$$0(10);
        }
        if (IntroducePropertyDialog.isPropertyExist(text2, project2 = this.getSelectedProject())) {
            return true;
        }
        for (MavenDomProjectModel child : MavenDomProjectProcessorUtils.getChildrenProjects(project2)) {
            if (!IntroducePropertyDialog.isPropertyExist(text2, child)) continue;
            return true;
        }
        for (MavenDomProjectModel parent : MavenDomProjectProcessorUtils.collectParentProjects(project2)) {
            if (!IntroducePropertyDialog.isPropertyExist(text2, parent)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPropertyExist(String propertyName, MavenDomProjectModel project2) {
        MavenDomProperties props = project2.getProperties();
        XmlTag propsTag = props.getXmlTag();
        if (propsTag != null) {
            for (XmlTag each : propsTag.getSubTags()) {
                if (!propertyName.equals(each.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/MavenDomBundle", IntroducePropertyDialog.class).getString("property.introduce.project"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/MavenDomBundle", IntroducePropertyDialog.class).getString("property.introduce.name"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFieldNamePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMavenProjectsComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDomProjectModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedString";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringList";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "joinWords";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isContainWrongSymbols";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyExist";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

