/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public abstract class MavenPsiReference
implements PsiReference {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final MavenProjectsManager myProjectsManager;
    @NotNull
    protected final PsiFile myPsiFile;
    @NotNull
    protected final VirtualFile myVirtualFile;
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final String myText;
    @NotNull
    protected TextRange myRange;

    public MavenPsiReference(@NotNull PsiElement element, @NotNull String text2, @NotNull TextRange range) {
        if (element == null) {
            MavenPsiReference.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            MavenPsiReference.$$$reportNull$$$0(1);
        }
        if (range == null) {
            MavenPsiReference.$$$reportNull$$$0(2);
        }
        this.myProject = element.getProject();
        this.myProjectsManager = MavenProjectsManager.getInstance(this.myProject);
        this.myPsiFile = element.getContainingFile().getOriginalFile();
        this.myVirtualFile = this.myPsiFile.getVirtualFile();
        this.myElement = element;
        this.myText = text2;
        this.myRange = range;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            MavenPsiReference.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myText;
        if (string == null) {
            MavenPsiReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            MavenPsiReference.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            MavenPsiReference.$$$reportNull$$$0(6);
        }
        return this.getElement().getManager().areElementsEquivalent(element, this.resolve());
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            MavenPsiReference.$$$reportNull$$$0(7);
        }
        ElementManipulator manipulator = CachingReference.getManipulator((PsiElement)this.getElement());
        TextRange rangeInElement = this.getRangeInElement();
        PsiElement element = manipulator.handleContentChange(this.getElement(), rangeInElement, newElementName);
        this.myRange = new TextRange(rangeInElement.getStartOffset(), rangeInElement.getStartOffset() + newElementName.length());
        return element;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            MavenPsiReference.$$$reportNull$$$0(8);
        }
        return null;
    }

    public boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenPsiReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenPsiReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

