/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.Navigatable;
import icons.MavenIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.RepositoriesNode;

class RepositoryNode
extends MavenSimpleNode {
    @NlsSafe
    private final String myId;
    @NlsSafe
    private final String myUrl;
    private final boolean myLocal;

    RepositoryNode(MavenProjectsStructure structure, RepositoriesNode parent, String id, String url, boolean local) {
        super(structure, parent);
        this.myId = id;
        this.myUrl = url;
        this.myLocal = local;
        PresentationData presentation = this.getTemplatePresentation();
        presentation.setIcon(this.getDefaultIcon());
        this.setNameAndTooltip(presentation, this.myId, null, this.myLocal ? UiUtils.getPresentablePath((String)this.myUrl) : this.myUrl);
    }

    @NotNull
    private Icon getDefaultIcon() {
        Icon icon = this.myLocal ? MavenIcons.MavenRepoLocal : MavenIcons.MavenRepoRemote;
        if (icon == null) {
            RepositoryNode.$$$reportNull$$$0(0);
        }
        return icon;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            RepositoryNode.$$$reportNull$$$0(1);
        }
        this.setNameAndTooltip(presentation, this.myId, null, this.myLocal ? UiUtils.getPresentablePath((String)this.myUrl) : this.myUrl);
    }

    public String getName() {
        return this.myId;
    }

    @Override
    @NonNls
    protected String getMenuId() {
        return "Maven.RepositoryMenu";
    }

    String getId() {
        return this.myId;
    }

    String getUrl() {
        return this.myUrl;
    }

    boolean isLocal() {
        return this.myLocal;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/navigator/structure/RepositoryNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/navigator/structure/RepositoryNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

