/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.actions.MavenProjectsAction;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/project/actions/ReimportProjectAction;", "Lorg/jetbrains/idea/maven/project/actions/MavenProjectsAction;", "()V", "isVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "manager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "mavenProjects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "intellij.maven"})
public class ReimportProjectAction
extends MavenProjectsAction {
    @Override
    public boolean isVisible(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!super.isVisible(e)) {
            return false;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext context2 = dataContext;
        Project project2 = MavenActionUtil.getProject(context2);
        if (project2 == null) {
            return false;
        }
        List<VirtualFile> selectedFiles = MavenActionUtil.getMavenProjectsFiles(context2);
        if (selectedFiles.size() == 0) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        Iterator<VirtualFile> iterator = selectedFiles.iterator();
        while (iterator.hasNext()) {
            VirtualFile pomXml;
            VirtualFile virtualFile = pomXml = iterator.next();
            Intrinsics.checkNotNull((Object)virtualFile);
            MavenProject mavenProject2 = projectsManager.findProject(virtualFile);
            if (mavenProject2 == null) {
                return false;
            }
            if (!projectsManager.isIgnored(mavenProject2)) continue;
            return false;
        }
        return true;
    }

    protected void perform(@NotNull MavenProjectsManager manager, @NotNull List<? extends MavenProject> mavenProjects2, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(mavenProjects2, (String)"mavenProjects");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (MavenUtil.isProjectTrustedEnoughToImport(manager.getProject())) {
            FileDocumentManager.getInstance().saveAllDocuments();
            manager.scheduleForceUpdateMavenProjects(mavenProjects2);
        }
    }
}

