/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.marketplaceMl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.marketplace.ranking.MarketplaceLocalRanker;
import com.intellij.ide.plugins.marketplace.statistics.features.PluginManagerMarketplaceSearchFeatureProvider;
import com.intellij.ide.plugins.marketplace.statistics.features.PluginManagerSearchResultFeatureProvider;
import com.intellij.ide.plugins.marketplace.statistics.features.PluginManagerSearchResultsFeatureProvider;
import com.intellij.ide.plugins.marketplace.statistics.features.PluginManagerUserQueryFeatureProvider;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.marketplaceMl.MarketplaceLocalRankingService;
import com.intellij.marketplaceMl.MarketplaceMLExperiment;
import com.intellij.marketplaceMl.model.MarketplaceRankingModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/marketplaceMl/MarketplaceLocalRankingService;", "Lcom/intellij/ide/plugins/marketplace/ranking/MarketplaceLocalRanker;", "()V", "experimentGroup", "", "getExperimentGroup", "()I", "experimentVersion", "getExperimentVersion", "model", "Lcom/intellij/marketplaceMl/model/MarketplaceRankingModel;", "getModel", "()Lcom/intellij/marketplaceMl/model/MarketplaceRankingModel;", "modelCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "isEnabled", "", "rankPlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "", "queryParser", "Lcom/intellij/ide/plugins/newui/SearchQueryParser$Marketplace;", "plugins", "", "Companion", "intellij.marketplaceMl"})
@SourceDebugExtension(value={"SMAP\nMarketplaceLocalRankingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketplaceLocalRankingService.kt\ncom/intellij/marketplaceMl/MarketplaceLocalRankingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1549#2:64\n1620#2,3:65\n1179#2,2:68\n1253#2,4:70\n1011#2,2:74\n*S KotlinDebug\n*F\n+ 1 MarketplaceLocalRankingService.kt\ncom/intellij/marketplaceMl/MarketplaceLocalRankingService\n*L\n39#1:64\n39#1:65,3\n44#1:68,2\n44#1:70,4\n50#1:74,2\n*E\n"})
public final class MarketplaceLocalRankingService
implements MarketplaceLocalRanker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<Unit, MarketplaceRankingModel> modelCache;

    public MarketplaceLocalRankingService() {
        Caffeine caffeine = Caffeine.newBuilder();
        long l = DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.SECONDS);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        Cache cache = caffeine.expireAfterAccess(duration).maximumSize(1L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.modelCache = cache;
    }

    @NotNull
    public final MarketplaceRankingModel getModel() {
        Object object = this.modelCache.get((Object)Unit.INSTANCE, arg_0 -> MarketplaceLocalRankingService._get_model_$lambda$0(model.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (MarketplaceRankingModel)object;
    }

    public boolean isEnabled() {
        return MarketplaceMLExperiment.INSTANCE.getExperiment() == MarketplaceMLExperiment.ExperimentOption.USE_ML;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<IdeaPluginDescriptor, Double> rankPlugins(@NotNull SearchQueryParser.Marketplace queryParser, @NotNull List<IdeaPluginDescriptor> plugins) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)queryParser, (String)"queryParser");
        Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
        Map pluginToScore = new LinkedHashMap();
        String searchQuery = queryParser.searchQuery;
        List queryFeatures = PluginManagerUserQueryFeatureProvider.INSTANCE.getSearchStateFeatures(searchQuery);
        List marketplaceFeatures = PluginManagerMarketplaceSearchFeatureProvider.INSTANCE.getSearchStateFeatures(queryParser);
        ArrayList commonResultFeatures = PluginManagerSearchResultsFeatureProvider.INSTANCE.getCommonFeatures(searchQuery, plugins);
        Object $this$map$iv = plugins;
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PluginManagerSearchResultFeatureProvider.getSearchStateFeatures$default((PluginManagerSearchResultFeatureProvider)PluginManagerSearchResultFeatureProvider.INSTANCE, (String)searchQuery, (IdeaPluginDescriptor)it, null, (int)4, null));
        }
        List allItemFeatures = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.zip((Iterable)plugins, (Iterable)allItemFeatures).iterator();
        $i$f$map = 0;
        while ($this$map$iv.hasNext()) {
            void $this$associateTo$iv$iv;
            int index = $i$f$map++;
            Pair pluginWithFeatures = (Pair)$this$map$iv.next();
            IdeaPluginDescriptor plugin = (IdeaPluginDescriptor)pluginWithFeatures.component1();
            List itemFeatures = (List)pluginWithFeatures.component2();
            List allFeatures = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)queryFeatures, (Iterable)marketplaceFeatures), (Iterable)commonResultFeatures), (Iterable)itemFeatures);
            Iterable $this$associate$iv = allFeatures;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable2 = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                EventPair it = (EventPair)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getField().getName(), (Object)it.getData());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map featuresMap = destination$iv$iv2;
            pluginToScore.put(plugin, (double)(plugins.size() - index) / (double)plugins.size());
        }
        List<IdeaPluginDescriptor> $this$sortByDescending$iv = plugins;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortByDescending$iv, (Comparator)new Comparator(pluginToScore){
                final /* synthetic */ Map $pluginToScore$inlined;
                {
                    this.$pluginToScore$inlined = map;
                }

                public final int compare(T a, T b) {
                    IdeaPluginDescriptor it = (IdeaPluginDescriptor)b;
                    boolean bl = false;
                    Comparable comparable = (Double)this.$pluginToScore$inlined.get(it);
                    it = (IdeaPluginDescriptor)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)this.$pluginToScore$inlined.get(it)));
                }
            });
        }
        return pluginToScore;
    }

    public int getExperimentGroup() {
        return MarketplaceMLExperiment.INSTANCE.getExperimentGroup();
    }

    public int getExperimentVersion() {
        return 0;
    }

    private static final MarketplaceRankingModel _get_model_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MarketplaceRankingModel)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/marketplaceMl/MarketplaceLocalRankingService$Companion;", "", "()V", "getInstance", "Lcom/intellij/marketplaceMl/MarketplaceLocalRankingService;", "intellij.marketplaceMl"})
    @SourceDebugExtension(value={"SMAP\nMarketplaceLocalRankingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketplaceLocalRankingService.kt\ncom/intellij/marketplaceMl/MarketplaceLocalRankingService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,63:1\n40#2,3:64\n*S KotlinDebug\n*F\n+ 1 MarketplaceLocalRankingService.kt\ncom/intellij/marketplaceMl/MarketplaceLocalRankingService$Companion\n*L\n61#1:64,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarketplaceLocalRankingService getInstance() {
            boolean $i$f$service = false;
            Class<MarketplaceLocalRankingService> serviceClass$iv = MarketplaceLocalRankingService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (MarketplaceLocalRankingService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

