/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.execution.ExecutionResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import com.sun.jdi.VirtualMachine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockDebugProcess
extends DebugProcessEvents {
    private static final Logger LOG = Logger.getInstance(MockDebugProcess.class);
    private final MockVirtualMachine myVirtualMachine;
    private VirtualMachineProxyImpl myVirtualMachineProxy;

    public MockDebugProcess(Project project2, MockVirtualMachine virtualMachine, Disposable disposable) {
        super(project2);
        this.myVirtualMachine = virtualMachine;
        this.myState.set(DebugProcessImpl.State.ATTACHED);
        Disposer.register((Disposable)disposable, () -> {
            try {
                this.getManagerThread().close();
                while (!this.getManagerThread().getCurrentRequest().isDone()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.dispose();
            }
        });
    }

    @Nullable
    public ExecutionResult attachVirtualMachine(@NotNull DebugEnvironment environment, @NotNull DebuggerSession session) {
        if (environment == null) {
            MockDebugProcess.$$$reportNull$$$0(0);
        }
        if (session == null) {
            MockDebugProcess.$$$reportNull$$$0(1);
        }
        this.mySession = session;
        return null;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        if (this.myVirtualMachineProxy == null) {
            this.myVirtualMachineProxy = new VirtualMachineProxyImpl((DebugProcessImpl)this, (VirtualMachine)this.myVirtualMachine);
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.myVirtualMachineProxy;
        if (virtualMachineProxyImpl == null) {
            MockDebugProcess.$$$reportNull$$$0(2);
        }
        return virtualMachineProxyImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/MockDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/MockDebugProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachineProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachVirtualMachine";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

