/*
 * Decompiled with CFR 0.152.
 */
package tlschannel.util;

import java.util.logging.Logger;
import javax.net.ssl.SSLEngineResult;

public class Util {
    private static final Logger logger = Logger.getLogger(Util.class.getName());

    public static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError();
        }
    }

    public static String resultToString(SSLEngineResult result) {
        return String.format("status=%s,handshakeStatus=%s,bytesProduced=%d,bytesConsumed=%d", new Object[]{result.getStatus(), result.getHandshakeStatus(), result.bytesProduced(), result.bytesConsumed()});
    }

    public static int getJavaMajorVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int dotPos = version.indexOf(46);
        int dashPos = version.indexOf(45);
        return Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : version.length())));
    }
}

