/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlExporterKt;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlResourceSavingSettings;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B*\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0010J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u001c\u0010\u001a\u001a\u000e\u0018\u00010\u0003\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u00042\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0012H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\"H\u0002J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0012H\u0002R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlExporter;", "", "htmlSource", "", "Lcom/intellij/openapi/util/NlsSafe;", "savingSettings", "Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlResourceSavingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "targetFile", "Ljava/io/File;", "(Ljava/lang/String;Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlResourceSavingSettings;Lcom/intellij/openapi/project/Project;Ljava/io/File;)V", "document", "Lorg/jsoup/nodes/Document;", "kotlin.jvm.PlatformType", "appendInlineStylesContent", "", "styles", "Lorg/jsoup/select/Elements;", "encodeImage", "url", "bytes", "", "export", "getImgUriWithProtocol", "imgSrc", "getRelativeImagePath", "Lorg/jetbrains/annotations/Nullable;", "resDir", "getResource", "getSavedImageFile", "imgUrl", "getStyleContent", "linkElement", "Lorg/jsoup/nodes/Element;", "inlineImagesContent", "images", "processMetaElements", "head", "saveImages", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nHtmlExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlExporter.kt\norg/intellij/plugins/markdown/ui/preview/jcef/HtmlExporter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n179#2,2:165\n1603#3,9:167\n1855#3:176\n1856#3:178\n1612#3:179\n1855#3,2:180\n1855#3,2:182\n1855#3,2:184\n1#4:177\n*S KotlinDebug\n*F\n+ 1 HtmlExporter.kt\norg/intellij/plugins/markdown/ui/preview/jcef/HtmlExporter\n*L\n63#1:165,2\n76#1:167,9\n76#1:176\n76#1:178\n76#1:179\n82#1:180,2\n107#1:182,2\n125#1:184,2\n76#1:177\n*E\n"})
public final class HtmlExporter {
    @NotNull
    private final HtmlResourceSavingSettings savingSettings;
    @NotNull
    private final Project project;
    @NotNull
    private final File targetFile;
    private final Document document;

    public HtmlExporter(@NotNull String htmlSource, @NotNull HtmlResourceSavingSettings savingSettings, @NotNull Project project, @NotNull File targetFile) {
        Intrinsics.checkNotNullParameter((Object)htmlSource, (String)"htmlSource");
        Intrinsics.checkNotNullParameter((Object)savingSettings, (String)"savingSettings");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        this.savingSettings = savingSettings;
        this.project = project;
        this.targetFile = targetFile;
        this.document = Jsoup.parse((String)htmlSource);
    }

    public final void export() {
        Element $this$export_u24lambda_u240 = this.document.head();
        boolean bl = false;
        $this$export_u24lambda_u240.getElementsByTag("script").remove();
        Intrinsics.checkNotNull((Object)$this$export_u24lambda_u240);
        this.processMetaElements($this$export_u24lambda_u240);
        Elements elements2 = $this$export_u24lambda_u240.select("link[rel=\"stylesheet\"]");
        Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"select(...)");
        this.appendInlineStylesContent(elements2);
        Elements images = this.document.body().getElementsByTag("img");
        if (this.savingSettings.isSaved()) {
            Intrinsics.checkNotNull((Object)images);
            this.saveImages(images);
        } else {
            Intrinsics.checkNotNull((Object)images);
            this.inlineImagesContent(images);
        }
        String string = this.document.html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"html(...)");
        FilesKt.writeText$default((File)this.targetFile, (String)string, null, (int)2, null);
    }

    private final void processMetaElements(Element head) {
        Object v1;
        Sequence metas;
        block5: {
            Elements elements2 = head.getElementsByTag("meta");
            Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"getElementsByTag(...)");
            Sequence $this$firstOrNull$iv = metas = CollectionsKt.asSequence((Iterable)((Iterable)elements2));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Element it = (Element)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.attr("http-equiv"), (Object)"Content-Security-Policy")) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        Element csp = v1;
        for (Element element2 : SequencesKt.filterNot((Sequence)metas, (Function1)((Function1)new Function1<Element, Boolean>(csp){
            final /* synthetic */ Element $csp;
            {
                this.$csp = $csp;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Element it) {
                return Intrinsics.areEqual((Object)it, (Object)this.$csp);
            }
        }))) {
            element2.remove();
        }
        if (csp != null) {
            if (HtmlExporterKt.access$getShouldEnforceCsp()) {
                csp.attr("content", HtmlExporterKt.access$getDefaultCspContent$p());
            } else {
                csp.remove();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendInlineStylesContent(Elements styles) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)styles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Element it$iv$iv;
            String content2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element it = (Element)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if ((this.getStyleContent(it) == null ? null : new Element("style").text(content2)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List inlinedStyles = (List)destination$iv$iv;
        styles.remove();
        Iterable $this$forEach$iv = inlinedStyles;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            if (!it.hasText()) continue;
            this.document.head().appendChild((Node)it);
        }
    }

    private final String getStyleContent(Element linkElement) {
        String string;
        String string2 = linkElement.attr("href");
        if (string2 == null) {
            return null;
        }
        String url = string2;
        try {
            string = HttpRequests.request((String)url).readString();
        }
        catch (IOException exception) {
            String name = new File(url).getName();
            Object[] objectArray = new Object[]{name};
            String string3 = MarkdownBundle.message("markdown.export.style.not.found.msg", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            MarkdownNotifications.showWarning$default(MarkdownNotifications.INSTANCE, this.project, "markdown.export.html.missing.style", null, string3, 4, null);
            string = null;
        }
        return string;
    }

    private final void inlineImagesContent(Elements images) {
        Iterable $this$forEach$iv = (Iterable)images;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String string = it.attr("src");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            String imgSrc = this.getImgUriWithProtocol(string);
            byte[] content2 = this.getResource(imgSrc);
            if (content2 == null || !(((CharSequence)imgSrc).length() > 0)) continue;
            it.attr("src", this.encodeImage(imgSrc, content2));
        }
    }

    private final String encodeImage(String url, byte[] bytes) {
        CharSequence extension = FileUtil.getExtension((CharSequence)url, (String)"png");
        CharSequence contentType = Intrinsics.areEqual((Object)extension, (Object)"svg") ? (CharSequence)"svg+xml" : extension;
        Base64.Encoder encoder = Base64.getEncoder();
        return "data:image/" + contentType + ";base64, " + encoder.encode(bytes);
    }

    private final void saveImages(Elements images) {
        Iterable $this$forEach$iv = (Iterable)images;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String imgSrc = it.attr("src");
            Intrinsics.checkNotNull((Object)imgSrc);
            String imgUri = this.getImgUriWithProtocol(imgSrc);
            byte[] content2 = this.getResource(imgUri);
            if (content2 == null || !(((CharSequence)imgSrc).length() > 0)) continue;
            File savedImgFile = this.getSavedImageFile(this.savingSettings.getResourceDir(), imgSrc);
            FileUtil.createIfDoesntExist((File)savedImgFile);
            FilesKt.writeBytes((File)savedImgFile, (byte[])content2);
            String relativeImgPath = this.getRelativeImagePath(this.savingSettings.getResourceDir());
            String[] stringArray = new String[]{relativeImgPath, new File(imgSrc).getName()};
            it.attr("src", FileUtil.join((String[])stringArray));
        }
    }

    private final String getImgUriWithProtocol(String imgSrc) {
        String string;
        if (StringsKt.startsWith$default((String)imgSrc, (String)"file:", (boolean)false, (int)2, null)) {
            string = imgSrc;
        } else {
            String string2 = new File(imgSrc).toURI().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        return string;
    }

    private final byte[] getResource(String url) {
        byte[] byArray;
        try {
            byArray = HttpRequests.request((String)url).readBytes(null);
        }
        catch (IOException exception) {
            String name = new File(url).getName();
            Object[] objectArray = new Object[]{name};
            String string = MarkdownBundle.message("markdown.export.images.not.found.msg", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MarkdownNotifications.showWarning$default(MarkdownNotifications.INSTANCE, this.project, "markdown.export.html.missing.image", null, string, 4, null);
            byArray = null;
        }
        return byArray;
    }

    private final File getSavedImageFile(String resDir, String imgUrl) {
        String[] stringArray = new String[]{resDir, new File(imgUrl).getName()};
        return new File(FileUtil.join((String[])stringArray));
    }

    private final String getRelativeImagePath(String resDir) {
        return FileUtil.getRelativePath((File)this.targetFile.getParentFile(), (File)new File(resDir));
    }
}

