/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\nH\u0016J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/GradleFileModificationTracker;", "Lcom/intellij/openapi/Disposable;", "()V", "alarm", "Lcom/intellij/util/SingleAlarm;", "myCacheRef", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Ljava/nio/file/Path;", "beforeSaving", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "notifyConnectionAboutChangedPaths", "connection", "Lorg/gradle/tooling/ProjectConnection;", "intellij.gradle"})
@ApiStatus.Experimental
public final class GradleFileModificationTracker
implements Disposable {
    @NotNull
    private final AtomicReference<Set<Path>> myCacheRef = new AtomicReference(ConcurrentHashMap.newKeySet());
    @NotNull
    private final SingleAlarm alarm = new SingleAlarm((Runnable)((ContextAwareRunnable)() -> GradleFileModificationTracker.alarm$lambda$0(this)), 5000, (Disposable)this, Alarm.ThreadToUse.POOLED_THREAD, null, 16, null);

    public final void notifyConnectionAboutChangedPaths(@NotNull ProjectConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        ConcurrentHashMap.KeySetView keySetView = this.myCacheRef.getAndSet(ConcurrentHashMap.newKeySet());
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"getAndSet(...)");
        List collection = CollectionsKt.toList((Iterable)keySetView);
        if (!((Collection)collection).isEmpty()) {
            connection.notifyDaemonsAboutChangedPaths(collection);
        }
    }

    public final void beforeSaving(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFileSystem virtualFileSystem = virtualFile.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        VirtualFileSystem vfs = virtualFileSystem;
        Path path = vfs.getNioPath(virtualFile);
        if (path != null) {
            Path it = path;
            boolean bl = false;
            this.myCacheRef.get().add(it);
        }
        SingleAlarm.cancelAndRequest$default((SingleAlarm)this.alarm, (boolean)false, (int)1, null);
    }

    public void dispose() {
    }

    private static final void alarm$lambda$0(GradleFileModificationTracker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.myCacheRef.set(ConcurrentHashMap.newKeySet());
    }
}

