/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.prefix.map.MutablePrefixTreeMap;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;
import org.jetbrains.plugins.gradle.util.GradlePathPrefixTreeFactory;
import org.jetbrains.plugins.gradle.util.GradleTaskData;
import org.jetbrains.plugins.gradle.util.GradleTasksUtilKt;
import org.jetbrains.plugins.gradle.util.ModuleTaskData;
import org.jetbrains.plugins.gradle.util.ProjectTaskData;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a.\u0010\t\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a(\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000b0\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a(\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000b0\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002\u00a8\u0006\u0014"}, d2={"findGradleTasks", "", "Lorg/jetbrains/plugins/gradle/util/ProjectTaskData;", "project", "Lcom/intellij/openapi/project/Project;", "getGradlePath", "", "moduleData", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "getGradleTaskNodesMap", "", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/task/TaskData;", "getGradleTasks", "Lorg/jetbrains/plugins/gradle/util/GradleTaskData;", "getGradleTasksMap", "getModuleTasks", "Lorg/jetbrains/plugins/gradle/util/ModuleTaskData;", "moduleNode", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleTasksUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleTasksUtil.kt\norg/jetbrains/plugins/gradle/util/GradleTasksUtilKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n453#2:125\n403#2:126\n1238#3,2:127\n1549#3:129\n1620#3,3:130\n1241#3:133\n1360#3:134\n1446#3,2:135\n1549#3:137\n1620#3,3:138\n1448#3,3:141\n1549#3:144\n1620#3,3:145\n766#3:148\n857#3,2:149\n*S KotlinDebug\n*F\n+ 1 GradleTasksUtil.kt\norg/jetbrains/plugins/gradle/util/GradleTasksUtilKt\n*L\n35#1:125\n35#1:126\n35#1:127,2\n38#1:129\n38#1:130,3\n35#1:133\n78#1:134\n78#1:135,2\n78#1:137\n78#1:138,3\n78#1:141,3\n89#1:144\n89#1:145,3\n101#1:148\n101#1:149,2\n*E\n"})
public final class GradleTasksUtilKt {
    @ApiStatus.Internal
    @NotNull
    public static final Map<String, MultiMap<String, GradleTaskData>> getGradleTasks(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> GradleTasksUtilKt.getGradleTasks$lambda$0(project2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Map)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, MultiMap<String, GradleTaskData>> getGradleTasksMap(Project project2) {
        void $this$mapValuesTo$iv$iv;
        Map<String, MultiMap<String, DataNode<TaskData>>> $this$mapValues$iv = GradleTasksUtilKt.getGradleTaskNodesMap(project2);
        boolean $i$f$mapValues = false;
        Map<String, MultiMap<String, DataNode<TaskData>>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            MultiMap transformed;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            MultiMap moduleTasks2 = (MultiMap)entry2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)MultiMap.create(), (String)"create(...)");
            for (Map.Entry entry3 : moduleTasks2.entrySet()) {
                Collection<GradleTaskData> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNull((Object)entry3);
                String gradleModulePath = (String)entry3.getKey();
                Collection moduleTaskNodes = (Collection)entry3.getValue();
                Intrinsics.checkNotNull((Object)moduleTaskNodes);
                Iterable iterable = moduleTaskNodes;
                String string2 = gradleModulePath;
                MultiMap multiMap = transformed;
                boolean $i$f$map = false;
                void var25_25 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DataNode dataNode = (DataNode)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    Intrinsics.checkNotNull((Object)gradleModulePath);
                    collection.add(new GradleTaskData((DataNode<TaskData>)it, gradleModulePath));
                }
                collection = (List)destination$iv$iv2;
                multiMap.putValues((Object)string2, (Collection)collection);
            }
            MultiMap multiMap = transformed;
            map3.put(k, multiMap);
        }
        return destination$iv$iv;
    }

    private static final Map<String, MultiMap<String, DataNode<TaskData>>> getGradleTaskNodesMap(Project project2) {
        LinkedHashMap<Object, MultiMap> tasks2 = new LinkedHashMap<Object, MultiMap>();
        for (ProjectTaskData projectTaskData : GradleTasksUtilKt.findGradleTasks(project2)) {
            MultiMap projectTasks;
            Intrinsics.checkNotNullExpressionValue((Object)MultiMap.createOrderedSet(), (String)"createOrderedSet(...)");
            MutablePrefixTreeMap modulePaths = GradlePathPrefixTreeFactory.INSTANCE.createMap(new Pair[0]);
            for (ModuleTaskData moduleTaskData : projectTaskData.getModulesTaskData()) {
                modulePaths.set((Object)moduleTaskData.getGradlePath(), (Object)moduleTaskData.getExternalModulePath());
                projectTasks.putValues((Object)moduleTaskData.getGradlePath(), (Collection)moduleTaskData.getTasks());
            }
            for (Map.Entry entry : ((Map)modulePaths).entrySet()) {
                String gradlePath2 = (String)entry.getKey();
                String externalModulePath = (String)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)tasks2.computeIfAbsent(externalModulePath, arg_0 -> GradleTasksUtilKt.getGradleTaskNodesMap$lambda$3(getGradleTaskNodesMap.moduleTasks.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
                for (String childModulePath : modulePaths.getDescendantKeys((Object)gradlePath2)) {
                    MultiMap moduleTasks2;
                    moduleTasks2.putValues((Object)childModulePath, projectTasks.get((Object)childModulePath));
                }
            }
        }
        return tasks2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ProjectTaskData> findGradleTasks(Project project2) {
        Iterable moduleNode;
        Iterable iterable;
        ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
        MultiMap multiMap = MultiMap.createOrderedSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createOrderedSet(...)");
        MultiMap projects = multiMap;
        for (GradleProjectSettings settings2 : GradleSettings.getInstance(project2).getLinkedProjectsSettings()) {
            Collection moduleNodes;
            Iterator $this$flatMapTo$iv$iv;
            ExternalProjectInfo projectInfo = projectDataManager.getExternalProjectData(project2, GradleConstants.SYSTEM_ID, settings2.getExternalProjectPath());
            GradleProjectSettings.CompositeBuild compositeBuild = settings2.getCompositeBuild();
            List list2 = compositeBuild != null ? compositeBuild.getCompositeParticipants() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List compositeParticipants = list2;
            Iterable $this$flatMap$iv = compositeParticipants;
            boolean $i$f$flatMap = false;
            iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                Object element$iv$iv = iterator.next();
                BuildParticipant it = (BuildParticipant)element$iv$iv;
                boolean bl = false;
                Set<String> set = it.getProjects();
                Intrinsics.checkNotNullExpressionValue(set, (String)"getProjects(...)");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void module;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to((Object)module, (Object)it.getRootPath()));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Map compositeProjects = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            ExternalProjectInfo externalProjectInfo = projectInfo;
            if (externalProjectInfo == null || (externalProjectInfo = externalProjectInfo.getExternalProjectStructure()) == null) continue;
            ExternalProjectInfo projectNode = externalProjectInfo;
            Intrinsics.checkNotNullExpressionValue((Object)ExternalSystemApiUtil.getChildren((DataNode)projectNode, (Key)ProjectKeys.MODULE), (String)"getChildren(...)");
            $this$flatMapTo$iv$iv = moduleNodes.iterator();
            while ($this$flatMapTo$iv$iv.hasNext()) {
                String externalModulePath;
                moduleNode = (DataNode)$this$flatMapTo$iv$iv.next();
                Intrinsics.checkNotNullExpressionValue((Object)((ModuleData)moduleNode.getData()).getLinkedExternalProjectPath(), (String)"getLinkedExternalProjectPath(...)");
                String string3 = (String)compositeProjects.get(externalModulePath);
                if (string3 == null) {
                    string3 = settings2.getExternalProjectPath();
                }
                String projectPath = string3;
                projects.putValue((Object)projectPath, (Object)moduleNode);
            }
        }
        ArrayList<ProjectTaskData> projectTasksData = new ArrayList<ProjectTaskData>();
        for (Map.Entry entry : projects.entrySet()) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNull((Object)entry);
            String externalProjectPath2 = (String)entry.getKey();
            Collection modulesNodes = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)modulesNodes);
            Iterable $this$map$iv = modulesNodes;
            boolean $i$f$map = false;
            moduleNode = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                DataNode bl = (DataNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(GradleTasksUtilKt.getModuleTasks((DataNode<ModuleData>)p0));
            }
            List modulesTaskData = (List)destination$iv$iv;
            Object object = (ModuleTaskData)CollectionsKt.firstOrNull((List)modulesTaskData);
            String taskProjectPath = object != null && (object = ((ModuleTaskData)object).getTasks()) != null && (object = (DataNode)CollectionsKt.firstOrNull((List)object)) != null && (object = (TaskData)object.getData()) != null ? object.getLinkedExternalProjectPath() : null;
            String string4 = taskProjectPath;
            if (string4 == null) {
                string4 = externalProjectPath2;
            }
            iterable = string4;
            Intrinsics.checkNotNull((Object)iterable);
            projectTasksData.add(new ProjectTaskData((String)((Object)iterable), modulesTaskData));
        }
        return projectTasksData;
    }

    /*
     * WARNING - void declaration
     */
    private static final ModuleTaskData getModuleTasks(DataNode<ModuleData> moduleNode) {
        String string2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object object = moduleNode.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        ModuleData moduleData = (ModuleData)object;
        String string3 = moduleData.getLinkedExternalProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLinkedExternalProjectPath(...)");
        String externalModulePath = string3;
        String string4 = GradleModuleDataKt.getGradleIdentityPathOrNull(moduleData);
        if (string4 == null || (string4 = StringsKt.removeSuffix((String)string4, (CharSequence)":")) == null) {
            string4 = GradleTasksUtilKt.getGradlePath(moduleData);
        }
        String gradlePath2 = string4;
        Collection collection = ExternalSystemApiUtil.getChildren(moduleNode, (Key)ProjectKeys.TASK);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildren(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataNode it = (DataNode)element$iv$iv;
            boolean bl = false;
            String string5 = ((TaskData)it.getData()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
            boolean bl2 = ((CharSequence)string5).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tasks2 = (List)destination$iv$iv;
        Object object2 = (DataNode)CollectionsKt.firstOrNull((List)tasks2);
        String taskPathPrefix = StringKt.nullize$default(object2 != null && (object2 = (TaskData)object2.getData()) != null && (object2 = object2.getName()) != null ? StringsKt.substringBeforeLast((String)object2, (char)':', (String)"") : null, (boolean)false, (int)1, null);
        DataNode dataNode = (DataNode)CollectionsKt.firstOrNull((List)tasks2);
        String linkedExternalProjectPath = dataNode != null && (dataNode = (TaskData)dataNode.getData()) != null ? dataNode.getLinkedExternalProjectPath() : null;
        String string6 = linkedExternalProjectPath;
        if (string6 == null) {
            string6 = externalModulePath;
        }
        if ((string2 = taskPathPrefix) == null) {
            string2 = gradlePath2;
        }
        return new ModuleTaskData(string6, string2, tasks2);
    }

    @Deprecated(message="Fallback method for backward compatibility. Use ModuleData.gradleIdentityPath instead")
    @NotNull
    public static final String getGradlePath(@NotNull ModuleData moduleData) {
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        String string2 = moduleData.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        String externalProjectId = string2;
        boolean trimSourceSet = moduleData instanceof GradleSourceSetData;
        List list2 = StringUtil.split((String)externalProjectId, (String)":");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"split(...)");
        List pathParts = list2;
        if (!StringsKt.startsWith$default((String)externalProjectId, (String)":", (boolean)false, (int)2, null) && !pathParts.isEmpty()) {
            pathParts = pathParts.subList(1, pathParts.size());
        }
        if (trimSourceSet && !pathParts.isEmpty()) {
            pathParts = pathParts.subList(0, pathParts.size() - 1);
        }
        String string3 = StringUtil.join((Collection)pathParts, (String)":");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(...)");
        String join = string3;
        return ((CharSequence)join).length() == 0 ? ":" : ":" + join;
    }

    private static final CachedValueProvider.Result getGradleTasks$lambda$0(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Object[] objectArray = new Object[]{ExternalProjectsDataStorage.getInstance((Project)$project)};
        return CachedValueProvider.Result.create(GradleTasksUtilKt.getGradleTasksMap($project), (Object[])objectArray);
    }

    private static final MultiMap getGradleTaskNodesMap$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MultiMap)$tmp0.invoke(p0);
    }
}

