/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.ide.startup.importSettings.chooser.ui.WizardPageTrackerKt;
import com.intellij.platform.ide.bootstrap.IdeStartupWizardCollector;
import com.intellij.platform.ide.bootstrap.StartupWizardStage;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u000b\u001a\u00020\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/WizardPageTracker;", "", "()V", "currentStage", "Lcom/intellij/platform/ide/bootstrap/StartupWizardStage;", "lastEnterTimeNs", "", "Ljava/lang/Long;", "onEnter", "", "stage", "onLeave", "intellij.ide.startup.importSettings"})
public final class WizardPageTracker {
    @Nullable
    private Long lastEnterTimeNs;
    @Nullable
    private StartupWizardStage currentStage;

    public final void onEnter(@Nullable StartupWizardStage stage) {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.currentStage != null) {
            WizardPageTrackerKt.access$getLogger$p().error("Logic error: entered page " + stage + " while still on page " + this.currentStage + ".");
        }
        this.lastEnterTimeNs = System.nanoTime();
        this.currentStage = stage;
    }

    public final void onLeave() {
        StartupWizardStage startupWizardStage = this.currentStage;
        if (startupWizardStage == null) {
            return;
        }
        StartupWizardStage stage = startupWizardStage;
        ThreadingAssertions.assertEventDispatchThread();
        Long enterTimeNs = this.lastEnterTimeNs;
        long leaveTimeNs = System.nanoTime();
        if (enterTimeNs == null) {
            return;
        }
        Duration duration = Duration.ofNanos(leaveTimeNs - enterTimeNs);
        Intrinsics.checkNotNull((Object)duration);
        IdeStartupWizardCollector.INSTANCE.logStartupStageTime(stage, duration);
        this.lastEnterTimeNs = null;
        this.currentStage = null;
    }
}

