/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.db;

import com.intellij.ide.startup.importSettings.providers.vswin.utilities.RunConfigurationEnvironmentUtils;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/startup/importSettings/db/WindowsEnvVariables;", "", "()V", "applicationData", "", "getApplicationData", "()Ljava/lang/String;", "localApplicationData", "getLocalApplicationData", "userProfile", "getUserProfile", "expandPath", "path", "get", "variable", "intellij.ide.startup.importSettings"})
public final class WindowsEnvVariables {
    @NotNull
    public static final WindowsEnvVariables INSTANCE = new WindowsEnvVariables();
    @NotNull
    private static final String applicationData = String.valueOf(INSTANCE.get("APPDATA"));
    @NotNull
    private static final String localApplicationData = String.valueOf(INSTANCE.get("LOCALAPPDATA"));
    @NotNull
    private static final String userProfile = String.valueOf(INSTANCE.get("USERPROFILE"));

    private WindowsEnvVariables() {
    }

    @NotNull
    public final String getApplicationData() {
        return applicationData;
    }

    @NotNull
    public final String getLocalApplicationData() {
        return localApplicationData;
    }

    @NotNull
    public final String getUserProfile() {
        return userProfile;
    }

    @Nullable
    public final String get(@NotNull String variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        String string = System.getenv().get(variable);
        if (string == null) {
            Map<String, String> map = System.getenv();
            String string2 = variable;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            string = map.get(string3);
        }
        return string;
    }

    @Nullable
    public final String expandPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return RunConfigurationEnvironmentUtils.INSTANCE.expandVariables("%", "%", path, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)INSTANCE){

            @Nullable
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((WindowsEnvVariables)this.receiver).get(p0);
            }
        }), false, null);
    }
}

