/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.collection;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;

public class ProjectTransitivityFilter
extends AbstractArtifactsFilter {
    private boolean excludeTransitive;
    private Set<Artifact> directDependencies;

    public ProjectTransitivityFilter(Set<Artifact> directDependencies, boolean excludeTransitive) {
        this.excludeTransitive = excludeTransitive;
        this.directDependencies = directDependencies;
    }

    @Override
    public Set<Artifact> filter(Set<Artifact> artifacts) {
        Set<Artifact> result = artifacts;
        if (this.excludeTransitive) {
            result = new LinkedHashSet<Artifact>();
            for (Artifact artifact : artifacts) {
                if (!this.artifactIsADirectDependency(artifact)) continue;
                result.add(artifact);
            }
        }
        return result;
    }

    public boolean artifactIsADirectDependency(Artifact artifact) {
        for (Artifact dependency : this.directDependencies) {
            if (!dependency.equals(artifact)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    public void setExcludeTransitive(boolean excludeTransitive) {
        this.excludeTransitive = excludeTransitive;
    }
}

