/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config._private.ConfigMessages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SecretKeysHandlerConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = -5228028387733656005L;
    private final boolean enabled;
    private final Map<String, SecretKeysHandler> handlers = new HashMap<String, SecretKeysHandler>();

    public SecretKeysHandlerConfigSourceInterceptor(boolean enabled, List<SecretKeysHandler> handlers) {
        this.enabled = enabled;
        for (SecretKeysHandler handler : handlers) {
            this.handlers.put(handler.getName(), handler);
        }
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        String handler;
        ConfigValue configValue = context.proceed(name);
        if (this.enabled && configValue != null && configValue.getValue() != null && (handler = configValue.getExtendedExpressionHandler()) != null) {
            return configValue.withValue(this.getHandler(handler, context).decode(configValue.getValue()));
        }
        return configValue;
    }

    private SecretKeysHandler getHandler(String handlerName, final ConfigSourceInterceptorContext context) {
        SecretKeysHandler handler = this.handlers.get(handlerName);
        if (handler == null) {
            throw ConfigMessages.msg.secretKeyHandlerNotFound(handlerName);
        }
        if (handler instanceof SecretKeysHandlerFactory.LazySecretKeysHandler) {
            handler = ((SecretKeysHandlerFactory.LazySecretKeysHandler)handler).get(new ConfigSourceContext(){

                @Override
                public ConfigValue getValue(String name) {
                    return context.proceed(name);
                }

                @Override
                public List<String> getProfiles() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Iterator<String> iterateNames() {
                    return context.iterateNames();
                }
            });
        }
        return handler;
    }
}

