/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class InferredBasicValueResolution<J, T>
implements BasicValue.Resolution<J> {
    private final JavaType<J> domainJtd;
    private final JavaType<T> relationalJtd;
    private final JdbcType jdbcType;
    private final MutabilityPlan<J> mutabilityPlan;
    private final JdbcMapping jdbcMapping;
    private final BasicType<J> legacyType;

    public InferredBasicValueResolution(JdbcMapping jdbcMapping, JavaType<J> domainJtd, JavaType<T> relationalJtd, JdbcType jdbcType, BasicType<J> legacyType, MutabilityPlan<J> mutabilityPlan) {
        this.jdbcMapping = jdbcMapping;
        this.legacyType = legacyType;
        this.domainJtd = domainJtd;
        this.relationalJtd = relationalJtd;
        this.jdbcType = jdbcType;
        this.mutabilityPlan = mutabilityPlan == null ? domainJtd.getMutabilityPlan() : mutabilityPlan;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public BasicType<J> getLegacyResolvedBasicType() {
        return this.legacyType;
    }

    @Override
    public JavaType<J> getDomainJavaType() {
        return this.domainJtd;
    }

    @Override
    public JavaType<?> getRelationalJavaType() {
        return this.relationalJtd;
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public BasicValueConverter<J, T> getValueConverter() {
        return this.jdbcMapping.getValueConverter();
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }
}

