/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.lang.reflect.Array;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.jdbc.DelegatingJdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class JsonArrayViaElementArgumentReturnTypeResolver
implements FunctionReturnTypeResolver {
    public static final FunctionReturnTypeResolver INSTANCE = new JsonArrayViaElementArgumentReturnTypeResolver();

    private JsonArrayViaElementArgumentReturnTypeResolver() {
    }

    @Override
    public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, Supplier<MappingModelExpressible<?>> inferredTypeSupplier, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
        MappingModelExpressible<?> inferredType = inferredTypeSupplier.get();
        if (inferredType != null) {
            if (inferredType instanceof ReturnableType) {
                return (ReturnableType)((Object)inferredType);
            }
            if (inferredType instanceof BasicValuedMapping) {
                return (ReturnableType)((Object)((BasicValuedMapping)inferredType).getJdbcMapping());
            }
        }
        if (impliedType != null) {
            return impliedType;
        }
        for (SqmTypedNode<?> argument : arguments) {
            DomainType<?> sqmType = argument.getExpressible().getSqmType();
            if (!(sqmType instanceof ReturnableType)) continue;
            return JsonArrayViaElementArgumentReturnTypeResolver.resolveJsonArrayType(sqmType, typeConfiguration);
        }
        return null;
    }

    @Override
    public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
        return null;
    }

    public static BasicType<?> resolveJsonArrayType(DomainType<?> elementType, TypeConfiguration typeConfiguration) {
        BasicPluralJavaType arrayJavaType = (BasicPluralJavaType)((Object)typeConfiguration.getJavaTypeRegistry().getDescriptor(Array.newInstance(elementType.getBindableJavaType(), 0).getClass()));
        Dialect dialect = typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
        DelegatingJdbcTypeIndicators jdbcTypeIndicators = new DelegatingJdbcTypeIndicators(typeConfiguration.getCurrentBaseSqlTypeIndicators()){

            @Override
            public Integer getExplicitJdbcTypeCode() {
                return 3001;
            }
        };
        return arrayJavaType.resolveType(typeConfiguration, dialect, (BasicType)elementType, null, jdbcTypeIndicators);
    }
}

