/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.util.Map;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.enhanced.ImplicitDatabaseObjectNamingStrategy;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;

public class LegacyNamingStrategy
implements ImplicitDatabaseObjectNamingStrategy {
    public static final String STRATEGY_NAME = "legacy";

    @Override
    public QualifiedName determineSequenceName(Identifier catalogName, Identifier schemaName, Map<?, ?> configValues, ServiceRegistry serviceRegistry) {
        String sequenceName = this.implicitSequenceName(configValues);
        if (sequenceName.contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(sequenceName);
        }
        return new QualifiedSequenceName(catalogName, schemaName, serviceRegistry.getService(JdbcEnvironment.class).getIdentifierHelper().toIdentifier(sequenceName));
    }

    private String implicitSequenceName(Map<?, ?> configValues) {
        String rootTableName;
        String base;
        String explicitSuffix = ConfigurationHelper.getString("sequence_per_entity_suffix", configValues);
        if (StringHelper.isNotEmpty(explicitSuffix) && StringHelper.isNotEmpty(base = ConfigurationHelper.getString("implicit_name_base", configValues, rootTableName = ConfigurationHelper.getString("target_table", configValues)))) {
            return Identifier.isQuoted(base) ? "`" + Identifier.unQuote(base) + explicitSuffix + "`" : base + explicitSuffix;
        }
        String annotationGeneratorName = ConfigurationHelper.getString("GENERATOR_NAME", configValues);
        return StringHelper.isNotEmpty(annotationGeneratorName) ? annotationGeneratorName : "hibernate_sequence";
    }

    @Override
    public QualifiedName determineTableName(Identifier catalogName, Identifier schemaName, Map<?, ?> configValues, ServiceRegistry serviceRegistry) {
        String implicitName = this.implicitTableName(configValues);
        if (implicitName.contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(implicitName);
        }
        JdbcEnvironment jdbcEnvironment = serviceRegistry.getService(JdbcEnvironment.class);
        return new QualifiedNameParser.NameParts(catalogName, schemaName, jdbcEnvironment.getIdentifierHelper().toIdentifier(implicitName));
    }

    private String implicitTableName(Map<?, ?> configValues) {
        String annotationName = ConfigurationHelper.getString("GENERATOR_NAME", configValues);
        return StringHelper.isNotEmpty(annotationName) ? annotationName : "hibernate_sequences";
    }
}

